/*
 * Decompiled with CFR 0.152.
 */
package polyglot.qq;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java_cup.runtime.Symbol;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceFile;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.ExtensionInfo;
import polyglot.lex.Lexer;
import polyglot.main.Report;
import polyglot.qq.Grm;
import polyglot.qq.Lexer_c;
import polyglot.qq.QQError;
import polyglot.qq.QQParser;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;

public class QQ {
    protected ExtensionInfo ext;
    protected Position pos;
    protected static final int EXPR = 0;
    protected static final int STMT = 1;
    protected static final int TYPE = 2;
    protected static final int MEMB = 3;
    protected static final int DECL = 4;
    protected static final int FILE = 5;

    public QQ(ExtensionInfo ext) {
        this(ext, null);
    }

    public QQ(ExtensionInfo ext, Position pos) {
        this.ext = ext;
        this.pos = pos;
    }

    public SourceFile parseFile(String fmt, Object ... os) {
        return (SourceFile)this.parse(5, fmt, os);
    }

    @Deprecated
    public SourceFile parseFile(String fmt, List<?> subst) {
        return (SourceFile)this.parse(5, fmt, subst.toArray());
    }

    public ClassDecl parseDecl(String fmt, Object ... os) {
        return (ClassDecl)this.parse(4, fmt, os);
    }

    @Deprecated
    public ClassDecl parseDecl(String fmt, List<?> subst) {
        return (ClassDecl)this.parse(4, fmt, subst.toArray());
    }

    public ClassMember parseMember(String fmt, Object ... os) {
        return (ClassMember)this.parse(3, fmt, os);
    }

    @Deprecated
    public ClassMember parseMember(String fmt, List<?> subst) {
        return (ClassMember)this.parse(3, fmt, subst.toArray());
    }

    public Expr parseExpr(String fmt, Object ... os) {
        return (Expr)this.parse(0, fmt, os);
    }

    @Deprecated
    public Expr parseExpr(String fmt, List<?> subst) {
        return (Expr)this.parse(0, fmt, subst.toArray());
    }

    public Stmt parseStmt(String fmt, Object ... os) {
        return (Stmt)this.parse(1, fmt, os);
    }

    @Deprecated
    public Stmt parseStmt(String fmt, List<?> subst) {
        return (Stmt)this.parse(1, fmt, subst.toArray());
    }

    public TypeNode parseType(String fmt, Object ... os) {
        return (TypeNode)this.parse(2, fmt, os);
    }

    @Deprecated
    public TypeNode parseType(String fmt, List<?> subst) {
        return (TypeNode)this.parse(2, fmt, subst.toArray());
    }

    protected Lexer lexer(String fmt, Position pos, Object ... subst) {
        return new Lexer_c(fmt, pos, subst);
    }

    protected QQParser parser(Lexer lexer, TypeSystem ts, NodeFactory nf, ErrorQueue eq) {
        return new Grm(lexer, ts, nf, eq);
    }

    protected Position type_position(TypeObject t) {
        Position p = t.position();
        if (p == null) {
            p = Position.compilerGenerated(0);
        }
        return p;
    }

    protected Node parse(int kind, String fmt, Object ... subst) {
        TypeSystem ts = this.ext.typeSystem();
        NodeFactory nf = this.ext.nodeFactory();
        ErrorQueue eq = this.ext.compiler().errorQueue();
        for (int i = 0; i < subst.length; ++i) {
            Object o = subst[i];
            if (o instanceof Type) {
                Type t = (Type)o;
                subst[i] = nf.CanonicalTypeNode(this.type_position(t), t);
                continue;
            }
            if (!(o instanceof List)) continue;
            List l = (List)o;
            ListIterator<CanonicalTypeNode> j = l.listIterator();
            while (j.hasNext()) {
                Object p = j.next();
                if (!(p instanceof Type)) continue;
                Type t = (Type)p;
                j.set(nf.CanonicalTypeNode(this.type_position(t), t));
            }
        }
        Position pos = this.pos;
        if (pos == null) {
            pos = Position.compilerGenerated(3);
        }
        Lexer lexer = this.lexer(fmt, pos, subst);
        QQParser grm = this.parser(lexer, ts, nf, eq);
        if (Report.should_report("qq", 1)) {
            Report.report(1, "qq: " + fmt);
            Report.report(1, "subst: " + subst);
        }
        try {
            Symbol sym2;
            switch (kind) {
                case 0: {
                    sym2 = grm.qq_expr();
                    break;
                }
                case 1: {
                    sym2 = grm.qq_stmt();
                    break;
                }
                case 2: {
                    sym2 = grm.qq_type();
                    break;
                }
                case 3: {
                    sym2 = grm.qq_member();
                    break;
                }
                case 4: {
                    sym2 = grm.qq_decl();
                    break;
                }
                case 5: {
                    sym2 = grm.qq_file();
                    break;
                }
                default: {
                    throw new QQError("bad quasi-quoting kind: " + kind, pos);
                }
            }
            if (sym2 != null && sym2.value instanceof Node) {
                Node n = (Node)sym2.value;
                if (Report.should_report("qq", 1)) {
                    Report.report(1, "result: " + n);
                }
                return n;
            }
            throw new QQError("Unable to parse: \"" + fmt + "\".", pos);
        }
        catch (IOException e) {
            throw new QQError("Unable to parse: \"" + fmt + "\".", pos);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QQError("Unable to parse: \"" + fmt + "\"; " + e.getMessage(), pos);
        }
    }
}

