/*
 * Decompiled with CFR 0.152.
 */
package polyglot.main;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import polyglot.main.UsageError;
import polyglot.util.InternalCompilerError;

public abstract class OptFlag<T>
implements Comparable<OptFlag<T>> {
    protected final Kind kind;
    protected final Set<String> ids;
    protected final String params;
    protected final String usage;
    protected final String defaultValue;
    private static final int USAGE_SCREEN_WIDTH = 76;
    private static final int USAGE_FLAG_WIDTH = 27;

    public static boolean removeFlag(String id, Set<OptFlag<?>> flags) {
        Iterator<OptFlag<?>> it = flags.iterator();
        while (it.hasNext()) {
            OptFlag<?> flag = it.next();
            if (!flag.ids.contains(id)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public static OptFlag<?> lookupFlag(String id, Set<OptFlag<?>> flags) {
        for (OptFlag<?> flag : flags) {
            if (!flag.ids.contains(id)) continue;
            return flag;
        }
        return null;
    }

    public static boolean hasSourceArg(List<Arg<?>> arguments) {
        for (Arg<?> arg : arguments) {
            if (arg.flag != null) continue;
            return true;
        }
        return false;
    }

    public static List<Arg<?>> sourceArgs(List<Arg<?>> arguments) {
        ArrayList matches = new ArrayList();
        for (Arg<?> arg : arguments) {
            if (arg.flag != null) continue;
            matches.add(arg);
        }
        return matches;
    }

    public static Arg<?> lookup(String id, List<Arg<?>> args) {
        for (Arg<?> arg : args) {
            if (arg.flag == null || !arg.flag.ids.contains(id)) continue;
            return arg;
        }
        return null;
    }

    public static List<Arg<?>> lookupAll(String id, List<Arg<?>> args) {
        ArrayList matches = new ArrayList();
        for (Arg<?> arg : args) {
            if (arg.flag == null || !arg.flag.ids.contains(id)) continue;
            matches.add(arg);
        }
        return matches;
    }

    public String toString() {
        return this.ids.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OptFlag) {
            OptFlag that = (OptFlag)obj;
            return this.kind == that.kind && this.ids.equals(that.ids);
        }
        return false;
    }

    public int hashCode() {
        return this.kind.hashCode() ^ this.ids.hashCode();
    }

    @Override
    public int compareTo(OptFlag<T> flag) {
        for (String id1 : this.ids) {
            Iterator<String> iterator = flag.ids().iterator();
            if (!iterator.hasNext()) continue;
            String id2 = iterator.next();
            int cmp = id1.compareToIgnoreCase(id2);
            return cmp == 0 ? id1.compareTo(id2) : cmp;
        }
        throw new InternalCompilerError("Empty ids!");
    }

    public OptFlag(String id, String params, String usage) {
        this(id, params, usage, null);
    }

    public OptFlag(String id, String params, String usage, int defaultValue) {
        this(id, params, usage, Integer.toString(defaultValue));
    }

    public OptFlag(String id, String params, String usage, String defaultValue) {
        this(new String[]{id}, params, usage, defaultValue);
    }

    public OptFlag(String[] ids, String params, String usage) {
        this(ids, params, usage, null);
    }

    public OptFlag(String[] ids, String params, String usage, int defaultValue) {
        this(ids, params, usage, Integer.toString(defaultValue));
    }

    public OptFlag(String[] ids, String params, String usage, String defaultValue) {
        this(Kind.MAIN, ids, params, usage, defaultValue);
    }

    public OptFlag(Kind kind, String id, String params, String usage) {
        this(kind, id, params, usage, null);
    }

    public OptFlag(Kind kind, String id, String params, String usage, int defaultValue) {
        this(kind, id, params, usage, Integer.toString(defaultValue));
    }

    public OptFlag(Kind kind, String id, String params, String usage, String defaultValue) {
        this(kind, new String[]{id}, params, usage, defaultValue);
    }

    public OptFlag(Kind kind, String[] ids, String params, String usage) {
        this(kind, ids, params, usage, null);
    }

    public OptFlag(Kind kind, String[] ids, String params, String usage, int defaultValue) {
        this(kind, ids, params, usage, Integer.toString(defaultValue));
    }

    public OptFlag(Kind kind, String[] ids, String params, String usage, String defaultValue) {
        this.kind = kind;
        this.ids = new LinkedHashSet<String>(ids.length);
        for (String flag : ids) {
            this.ids.add(flag);
        }
        this.params = params;
        this.defaultValue = defaultValue;
        if (defaultValue != null) {
            usage = usage + " (default: " + defaultValue + ")";
        }
        this.usage = usage;
    }

    public Kind kind() {
        return this.kind;
    }

    public Set<String> ids() {
        return this.ids;
    }

    public abstract Arg<T> handle(String[] var1, int var2) throws UsageError;

    public Arg<T> defaultArg(List<Arg<?>> arguments) {
        return this.defaultArg();
    }

    public Arg<T> defaultArg() {
        if (this.defaultValue != null) {
            throw new UnsupportedOperationException("Usage for " + this.ids() + " specifies a default value, but flag does not implement one.");
        }
        return null;
    }

    public Arg<T> createArg(int next, T value) {
        return new Arg<T>(this, next, value);
    }

    public Arg<T> createDefault(T value) {
        return new Arg<T>(this, -1, value);
    }

    public void printUsage(PrintStream out) {
        String flagID = this.ids.iterator().next();
        if (this.params != null && !this.params.equals("")) {
            flagID = flagID + " " + this.params;
        }
        out.print("  ");
        out.print(flagID);
        int cur = flagID.length() + 2;
        if (cur < 27) {
            OptFlag.printSpaces(out, 27 - cur);
        } else {
            out.println();
            OptFlag.printSpaces(out, 27);
        }
        cur = 27;
        StringTokenizer st = new StringTokenizer(this.usage);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (cur + s.length() > 76) {
                out.println();
                OptFlag.printSpaces(out, 27);
                cur = 27;
            }
            out.print(s);
            cur += s.length();
            if (!st.hasMoreTokens()) continue;
            if (cur + 1 > 76) {
                out.println();
                OptFlag.printSpaces(out, 27);
                cur = 27;
                continue;
            }
            out.print(" ");
            ++cur;
        }
        out.println();
    }

    private static void printSpaces(PrintStream out, int n) {
        while (n-- > 0) {
            out.print(' ');
        }
    }

    public static class DoubleFlag
    extends OptFlag<Double> {
        @Override
        public Arg<Double> handle(String[] args, int index) {
            return this.createArg(index + 1, Double.parseDouble(args[index]));
        }

        @Override
        public Arg<Double> defaultArg() {
            if (this.defaultValue == null) {
                return null;
            }
            return this.createDefault(new Double(this.defaultValue));
        }

        public DoubleFlag(Kind kind, String id, String params, String usage, double defaultValue) {
            super(kind, id, params, usage, Double.toString(defaultValue));
        }

        public DoubleFlag(Kind kind, String id, String params, String usage) {
            super(kind, id, params, usage);
        }

        public DoubleFlag(Kind kind, String[] ids, String params, String usage, double defaultValue) {
            super(kind, ids, params, usage, Double.toString(defaultValue));
        }

        public DoubleFlag(Kind kind, String[] ids, String params, String usage) {
            super(kind, ids, params, usage);
        }

        public DoubleFlag(String id, String params, String usage, double defaultValue) {
            super(id, params, usage, Double.toString(defaultValue));
        }

        public DoubleFlag(String id, String params, String usage) {
            super(id, params, usage);
        }

        public DoubleFlag(String[] ids, String params, String usage, double defaultValue) {
            super(ids, params, usage, Double.toString(defaultValue));
        }

        public DoubleFlag(String[] ids, String params, String usage) {
            super(ids, params, usage);
        }
    }

    public static class IntFlag
    extends OptFlag<Integer> {
        @Override
        public Arg<Integer> handle(String[] args, int index) {
            return this.createArg(index + 1, Integer.parseInt(args[index]));
        }

        @Override
        public Arg<Integer> defaultArg() {
            if (this.defaultValue == null) {
                return null;
            }
            return this.createDefault(new Integer(this.defaultValue));
        }

        public IntFlag(Kind kind, String id, String params, String usage, int defaultValue) {
            super(kind, id, params, usage, defaultValue);
        }

        public IntFlag(Kind kind, String id, String params, String usage) {
            super(kind, id, params, usage);
        }

        public IntFlag(Kind kind, String[] ids, String params, String usage, int defaultValue) {
            super(kind, ids, params, usage, defaultValue);
        }

        public IntFlag(Kind kind, String[] ids, String params, String usage) {
            super(kind, ids, params, usage);
        }

        public IntFlag(String id, String params, String usage, int defaultValue) {
            super(id, params, usage, defaultValue);
        }

        public IntFlag(String id, String params, String usage) {
            super(id, params, usage);
        }

        public IntFlag(String[] ids, String params, String usage, int defaultValue) {
            super(ids, params, usage, defaultValue);
        }

        public IntFlag(String[] ids, String params, String usage) {
            super(ids, params, usage);
        }
    }

    public static class Switch
    extends OptFlag<Boolean> {
        protected final boolean value;
        protected final boolean defaultValue;

        @Override
        public Arg<Boolean> handle(String[] args, int index) {
            return this.createArg(index, this.value);
        }

        @Override
        public Arg<Boolean> defaultArg() {
            return this.createDefault(this.defaultValue);
        }

        public Switch(Kind kind, String id, String usage, boolean value) {
            this(kind, id, usage, value, !value);
        }

        public Switch(Kind kind, String id, String usage, boolean value, boolean defaultValue) {
            super(kind, id, null, usage);
            this.value = value;
            this.defaultValue = defaultValue;
        }

        public Switch(Kind kind, String id, String usage) {
            this(kind, id, usage, true);
        }

        public Switch(Kind kind, String[] ids, String usage, boolean value) {
            this(kind, ids, usage, value, !value);
        }

        public Switch(Kind kind, String[] ids, String usage, boolean value, boolean defaultValue) {
            super(kind, ids, null, usage);
            this.value = value;
            this.defaultValue = defaultValue;
        }

        public Switch(Kind kind, String[] ids, String usage) {
            this(kind, ids, usage, true);
        }

        public Switch(String id, String usage, boolean value) {
            this(id, usage, value, !value);
        }

        public Switch(String id, String usage, boolean value, boolean defaultValue) {
            super(id, null, usage);
            this.value = value;
            this.defaultValue = defaultValue;
        }

        public Switch(String id, String usage) {
            this(id, usage, true);
        }

        public Switch(String[] ids, String usage, boolean value) {
            this(ids, usage, value, !value);
        }

        public Switch(String[] ids, String usage, boolean value, boolean defaultValue) {
            super(ids, null, usage);
            this.value = value;
            this.defaultValue = defaultValue;
        }

        public Switch(String[] ids, String usage) {
            this(ids, usage, true);
        }
    }

    public static abstract class PathFlag<T>
    extends OptFlag<List<T>> {
        public abstract T handlePathEntry(String var1);

        @Override
        public Arg<List<T>> handle(String[] args, int index) {
            ArrayList<T> path = new ArrayList<T>();
            StringTokenizer st = new StringTokenizer(args[index], File.pathSeparator);
            while (st.hasMoreTokens()) {
                T next = this.handlePathEntry(st.nextToken());
                if (next == null) continue;
                path.add(next);
            }
            return this.createArg(index + 1, path);
        }

        public PathFlag(Kind kind, String id, String params, String usage, int defaultValue) {
            super(kind, id, params, usage, defaultValue);
        }

        public PathFlag(Kind kind, String id, String params, String usage, String defaultValue) {
            super(kind, id, params, usage, defaultValue);
        }

        public PathFlag(Kind kind, String id, String params, String usage) {
            super(kind, id, params, usage);
        }

        public PathFlag(Kind kind, String[] ids, String params, String usage, int defaultValue) {
            super(kind, ids, params, usage, defaultValue);
        }

        public PathFlag(Kind kind, String[] ids, String params, String usage, String defaultValue) {
            super(kind, ids, params, usage, defaultValue);
        }

        public PathFlag(Kind kind, String[] ids, String params, String usage) {
            super(kind, ids, params, usage);
        }

        public PathFlag(String id, String params, String usage, int defaultValue) {
            super(id, params, usage, defaultValue);
        }

        public PathFlag(String id, String params, String usage, String defaultValue) {
            super(id, params, usage, defaultValue);
        }

        public PathFlag(String id, String params, String usage) {
            super(id, params, usage);
        }

        public PathFlag(String[] ids, String params, String usage, int defaultValue) {
            super(ids, params, usage, defaultValue);
        }

        public PathFlag(String[] ids, String params, String usage, String defaultValue) {
            super(ids, params, usage, defaultValue);
        }

        public PathFlag(String[] ids, String params, String usage) {
            super(ids, params, usage);
        }
    }

    public static class Arg<T> {
        protected final OptFlag<T> flag;
        protected final T value;
        protected final int next;

        public Arg(int next, T value) {
            this(null, next, value);
        }

        public Arg(OptFlag<T> flag, int next, T value) {
            this.flag = flag;
            this.next = next;
            this.value = value;
        }

        public OptFlag<T> flag() {
            return this.flag;
        }

        public int next() {
            return this.next;
        }

        public T value() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.flag == null) {
                sb.append(this.value());
            } else {
                sb.append(this.flag.ids().toString());
                if (this.flag.params != null) {
                    sb.append(" ");
                    sb.append(this.value());
                } else if (!((Boolean)this.value()).booleanValue()) {
                    return "";
                }
            }
            return sb.toString();
        }
    }

    public static enum Kind {
        MAIN,
        DEBUG,
        VERSION,
        HELP,
        SECRET,
        SECRET_HELP;

    }
}

