/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend.goals;

import java.util.ArrayList;
import java.util.Collection;
import polyglot.ast.NodeFactory;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Job;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.VisitorPass;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.goals.VisitorGoal;
import polyglot.types.TypeSystem;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;

public class SupertypesDisambiguated
extends VisitorGoal {
    public static Goal create(Scheduler scheduler, Job job, TypeSystem ts, NodeFactory nf) {
        return scheduler.internGoal(new SupertypesDisambiguated(job, ts, nf));
    }

    protected SupertypesDisambiguated(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, new AmbiguityRemover(job, ts, nf, false, false));
    }

    @Override
    public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
        ArrayList<Goal> l = new ArrayList<Goal>();
        l.add(scheduler.ImportTableInitialized(this.job));
        l.addAll(super.prerequisiteGoals(scheduler));
        return l;
    }

    @Override
    public Pass createPass(ExtensionInfo extInfo) {
        Scheduler scheduler = extInfo.scheduler();
        Goal sigDisam = scheduler.SignaturesDisambiguated(this.job);
        Goal allDisam = scheduler.Disambiguated(this.job);
        return new MyPass(this, sigDisam, allDisam, this.v);
    }

    protected static class MyPass
    extends VisitorPass {
        public Goal allDisam;
        public Goal sigDisam;

        public MyPass(Goal goal, Goal sigDisam, Goal allDisam, NodeVisitor v) {
            super(goal, v);
            this.sigDisam = sigDisam;
            this.allDisam = allDisam;
        }

        @Override
        public boolean run() {
            if (this.sigDisam.hasBeenReached() || this.allDisam.hasBeenReached()) {
                return true;
            }
            return super.run();
        }
    }
}

