/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend.goals;

import java.util.ArrayList;
import java.util.Collection;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.AbstractGoal;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.passes.CheckFieldConstantsPass;
import polyglot.types.FieldInstance;
import polyglot.types.ParsedClassType;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;

public class FieldConstantsChecked
extends AbstractGoal {
    protected FieldInstance vi;
    protected ParsedClassType ct;

    public static Goal create(Scheduler scheduler, FieldInstance fi) {
        return scheduler.internGoal(new FieldConstantsChecked(fi));
    }

    protected FieldConstantsChecked(FieldInstance fi) {
        super(null);
        this.vi = fi.orig();
        ParsedClassType ct = this.findContainer();
        if (ct != null) {
            this.job = ct.job();
        }
        this.ct = ct;
        if (this.job == null && !fi.constantValueSet()) {
            throw new InternalCompilerError(this + " is unreachable.");
        }
    }

    public ParsedClassType container() {
        return this.ct;
    }

    protected ParsedClassType findContainer() {
        if (this.vi.container() instanceof ParsedClassType) {
            return (ParsedClassType)this.vi.container();
        }
        return null;
    }

    @Override
    public Pass createPass(ExtensionInfo extInfo) {
        return new CheckFieldConstantsPass(extInfo.scheduler(), this);
    }

    @Override
    public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
        ArrayList<Goal> l = new ArrayList<Goal>();
        if (this.ct != null) {
            l.add(scheduler.SignaturesResolved(this.ct));
        }
        l.addAll(super.prerequisiteGoals(scheduler));
        return l;
    }

    @Override
    public Collection<Goal> corequisiteGoals(Scheduler scheduler) {
        ArrayList<Goal> l = new ArrayList<Goal>();
        if (this.ct != null && this.ct.job() != null) {
            l.add(scheduler.TypeChecked(this.ct.job()));
        }
        l.addAll(super.corequisiteGoals(scheduler));
        return l;
    }

    public FieldInstance var() {
        return this.vi;
    }

    @Override
    public int hashCode() {
        return this.vi.hashCode() + super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof FieldConstantsChecked && ((FieldConstantsChecked)o).vi.equals(this.vi) && super.equals(o);
    }

    @Override
    public String toString() {
        return StringUtil.getShortNameComponent(this.getClass().getName()) + "(" + this.vi + ")";
    }
}

