/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend.goals;

import java.util.Collection;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Job;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.AbstractGoal;
import polyglot.frontend.goals.Goal;

public abstract class Barrier
extends AbstractGoal {
    protected Scheduler scheduler;

    protected Barrier(Scheduler scheduler) {
        super(null);
        this.scheduler = scheduler;
    }

    protected Barrier(String name, Scheduler scheduler) {
        super(null, name);
        this.scheduler = scheduler;
    }

    public Collection<Job> jobs() {
        return this.scheduler.jobs();
    }

    @Override
    public Pass createPass(ExtensionInfo extInfo) {
        return new BarrierPass(this.scheduler, this);
    }

    public abstract Goal goalForJob(Job var1);

    @Override
    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    @Override
    public int hashCode() {
        if (this.name == null) {
            return System.identityHashCode(this);
        }
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.name == null) {
            return this == o;
        }
        if (o instanceof Barrier) {
            Barrier b = (Barrier)o;
            return this.name.equals(b.name);
        }
        return false;
    }

    protected static class BarrierPass
    extends AbstractPass {
        public Scheduler scheduler;

        protected BarrierPass(Scheduler scheduler, Barrier barrier) {
            super(barrier);
            this.scheduler = scheduler;
        }

        @Override
        public boolean run() {
            Barrier barrier = (Barrier)this.goal();
            for (Job job : barrier.jobs()) {
                Goal subgoal = barrier.goalForJob(job);
                if (subgoal.hasBeenReached()) continue;
                this.scheduler.addDependencyAndEnqueue(barrier, subgoal, true);
                barrier.setUnreachableThisRun();
            }
            return true;
        }
    }
}

