/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.visit.NodeVisitor;

public class VisitorPass
extends AbstractPass {
    protected NodeVisitor v;

    public VisitorPass(Goal goal) {
        this(goal, null);
    }

    public VisitorPass(Goal goal, NodeVisitor v) {
        super(goal);
        this.v = v;
    }

    @Override
    public Lang lang() {
        return this.v.lang();
    }

    public void visitor(NodeVisitor v) {
        this.v = v;
    }

    public NodeVisitor visitor() {
        return this.v;
    }

    @Override
    public boolean run() {
        Node ast = this.goal.job().ast();
        if (ast == null) {
            throw new InternalCompilerError("Null AST for job " + this.goal.job() + ": did the parser run?");
        }
        NodeVisitor v_ = this.v.begin();
        if (v_ != null) {
            ErrorQueue q = this.goal.job().compiler().errorQueue();
            int nErrsBefore = q.errorCount();
            if (Report.should_report("frontend", 3)) {
                Report.report(3, "Running " + v_ + " on " + ast);
            }
            ast = ast.visit(v_);
            v_.finish(ast);
            int nErrsAfter = q.errorCount();
            this.goal.job().ast(ast);
            return nErrsBefore == nErrsAfter;
        }
        return false;
    }

    @Override
    public String name() {
        if (this.v != null) {
            return this.v.toString();
        }
        return super.name();
    }
}

