/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import polyglot.filemanager.FileManager;
import polyglot.frontend.Compiler;
import polyglot.frontend.Source;
import polyglot.main.Report;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.UnicodeWriter;

public class TargetFactory {
    protected FileManager fileManager = null;
    protected JavaFileManager.Location outputLocation = null;
    protected String outputExtension;
    protected boolean outputStdout;

    public TargetFactory(FileManager fileManager, JavaFileManager.Location outputLocation, String outExt, boolean so) {
        this.fileManager = fileManager;
        this.outputLocation = outputLocation;
        this.outputExtension = outExt;
        this.outputStdout = so;
    }

    public CodeWriter outputCodeWriter(FileObject f, int width) throws IOException {
        Writer w = this.outputWriter(f);
        return Compiler.createCodeWriter(w, width);
    }

    public Writer outputWriter(FileObject outputFile) throws IOException {
        if (Report.should_report("frontend", 2)) {
            Report.report(2, "Opening " + outputFile + " for output.");
        }
        if (this.outputStdout) {
            return new UnicodeWriter(new PrintWriter(System.out));
        }
        return new UnicodeWriter(outputFile.openWriter());
    }

    public JavaFileObject outputFileObject(String packageName, Source source) {
        String name = source.name();
        int lastIndex = (name = name.substring(0, name.lastIndexOf(46))).lastIndexOf(File.separatorChar);
        name = lastIndex >= 0 ? name.substring(lastIndex + 1) : name;
        return this.outputFileObject(packageName, name, source);
    }

    public JavaFileObject outputFileObject(String packageName, String className, Source source) {
        if (this.outputLocation == null) {
            throw new InternalCompilerError("Output location not set.");
        }
        try {
            JavaFileObject outputFile = this.outputExtension.equals("java") ? this.fileManager.getJavaFileForOutput(this.outputLocation, !"".equals(packageName) ? packageName + "." + className : className, JavaFileObject.Kind.SOURCE, null) : (JavaFileObject)this.fileManager.getFileForOutput(this.outputLocation, packageName, className + "." + this.outputExtension, null);
            if (source != null && !source.compilerGenerated() && this.fileManager.isSameFile(source, outputFile)) {
                throw new InternalCompilerError("The output file is the same as the source file");
            }
            return outputFile;
        }
        catch (IOException e) {
            throw new InternalCompilerError("Error creating output file for " + source, e);
        }
    }
}

