/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.param.types;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import polyglot.ext.param.types.MuPClass;
import polyglot.ext.param.types.MuPClass_c;
import polyglot.ext.param.types.PClass;
import polyglot.ext.param.types.Param;
import polyglot.ext.param.types.ParamTypeSystem;
import polyglot.ext.param.types.Subst;
import polyglot.ext.param.types.Subst_c;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem_c;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public abstract class ParamTypeSystem_c<Formal extends Param, Actual extends TypeObject>
extends TypeSystem_c
implements ParamTypeSystem<Formal, Actual> {
    protected Map<Map<Formal, ? extends Actual>, Subst<Formal, Actual>> substCache = new HashMap<Map<Formal, ? extends Actual>, Subst<Formal, Actual>>();

    @Override
    public MuPClass<Formal, Actual> mutablePClass(Position pos) {
        return new MuPClass_c(this, pos);
    }

    @Override
    public ClassType instantiate(Position pos, PClass<Formal, Actual> base, List<? extends Actual> actuals) throws SemanticException {
        this.checkInstantiation(pos, base, actuals);
        return this.uncheckedInstantiate(pos, base, actuals);
    }

    protected void checkInstantiation(Position pos, PClass<Formal, Actual> base, List<? extends Actual> actuals) throws SemanticException {
        if (base.formals().size() != actuals.size()) {
            throw new SemanticException("Wrong number of actual parameters for instantiation of \"" + base.clazz() + "\".", pos);
        }
    }

    protected ClassType uncheckedInstantiate(Position pos, PClass<Formal, Actual> base, List<? extends Actual> actuals) {
        HashMap<Param, TypeObject> substMap = new HashMap<Param, TypeObject>();
        Iterator<Formal> i = base.formals().iterator();
        Iterator<Actual> j = actuals.iterator();
        while (i.hasNext() && j.hasNext()) {
            Param formal = (Param)i.next();
            TypeObject actual = (TypeObject)j.next();
            substMap.put(formal, actual);
        }
        if (i.hasNext() || j.hasNext()) {
            throw new InternalCompilerError("Wrong number of actual parameters for instantiation of \"" + base + "\".", pos);
        }
        Type inst = this.subst(base.clazz(), substMap);
        if (!inst.isClass()) {
            throw new InternalCompilerError("Instantiating a PClass produced something other than a ClassType.", pos);
        }
        return inst.toClass();
    }

    @Override
    public Type subst(Type t, Map<Formal, ? extends Actual> substMap) {
        return this.subst(substMap).substType(t);
    }

    @Override
    public final Subst<Formal, Actual> subst(Map<Formal, ? extends Actual> substMap) {
        Subst<Formal, Object> subst = this.substCache.get(substMap);
        if (subst == null) {
            subst = this.substImpl(substMap);
            this.substCache.put(substMap, subst);
        }
        return subst;
    }

    protected Subst<Formal, Actual> substImpl(Map<Formal, ? extends Actual> substMap) {
        return new Subst_c<Formal, Actual>(this, substMap);
    }
}

