/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl7.types.inference;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import polyglot.ext.jl5.types.JL5ConstructorInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.inference.InferenceSolver_c;
import polyglot.ext.jl7.types.JL7TypeSystem;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Type;

public class JL7InferenceSolver_c
extends InferenceSolver_c {
    public JL7InferenceSolver_c(JL5ProcedureInstance pi, List<? extends Type> actuals, JL5TypeSystem ts) {
        super(pi, actuals, ts);
    }

    @Override
    protected List<TypeVariable> typeVariablesToSolve(JL5ProcedureInstance pi) {
        if (pi instanceof JL5ConstructorInstance) {
            JL5ConstructorInstance ci = (JL5ConstructorInstance)pi;
            LinkedList<TypeVariable> result = new LinkedList<TypeVariable>();
            result.addAll(pi.typeParams());
            for (ClassType ct = ci.container().toClass(); ct != null; ct = ct.outer()) {
                if (!(ct instanceof JL5ParsedClassType)) continue;
                JL5ParsedClassType pct = (JL5ParsedClassType)ct;
                result.addAll(pct.typeVariables());
            }
            return result;
        }
        return super.typeVariablesToSolve(pi);
    }

    @Override
    protected Type returnType(JL5ProcedureInstance pi) {
        if (pi instanceof ConstructorInstance) {
            ConstructorInstance ci = (ConstructorInstance)((Object)pi);
            ReferenceType container = ci.container();
            if (container.isClass()) {
                JL5ParsedClassType ct = (JL5ParsedClassType)container.toClass();
                JL7TypeSystem ts = (JL7TypeSystem)ci.typeSystem();
                LinkedHashMap<TypeVariable, TypeVariable> substm = new LinkedHashMap<TypeVariable, TypeVariable>();
                for (TypeVariable tv : ct.typeVariables()) {
                    substm.put(tv, tv);
                }
                return ts.subst(container, substm);
            }
            return container;
        }
        return super.returnType(pi);
    }
}

