/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl7.ast;

import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Try_c;
import polyglot.ext.jl7.ast.TryWithResources;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class TryWithResources_c
extends Try_c
implements TryWithResources {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<LocalDecl> resources;

    public TryWithResources_c(Position pos, List<LocalDecl> resources, Block tryBlock, List<Catch> catchBlocks, Block finallyBlock) {
        super(pos, tryBlock, catchBlocks, finallyBlock);
        this.assert_(pos, tryBlock, catchBlocks, finallyBlock);
        this.resources = ListUtil.copy(resources, true);
    }

    @Override
    protected void assert_(Position pos, Block tryBlock, List<Catch> catchBlocks, Block finallyBlock) {
        assert (tryBlock != null);
    }

    @Override
    public List<LocalDecl> resources() {
        return this.resources;
    }

    @Override
    public TryWithResources resources(List<LocalDecl> resources) {
        return this.resources(this, resources);
    }

    protected <N extends TryWithResources_c> N resources(N n, List<LocalDecl> resources) {
        if (CollectionUtil.equals(n.resources, resources)) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.resources = ListUtil.copy(resources, true);
        return n;
    }

    protected <N extends TryWithResources_c> N reconstruct(N n, List<LocalDecl> resources, Block tryBlock, List<Catch> catchBlocks, Block finallyBlock) {
        n = super.reconstruct(n, tryBlock, catchBlocks, finallyBlock);
        n = this.resources(n, resources);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<LocalDecl> resources = this.visitList(this.resources, v);
        Block tryBlock = this.visitChild(this.tryBlock, v);
        List<Catch> catchBlocks = this.visitList(this.catchBlocks, v);
        Block finallyBlock = this.visitChild(this.finallyBlock, v);
        return this.reconstruct(this, resources, tryBlock, catchBlocks, finallyBlock);
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        TryWithResources_c n = (TryWithResources_c)super.exceptionCheck(ec);
        ExceptionChecker ecTryBlockEntry = ec;
        if (this.finallyBlock != null && !this.finallyBlock.reachable()) {
            ecTryBlockEntry = ecTryBlockEntry.pushCatchAllThrowable();
        }
        ExceptionChecker ecTryBlock = ec.lang().constructTryBlockExceptionChecker(n, ecTryBlockEntry);
        List<LocalDecl> resources = n.visitList(n.resources, (NodeVisitor)ecTryBlock);
        n = this.resources(n, resources);
        return n;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("try (");
        int count = 0;
        for (LocalDecl l : this.resources) {
            if (count++ > 2) {
                sb.append("...");
                break;
            }
            sb.append(l);
            sb.append(" ");
        }
        sb.append(") ");
        sb.append(this.tryBlock.toString());
        count = 0;
        for (Catch cb : this.catchBlocks) {
            if (count++ > 2) {
                sb.append("...");
                break;
            }
            sb.append(" ");
            sb.append(cb.toString());
        }
        if (this.finallyBlock != null) {
            sb.append(" finally ");
            sb.append(this.finallyBlock.toString());
        }
        return sb.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("try (");
        w.begin(0);
        int count = 0;
        for (LocalDecl l : this.resources) {
            if (count++ > 0) {
                w.newline(0);
            }
            this.print(l, w, tr);
        }
        w.end();
        w.write(")");
        this.printSubStmt(this.tryBlock, w, tr);
        for (Catch cb : this.catchBlocks) {
            w.newline(0);
            this.printBlock(cb, w, tr);
        }
        if (this.finallyBlock != null) {
            w.newline(0);
            w.write("finally");
            this.printSubStmt(this.finallyBlock, w, tr);
        }
    }

    @Override
    public Term firstChild() {
        return TryWithResources_c.listChild(this.resources, null);
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.push(this).visitCFGList(this.resources, this.tryBlock, 1);
        return super.acceptCFG(v, succs);
    }
}

