/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl7.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.JLang;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.Node;
import polyglot.ast.Throw;
import polyglot.ast.Try;
import polyglot.ext.jl7.ast.J7Lang;
import polyglot.ext.jl7.ast.JL7Ext;
import polyglot.ext.jl7.ast.JL7ThrowExt;
import polyglot.ext.jl7.ast.JL7TryOps;
import polyglot.ext.jl7.ast.MultiCatch;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.SerialVersionUID;
import polyglot.util.SubtypeSet;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;

public class JL7TryExt
extends JL7Ext
implements JL7TryOps {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Try node() {
        return (Try)super.node();
    }

    @Override
    public Block exceptionCheckTryBlock(ExceptionChecker ec) throws SemanticException {
        Block b = this.superLang().exceptionCheckTryBlock(this.node(), ec);
        ((J7Lang)ec.lang()).checkPreciseRethrows(this.node(), (J7Lang)ec.lang(), ec.typeSystem(), b);
        return b;
    }

    @Override
    public ExceptionChecker constructTryBlockExceptionChecker(ExceptionChecker ec) {
        return this.superLang().constructTryBlockExceptionChecker(this.node(), ec);
    }

    @Override
    public List<Catch> exceptionCheckCatchBlocks(ExceptionChecker ec) throws SemanticException {
        return this.superLang().exceptionCheckCatchBlocks(this.node(), ec);
    }

    @Override
    public Block exceptionCheckFinallyBlock(ExceptionChecker ec) throws SemanticException {
        return this.superLang().exceptionCheckFinallyBlock(this.node(), ec);
    }

    @Override
    public void checkPreciseRethrows(J7Lang lang, TypeSystem ts, Block tryBlock) {
        Try n = this.node();
        SubtypeSet thrown = new SubtypeSet(ts.Throwable(), lang.throwTypes(tryBlock, ts));
        for (Catch cb : n.catchBlocks()) {
            Type catchType = cb.catchType();
            lang.preciseRethrowsForCatchBlock(this.node(), lang, cb, thrown);
            thrown.remove(catchType);
        }
    }

    @Override
    public void preciseRethrowsForCatchBlock(J7Lang lang, Catch cb, SubtypeSet reaching) {
        ArrayList<Type> s = new ArrayList<Type>();
        for (Type t : reaching) {
            if (cb.catchType().isSubtype(t)) {
                return;
            }
            if (!t.isSubtype(cb.catchType())) continue;
            s.add(t);
        }
        if (this.isFinalFormal(lang, cb)) {
            this.setThrowsTypes(lang, cb.formal().localInstance(), s, cb.body());
        }
    }

    protected boolean isFinalFormal(JLang lang, Catch cb) {
        if (cb.formal().localInstance().flags().isFinal() || cb instanceof MultiCatch) {
            return true;
        }
        EffectivelyFinalVisitor v = new EffectivelyFinalVisitor(lang, cb.formal().localInstance());
        cb.body().visit(v);
        return v.isEffectivelyFinal();
    }

    protected void setThrowsTypes(JLang lang, LocalInstance localInstance, List<Type> s, Block b) {
        SetThrowSetVisitor v = new SetThrowSetVisitor(lang, localInstance, s);
        b.visit(v);
    }

    public class SetThrowSetVisitor
    extends NodeVisitor {
        LocalInstance li;
        List<Type> s;

        public SetThrowSetVisitor(JLang lang, LocalInstance li, List<Type> s) {
            super(lang);
            this.li = li;
            this.s = s;
        }

        @Override
        public Node leave(Node old, Node n, NodeVisitor v) {
            Local l;
            Throw t;
            if (n instanceof Throw && (t = (Throw)n).expr() instanceof Local && (l = (Local)t.expr()).localInstance().equals(this.li)) {
                JL7ThrowExt ext = (JL7ThrowExt)JL7Ext.ext(t);
                ext.throwSet = this.s;
            }
            return n;
        }
    }

    public class EffectivelyFinalVisitor
    extends NodeVisitor {
        boolean isEffectivelyFinal;
        LocalInstance li;

        public EffectivelyFinalVisitor(JLang lang, LocalInstance li) {
            super(lang);
            this.li = li;
            this.isEffectivelyFinal = true;
        }

        public boolean isEffectivelyFinal() {
            return this.isEffectivelyFinal;
        }

        @Override
        public Node leave(Node old, Node n, NodeVisitor v) {
            LocalAssign la;
            if (n instanceof LocalAssign && (la = (LocalAssign)n).left().localInstance().equals(this.li)) {
                this.isEffectivelyFinal = false;
            }
            return n;
        }
    }
}

