/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl7.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ext.jl7.ast.JL7Ext;
import polyglot.ext.jl7.types.JL7TypeSystem;
import polyglot.types.ClassType;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.SerialVersionUID;
import polyglot.visit.TypeChecker;

public class JL7ResourceExt
extends JL7Ext {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public LocalDecl node() {
        return (LocalDecl)super.node();
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        LocalDecl n = this.node();
        Type declType = n.declType();
        JL7TypeSystem ts = (JL7TypeSystem)tc.typeSystem();
        if (!ts.isSubtype(declType, ts.AutoCloseable())) {
            throw new SemanticException("The resource type " + declType + " does not implement java.lang.AutoCloseable");
        }
        return this.superLang().typeCheck(this.node(), tc);
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        LinkedList<Type> l = new LinkedList<Type>();
        LocalDecl n = this.node();
        ClassType declType = n.declType().toClass();
        JL7TypeSystem jl7ts = (JL7TypeSystem)ts;
        try {
            MethodInstance mi = ts.findMethod(declType, "close", Collections.emptyList(), jl7ts.AutoCloseable(), true);
            l.addAll(mi.throwTypes());
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected SemanticException: " + e);
        }
        l.addAll(this.superLang().throwTypes(n, ts));
        return l;
    }
}

