/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl7.ast;

import polyglot.ast.Case;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.J5Lang_c;
import polyglot.ext.jl5.ast.JL5CaseOps;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl7.ast.JL7Ext;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.SerialVersionUID;
import polyglot.visit.ConstantChecker;
import polyglot.visit.TypeChecker;

public class JL7CaseExt
extends JL7Ext
implements JL5CaseOps {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Case resolveCaseLabel(TypeChecker tc, Type switchType) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        Case c = (Case)this.node();
        if (switchType.isClass() && ts.String().equals(switchType)) {
            return c;
        }
        return J5Lang_c.lang(this.pred()).resolveCaseLabel(c, tc, switchType);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Case c = (Case)this.node();
        TypeSystem ts = tc.typeSystem();
        if (c.expr() != null && ts.isSubtype(c.expr().type(), ts.String())) {
            return c;
        }
        return this.superLang().typeCheck(this.node(), tc);
    }

    @Override
    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        Case c = (Case)this.node();
        Expr expr = c.expr();
        if (expr == null) {
            return c;
        }
        if (cc.lang().constantValueSet(expr, cc.lang()) && cc.lang().isConstant(expr, cc.lang()) && cc.lang().constantValue(expr, cc.lang()) instanceof String) {
            return c;
        }
        return this.superLang().checkConstants(this.node(), cc);
    }
}

