/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl7.ast;

import polyglot.ast.Ambiguous;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl7.types.DiamondType;
import polyglot.ext.jl7.types.JL7TypeSystem;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class AmbDiamondTypeNode
extends TypeNode_c
implements Ambiguous {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected TypeNode base;

    public AmbDiamondTypeNode(Position pos, TypeNode base) {
        super(pos);
        this.base = base;
    }

    @Override
    public String name() {
        return this.base.name();
    }

    public TypeNode base() {
        return this.base;
    }

    protected AmbDiamondTypeNode reconstruct(TypeNode base) {
        if (this.base != base) {
            AmbDiamondTypeNode n = (AmbDiamondTypeNode)this.copy();
            n.base = base;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode base = this.visitChild(this.base, v);
        return this.reconstruct(base);
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (!this.base.isDisambiguated()) {
            return this;
        }
        JL7TypeSystem ts = (JL7TypeSystem)ar.typeSystem();
        Type base = this.base.type();
        if (base instanceof RawClass) {
            JL5ParsedClassType ct = ((RawClass)base).base();
            DiamondType t = ts.diamondType(this.position(), ct);
            return ar.nodeFactory().CanonicalTypeNode(this.position, t);
        }
        throw new SemanticException("The type " + base + " is not generic; it cannot be parameterized with arguments <>");
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.base);
        sb.append("<>");
        return sb.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        tr.lang().prettyPrint((Node)this.base, w, tr);
        w.write("<>");
    }
}

