/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Cast;
import polyglot.ast.ClassBody;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Local;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.JL5Options;
import polyglot.ext.jl5.types.JL5ClassType;
import polyglot.ext.jl5.types.JL5LocalInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5Subst;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.frontend.Job;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.ErrorHandlingVisitor;
import polyglot.visit.NodeVisitor;

public class TypeErasureProcDecls
extends ErrorHandlingVisitor {
    private List<MethodDecl> newMethodDecls = new ArrayList<MethodDecl>();

    public TypeErasureProcDecls(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    protected NodeVisitor enterCall(Node n) throws SemanticException {
        if (n instanceof ClassBody) {
            return new TypeErasureProcDecls(this.job, this.ts, this.nf);
        }
        return super.enterCall(n);
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof MethodDecl) {
            return this.rewriteMethodDecl((MethodDecl)n);
        }
        if (n instanceof ClassBody) {
            ClassBody cb = (ClassBody)n;
            List<MethodDecl> nmd = ((TypeErasureProcDecls)v).newMethodDecls;
            for (MethodDecl md : nmd) {
                cb = cb.addMember(md);
            }
            nmd.clear();
            return cb;
        }
        return super.leaveCall(n);
    }

    private Node rewriteMethodDecl(MethodDecl n) {
        JL5ParsedClassType pct;
        JL5Subst es;
        MethodInstance mi = n.methodInstance();
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        List<? extends MethodInstance> implemented = mi.implemented();
        if (implemented.isEmpty()) {
            return n;
        }
        MethodInstance mj = null;
        for (int i = implemented.size() - 1; i >= 0; --i) {
            MethodInstance mk = implemented.get(i);
            if (mk == mi) continue;
            if (mj == null) {
                mj = mk;
                continue;
            }
            if (!mk.container().isClass() || mk.container().toClass().flags().isInterface()) continue;
            if (ts.implemented(mk).contains(mj)) break;
            mj = mk;
            break;
        }
        if (mj == null) {
            return n;
        }
        JL5ClassType miContainer = (JL5ClassType)mi.container();
        List<Type> miFormalTypes = mi.formalTypes();
        if (miContainer instanceof JL5ParsedClassType && (es = (pct = (JL5ParsedClassType)miContainer).erasureSubst()) != null) {
            miFormalTypes = es.substTypeList(miFormalTypes);
        }
        MethodInstance mjErased = this.erasedMethodInstance(mj);
        List<? extends Type> mjErasedFormals = this.erase(mjErased.formalTypes());
        boolean changed = false;
        ArrayList<Formal> newFormals = new ArrayList<Formal>(n.formals().size());
        Iterator<Formal> formals = n.formals().iterator();
        for (Type type : mjErasedFormals) {
            TypeNode newTn;
            Formal f = formals.next();
            TypeNode typeNode = f.type();
            changed |= typeNode != (newTn = typeNode.type(ts.erasureType(type)));
            newFormals.add(f.type(newTn));
        }
        TypeNode newRetType = n.returnType();
        newRetType = newRetType.type(this.erasedReturnType(mjErased, n.returnType().type()));
        changed |= n.returnType().type() != newRetType.type();
        if (n.methodInstance().container().isClass() && !n.methodInstance().container().toClass().flags().isInterface()) {
            LinkedHashSet<List<? extends Type>> linkedHashSet = new LinkedHashSet<List<? extends Type>>();
            linkedHashSet.add(mjErasedFormals);
            for (MethodInstance methodInstance : implemented) {
                MethodInstance mkErased = this.erasedMethodInstance(methodInstance);
                List<? extends Type> mkErasedFormals = this.erase(mkErased.formalTypes());
                if (linkedHashSet.contains(mkErasedFormals)) continue;
                linkedHashSet.add(mkErasedFormals);
                this.addMethodDecl(mkErased, methodInstance.returnType(), mjErased, n, mjErasedFormals);
            }
        }
        if (!changed) {
            return n;
        }
        return n.returnType(newRetType).formals(newFormals);
    }

    protected Type erasedReturnType(MethodInstance mjErased, Type originalReturnType) {
        Type t = originalReturnType;
        JL5Options opts = (JL5Options)this.ts.extensionInfo().getOptions();
        if (!opts.leaveCovariantReturns) {
            t = mjErased.returnType();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    protected void addMethodDecl(MethodInstance mkErased, Type origReturnType, MethodInstance callee, MethodDecl n, List<? extends Type> dispatchArgTypes) {
        void var14_23;
        Position pos = Position.compilerGenerated();
        Flags flags = n.flags();
        if (flags.isAbstract() && n.memberInstance().container().isClass() && !n.memberInstance().container().toClass().flags().isInterface()) {
            flags = flags.clearAbstract();
        }
        CanonicalTypeNode returnType = this.nodeFactory().CanonicalTypeNode(pos, this.erasedReturnType(mkErased, origReturnType));
        List<? extends Type> mkErasedFormals = this.erase(mkErased.formalTypes());
        ArrayList<Formal> formals = new ArrayList<Formal>(mkErased.formalTypes().size());
        int i = 0;
        for (Type type : mkErasedFormals) {
            Formal formal = this.nodeFactory().Formal(pos, Flags.NONE, (TypeNode)this.nodeFactory().CanonicalTypeNode(pos, type), this.nodeFactory().Id(pos, "arg" + ++i));
            JL5LocalInstance jL5LocalInstance = (JL5LocalInstance)this.ts.localInstance(pos, Flags.NONE, type, "arg" + i);
            jL5LocalInstance.setProcedureFormal(true);
            Formal formal2 = formal.localInstance(jL5LocalInstance);
            formals.add(formal2);
        }
        ArrayList<TypeNode> throwTypes = new ArrayList<TypeNode>(mkErased.throwTypes().size());
        for (Type type : mkErased.throwTypes()) {
            throwTypes.add(this.nodeFactory().CanonicalTypeNode(pos, type));
        }
        ArrayList<Expr> arrayList = new ArrayList<Expr>(mkErasedFormals.size());
        i = 0;
        for (Type type : dispatchArgTypes) {
            LocalInstance li = ((Formal)formals.get(i)).localInstance();
            Local l = this.nodeFactory().Local(pos, this.nodeFactory().Id(pos, "arg" + ++i));
            l = l.localInstance(li);
            Expr arg = l = (Local)l.type(li.type());
            if (!li.type().isPrimitive()) {
                Cast cst = this.nodeFactory().Cast(pos, this.nodeFactory().CanonicalTypeNode(pos, type), l);
                cst = (Cast)cst.type(type);
                arg = cst;
            }
            arrayList.add(arg);
        }
        Object var14_21 = null;
        if (!flags.isAbstract()) {
            Stmt s;
            Special special = (Special)this.nodeFactory().Special(pos, Special.THIS).type(callee.container());
            Call c = this.nodeFactory().Call(pos, (Receiver)special, this.nodeFactory().Id(pos, mkErased.name()), arrayList);
            c = c.methodInstance(callee);
            c = (Call)c.type(callee.returnType());
            if (origReturnType.isVoid()) {
                s = this.nodeFactory().Eval(pos, c);
            } else {
                Cast cast = this.nodeFactory().Cast(pos, returnType, c);
                cast = (Cast)cast.type(returnType.type());
                s = this.nodeFactory().Return(pos, cast);
            }
            Block block = this.nodeFactory().Block(pos, s);
        }
        MethodDecl methodDecl2 = this.nodeFactory().MethodDecl(pos, flags, (TypeNode)returnType, this.nodeFactory().Id(pos, mkErased.name()), formals, throwTypes, (Block)var14_23);
        methodDecl2 = methodDecl2.methodInstance(this.typeSystem().methodInstance(pos, callee.container(), flags, returnType.type(), callee.name(), mkErasedFormals, mkErased.throwTypes()));
        this.newMethodDecls.add(methodDecl2);
    }

    private List<? extends Type> erase(List<? extends Type> types) {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        ArrayList<Type> nt = new ArrayList<Type>(types.size());
        for (Type type : types) {
            nt.add(ts.erasureType(type));
        }
        return nt;
    }

    protected MethodInstance erasedMethodInstance(MethodInstance mj) {
        JL5Subst procedureSubst;
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        HashMap subst = new HashMap();
        JL5ParsedClassType containerBase = (JL5ParsedClassType)((JL5ClassType)mj.container()).declaration();
        JL5Subst containerSubst = ts.erasureSubst(containerBase);
        if (containerSubst != null) {
            subst.putAll(containerSubst.substitutions());
        }
        if ((procedureSubst = ts.erasureSubst((JL5ProcedureInstance)((Object)mj))) != null) {
            subst.putAll(procedureSubst.substitutions());
        }
        if (subst.isEmpty()) {
            return mj;
        }
        return ts.subst(subst).substMethod((MethodInstance)mj.declaration());
    }
}

