/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.MethodDecl;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.EnumConstantDecl;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.ast.JL5FormalExt;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.frontend.Job;
import polyglot.types.ArrayType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ErrorHandlingVisitor;

public class RemoveVarargVisitor
extends ErrorHandlingVisitor {
    public RemoveVarargVisitor(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    protected Node leaveCall(Node n) throws SemanticException {
        if (n instanceof ProcedureCall) {
            return this.rewriteCall((ProcedureCall)n);
        }
        if (n instanceof EnumConstantDecl) {
            return this.rewriteEnumConstantDecl((EnumConstantDecl)n);
        }
        if (n instanceof ProcedureDecl) {
            return this.rewriteProcedureDecl((ProcedureDecl)n);
        }
        return n;
    }

    private Node rewriteProcedureDecl(ProcedureDecl n) {
        int varArgIndex;
        Formal varArgFormal;
        JL5FormalExt varArgFormalExt;
        ArrayList<Formal> formals = new ArrayList<Formal>(n.formals());
        if (formals.size() > 0 && (varArgFormalExt = (JL5FormalExt)JL5Ext.ext(varArgFormal = (Formal)formals.get(varArgIndex = formals.size() - 1))).isVarArg()) {
            Formal newFormal = this.nf.Formal(varArgFormal.position(), varArgFormal.flags(), varArgFormal.type(), varArgFormal.id());
            newFormal = newFormal.type(varArgFormal.type()).localInstance(varArgFormal.localInstance());
            formals.remove(varArgIndex);
            formals.add(newFormal);
            if (n instanceof MethodDecl) {
                return ((MethodDecl)n).formals(formals);
            }
            if (n instanceof ConstructorDecl) {
                return ((ConstructorDecl)n).formals(formals);
            }
            throw new InternalCompilerError("Unexepected ProcedureDecl " + n + " of type " + n.getClass());
        }
        return n;
    }

    private Node rewriteEnumConstantDecl(EnumConstantDecl n) {
        JL5ProcedureInstance pi = (JL5ProcedureInstance)((Object)n.constructorInstance());
        return n.args(this.rewriteProcedureArgs(pi, n.args(), n.position()));
    }

    private Node rewriteCall(ProcedureCall n) {
        JL5ProcedureInstance pi = (JL5ProcedureInstance)n.procedureInstance();
        return n.arguments(this.rewriteProcedureArgs(pi, n.arguments(), n.position()));
    }

    private List<Expr> rewriteProcedureArgs(JL5ProcedureInstance pi, List<Expr> args, Position pos) {
        if (pi.isVariableArity()) {
            Type lastArgType;
            int numArgs = args.size();
            int numStandardFormals = pi.formalTypes().size() - 1;
            ArrayType varArgArrayType = (ArrayType)pi.formalTypes().get(numStandardFormals);
            if (numStandardFormals == numArgs - 1 && (lastArgType = args.get(numStandardFormals).type()).isImplicitCastValid(varArgArrayType)) {
                return args;
            }
            ArrayList<Expr> standardArgs = new ArrayList<Expr>(args.subList(0, numStandardFormals));
            ArrayInit initValues = this.nf.ArrayInit(pos, args.subList(numStandardFormals, numArgs));
            initValues = (ArrayInit)initValues.type(varArgArrayType);
            NewArray varArgArray = this.nf.NewArray(pos, (TypeNode)this.nf.CanonicalTypeNode(Position.compilerGenerated(), varArgArrayType.base()), 1, initValues);
            varArgArray = (NewArray)varArgArray.type(varArgArrayType);
            standardArgs.add(varArgArray);
            return standardArgs;
        }
        return args;
    }
}

