/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.Cast;
import polyglot.ast.CodeDecl;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Id;
import polyglot.ast.IntLit;
import polyglot.ast.Labeled;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Loop;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ast.While;
import polyglot.ext.jl5.ast.ExtendedFor;
import polyglot.frontend.Job;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class RemoveExtendedFors
extends ContextVisitor {
    private LinkedList<Integer> varCount = new LinkedList();

    public RemoveExtendedFors(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    protected NodeVisitor enterCall(Node n) throws SemanticException {
        if (n instanceof CodeDecl) {
            this.varCount.addLast(0);
        }
        return this;
    }

    @Override
    protected Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
        if (this.isExtendedFor(n) && !(parent instanceof Labeled)) {
            n = this.translateExtendedFor((ExtendedFor)n, Collections.emptyList());
        }
        if (n instanceof CodeDecl) {
            this.varCount.removeLast();
        }
        if (n instanceof Labeled && !(parent instanceof Labeled)) {
            Node s = n;
            ArrayList<String> labels = new ArrayList<String>();
            while (s instanceof Labeled) {
                Labeled lbled = (Labeled)s;
                labels.add(lbled.label());
                s = lbled.statement();
            }
            if (this.isExtendedFor(s)) {
                n = this.translateExtendedFor((ExtendedFor)s, labels);
            }
        }
        return n;
    }

    protected boolean isExtendedFor(Node n) {
        return n instanceof Loop && n instanceof ExtendedFor;
    }

    private Node translateExtendedFor(ExtendedFor n, List<String> labels) throws SemanticException {
        ExtendedFor ext = n;
        LocalDecl decl = ext.decl();
        Expr expr = ext.expr();
        if (expr.type().isArray()) {
            return this.translateExtForArray(n, labels);
        }
        Position pos = Position.compilerGenerated();
        Type iterType = this.ts.typeForName("java.util.Iterator");
        Type iteratedType = decl.type().type();
        String iterName = this.freshName("iter");
        LocalInstance iterLI = this.ts.localInstance(pos, Flags.NONE, iterType, iterName);
        Id id = this.nodeFactory().Id(pos, "iterator");
        Call iterator = this.nodeFactory().Call(pos, (Receiver)expr, id, new Expr[0]);
        iterator = (Call)iterator.type(iterType);
        iterator = iterator.methodInstance(this.ts.findMethod(expr.type().toClass(), "iterator", Collections.emptyList(), this.context().currentClass(), true));
        LocalDecl iterDecl = this.nodeFactory().LocalDecl(pos, Flags.NONE, (TypeNode)this.nodeFactory().CanonicalTypeNode(pos, iterType), this.nodeFactory().Id(pos, iterName), (Expr)iterator);
        iterDecl = iterDecl.localInstance(iterLI);
        ArrayList<Stmt> loopBody = new ArrayList<Stmt>();
        Id id2 = this.nodeFactory().Id(pos, "next");
        Call call = this.nodeFactory().Call(pos, (Receiver)((Local)this.nodeFactory().Local(pos, this.nodeFactory().Id(pos, iterName)).type(iterType)).localInstance(iterDecl.localInstance()), id2, new Expr[0]);
        call = (Call)call.type(this.ts.Object());
        call = call.methodInstance(this.ts.findMethod(iterType.toClass(), "next", Collections.emptyList(), this.context().currentClass(), true));
        Cast cast = this.nodeFactory().Cast(pos, this.nodeFactory().CanonicalTypeNode(pos, iteratedType), call);
        cast = (Cast)cast.type(iteratedType);
        loopBody.add(decl.init(cast));
        loopBody.add(n.body());
        Id id3 = this.nodeFactory().Id(pos, "hasNext");
        Call cond = this.nodeFactory().Call(pos, (Receiver)((Local)this.nodeFactory().Local(pos, this.nodeFactory().Id(pos, iterName)).type(iterType)).localInstance(iterDecl.localInstance()), id3, new Expr[0]);
        cond = (Call)cond.type(this.ts.Boolean());
        cond = cond.methodInstance(this.ts.findMethod(iterType.toClass(), "hasNext", Collections.emptyList(), this.context().currentClass(), true));
        While loop = this.nodeFactory().While(pos, cond, this.nodeFactory().Block(pos, loopBody));
        return this.nodeFactory().Block(pos, iterDecl, this.labelStmt(loop, labels));
    }

    protected String freshName(String desc) {
        int count = this.varCount.removeLast();
        this.varCount.addLast(count + 1);
        if (count == 0) {
            return "extfor$" + desc;
        }
        return "extfor$" + desc + "$" + count;
    }

    protected Node translateExtForArray(ExtendedFor n, List<String> labels) throws SemanticException {
        ExtendedFor ext = n;
        LocalDecl decl = ext.decl();
        Expr expr = ext.expr();
        Position pos = Position.compilerGenerated();
        Type iteratedType = decl.type().type();
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        String arrID = this.freshName("arr");
        LocalInstance arrLI = this.ts.localInstance(pos, Flags.NONE, expr.type(), arrID);
        LocalDecl ld = this.nodeFactory().LocalDecl(pos, Flags.NONE, (TypeNode)this.nodeFactory().CanonicalTypeNode(pos, arrLI.type()), this.nodeFactory().Id(pos, arrID));
        ld = ld.localInstance(arrLI);
        ld = ld.init(expr);
        stmts.add(ld);
        String iterID = this.freshName("iter");
        LocalInstance iterLI = this.ts.localInstance(pos, Flags.NONE, this.ts.Int(), iterID);
        LocalDecl ld2 = this.nodeFactory().LocalDecl(pos, Flags.NONE, (TypeNode)this.nodeFactory().CanonicalTypeNode(pos, iterLI.type()), this.nodeFactory().Id(pos, iterID));
        ld2 = ld2.localInstance(iterLI);
        ld2 = ld2.init(this.nodeFactory().IntLit(pos, IntLit.INT, 0L).type(this.ts.Int()));
        stmts.add(ld2);
        Id id = this.nodeFactory().Id(pos, "length");
        Field field = (Field)this.nodeFactory().Field(pos, (Receiver)this.makeLocal(pos, arrLI), id).type(this.ts.Int());
        field = field.fieldInstance(this.ts.findField(arrLI.type().toReference(), "length", this.context().currentClass(), true));
        Expr cond = this.nodeFactory().Binary(pos, this.makeLocal(pos, iterLI), Binary.LT, field).type(this.ts.Boolean());
        Expr init = this.nodeFactory().ArrayAccess(pos, this.makeLocal(pos, arrLI), this.makeLocal(pos, iterLI));
        init = init.type(iteratedType);
        Expr incExpr = this.nodeFactory().Binary(pos, this.makeLocal(pos, iterLI), Binary.ADD, this.nodeFactory().IntLit(pos, IntLit.INT, 1L).type(this.ts.Int())).type(this.ts.Int());
        Assign incStore = (Assign)this.nodeFactory().Assign(pos, this.makeLocal(pos, iterLI), Assign.ASSIGN, incExpr).type(this.ts.Int());
        Eval inc = this.nodeFactory().Eval(pos, incStore);
        Block loopBody = this.nodeFactory().Block(pos, decl.init(init), inc, n.body());
        While loop = this.nodeFactory().While(pos, cond, loopBody);
        stmts.add(this.labelStmt(loop, labels));
        return this.nodeFactory().Block(pos, stmts);
    }

    protected Expr makeLocal(Position pos, LocalInstance li) {
        Local l = (Local)this.nodeFactory().Local(pos, this.nodeFactory().Id(pos, li.name())).localInstance(li).type(li.type());
        return l;
    }

    private Stmt labelStmt(Stmt s, List<String> labels) {
        for (int i = labels.size() - 1; i >= 0; --i) {
            Id id = this.nodeFactory().Id(Position.compilerGenerated(), labels.get(i));
            s = this.nodeFactory().Labeled(Position.compilerGenerated(), id, s);
        }
        return s;
    }
}

