/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import java.util.Collections;
import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ext.jl5.JL5Options;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.visit.AscriptionVisitor;

public class AutoBoxer
extends AscriptionVisitor {
    public AutoBoxer(Job job, JL5TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    public Expr ascribe(Expr e, Type toType) throws SemanticException {
        Type fromType = e.type();
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        if (toType.isPrimitive() && !toType.isVoid() && !fromType.isPrimitive() && !fromType.isSubtype(ts.toRawType(ts.Enum()))) {
            if (((JL5Options)ts.extensionInfo().getOptions()).morePermissiveCasts && ts.isPrimitiveWrapper(fromType)) {
                return this.fromWrapToPrim(fromType, ts.primitiveTypeOfWrapper(fromType), e);
            }
            return this.fromWrapToPrim(fromType, toType.toPrimitive(), e);
        }
        if (!toType.isPrimitive() && fromType.isPrimitive() && !fromType.isVoid() && !ts.String().equals(toType)) {
            if (((JL5Options)ts.extensionInfo().getOptions()).morePermissiveCasts && ts.isPrimitiveWrapper(toType)) {
                return this.fromPrimToWrapWithWidening(fromType.toPrimitive(), (ReferenceType)toType, e);
            }
            return this.fromPrimToWrap(fromType.toPrimitive(), toType, e);
        }
        return super.ascribe(e, toType);
    }

    private Expr fromPrimToWrapWithWidening(PrimitiveType fromType, ReferenceType toType, Expr e) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        PrimitiveType toTypePrim = ts.primitiveTypeOfWrapper(toType);
        CanonicalTypeNode toTypeNode = this.nf.CanonicalTypeNode(e.position(), toTypePrim);
        Cast cast = this.nf.Cast(e.position(), toTypeNode, e);
        String methodName = "valueOf";
        CanonicalTypeNode tn = this.nf.CanonicalTypeNode(e.position(), toType);
        Id id = this.nodeFactory().Id(e.position(), methodName);
        Call call = this.nf.Call(e.position(), (Receiver)tn, id, cast);
        call = (Call)call.type(toType);
        call = call.methodInstance(ts.findMethod(toType, methodName, CollectionUtil.list(toTypePrim), this.context().currentClass(), true));
        return call;
    }

    private Expr fromPrimToWrap(PrimitiveType fromType, Type toType, Expr e) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        String methodName = "valueOf";
        ClassType wrapperType = ts.wrapperClassOfPrimitive(fromType);
        CanonicalTypeNode tn = this.nf.CanonicalTypeNode(e.position(), wrapperType);
        Id id = this.nodeFactory().Id(e.position(), methodName);
        Call call = this.nf.Call(e.position(), (Receiver)tn, id, e);
        call = (Call)call.type(wrapperType);
        call = call.methodInstance(ts.findMethod(wrapperType, methodName, CollectionUtil.list(fromType), this.context().currentClass(), true));
        return call;
    }

    private Expr fromWrapToPrim(Type fromType, PrimitiveType toType, Expr e) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        ClassType wrapperType = ts.primitiveTypeOfWrapper(fromType) != null ? fromType.toClass() : ts.wrapperClassOfPrimitive(toType.toPrimitive());
        String methodName = toType.toPrimitive().name() + "Value";
        Id id = this.nodeFactory().Id(e.position(), methodName);
        Call call = this.nf.Call(e.position(), (Receiver)e, id, new Expr[0]);
        call = (Call)call.type(toType);
        call = call.methodInstance(ts.findMethod(wrapperType, methodName, Collections.emptyList(), this.context().currentClass(), true));
        return call;
    }
}

