/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.reflect;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.WildCardType;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.Attribute;
import polyglot.types.reflect.ClassFile;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class JL5Signature
extends Attribute {
    protected DataInputStream in;
    protected int index;
    protected ClassFile cls;
    protected JL5TypeSystem ts;
    protected Position position;
    protected ClassSig classSignature;
    protected MethodSig methodSignature;
    protected FieldSig fieldSignature;
    protected List<TypeVariable> typeVars;
    protected ClassType curClass;
    private final char LEFT_ANGLE = (char)60;
    private final char RIGHT_ANGLE = (char)62;
    private final char COLON = (char)58;
    private final char L = (char)76;
    private final char SEMI_COLON = (char)59;
    private final char SLASH = (char)47;
    private final char DOT = (char)46;
    private final char T = (char)84;
    private final char STAR = (char)42;
    private final char PLUS = (char)43;
    private final char MINUS = (char)45;
    private final char LEFT_SQUARE = (char)91;
    private final char LEFT_BRACE = (char)40;
    private final char RIGHT_BRACE = (char)41;
    private final char V = (char)86;
    private final char HAT = (char)94;
    private final char B = (char)66;
    private final char C = (char)67;
    private final char D = (char)68;
    private final char F = (char)70;
    private final char I = (char)73;
    private final char J = (char)74;
    private final char S = (char)83;
    private final char Z = (char)90;
    private boolean createTypeVars;

    JL5Signature(ClassFile clazz, DataInputStream in, int nameIndex, int length) throws IOException {
        super(nameIndex, length);
        this.index = in.readUnsignedShort();
        this.cls = clazz;
    }

    public Result<ClassSig> classSig(String value, int pos) {
        char token = value.charAt(pos);
        Result<List<TypeVariable>> fres = null;
        if (token == '<') {
            fres = this.useFormalTypeParamList(value, ++pos);
            pos = fres.pos();
        }
        Result<ClassType> sres = this.classTypeSig(value, pos);
        ArrayList<ClassType> superInterfaces = new ArrayList<ClassType>();
        pos = sres.pos();
        while (pos < value.length()) {
            Result<ClassType> ires = this.classTypeSig(value, pos);
            pos = ires.pos();
            superInterfaces.add(ires.result());
        }
        return new Result<ClassSig>(new ClassSig(fres == null ? new ArrayList() : fres.result(), sres.result(), superInterfaces), pos);
    }

    public Result<List<TypeVariable>> createFormalTypeParamList(String value, int pos) {
        this.typeVars = null;
        this.createTypeVars = true;
        ArrayList<TypeVariable> list = new ArrayList<TypeVariable>();
        char token = value.charAt(pos);
        while (token != '>') {
            Result<TypeVariable> fres = this.formalTypeParam(value, pos);
            list.add(fres.result());
            pos = fres.pos();
            token = value.charAt(pos);
        }
        return new Result<List<TypeVariable>>(list, ++pos);
    }

    public Result<List<TypeVariable>> useFormalTypeParamList(String value, int pos) {
        this.createTypeVars = false;
        ArrayList<TypeVariable> list = new ArrayList<TypeVariable>();
        char token = value.charAt(pos);
        while (token != '>') {
            Result<TypeVariable> fres = this.formalTypeParam(value, pos);
            list.add(fres.result());
            pos = fres.pos();
            token = value.charAt(pos);
        }
        return new Result<List<TypeVariable>>(list, ++pos);
    }

    public Result<List<TypeVariable>> formalTypeParamList(String value, int pos) {
        Result<TypeVariable> fres;
        this.typeVars = null;
        int oldpos = pos;
        this.createTypeVars = true;
        ArrayList<TypeVariable> list = new ArrayList<TypeVariable>();
        char token = value.charAt(pos);
        while (token != '>') {
            fres = this.formalTypeParam(value, pos);
            list.add(fres.result());
            pos = fres.pos();
            token = value.charAt(pos);
        }
        this.typeVars = list;
        pos = oldpos;
        this.createTypeVars = false;
        list = new ArrayList();
        token = value.charAt(pos);
        while (token != '>') {
            fres = this.formalTypeParam(value, pos);
            list.add(fres.result());
            pos = fres.pos();
            token = value.charAt(pos);
        }
        return new Result<List<TypeVariable>>(list, ++pos);
    }

    public Result<TypeVariable> formalTypeParam(String value, int pos) {
        String id = "";
        char token = value.charAt(pos);
        while (token != ':') {
            id = id + token;
            token = value.charAt(++pos);
        }
        ArrayList<ReferenceType> bounds = new ArrayList<ReferenceType>();
        Result<? extends ReferenceType> cres = this.classBound(value, pos);
        pos = cres.pos();
        if (!cres.result().equals(this.ts.Object())) {
            bounds.add(cres.result());
        }
        Result<? extends ReferenceType> ires = null;
        token = value.charAt(pos);
        while (token != '>' && value.charAt(pos) == ':') {
            ires = this.classBound(value, pos);
            pos = ires.pos();
            bounds.add(ires.result());
        }
        if (this.createTypeVars) {
            return new Result<TypeVariable>(this.ts.typeVariable(this.position, id, this.ts.intersectionType(this.position, bounds)), pos);
        }
        TypeVariable tv = this.findTypeVar(id);
        tv.setUpperBound(this.ts.intersectionType(this.position, bounds));
        return new Result<TypeVariable>(tv, pos);
    }

    public Result<? extends ReferenceType> classBound(String value, int pos) {
        return this.fieldTypeSig(value, ++pos);
    }

    public Result<? extends ReferenceType> fieldTypeSig(String value, int pos) {
        char token = value.charAt(pos);
        switch (token) {
            case 'L': {
                return this.classTypeSig(value, pos);
            }
            case '[': {
                return this.arrayTypeSig(value, pos);
            }
            case 'T': {
                return this.typeVarSig(value, pos);
            }
            case ':': {
                return new Result<ClassType>(this.ts.Object(), pos);
            }
        }
        return null;
    }

    public Result<ClassType> classTypeSig(String value, int pos) {
        JL5ParsedClassType pct;
        char token = value.charAt(pos);
        String className = "";
        String id = "";
        HashMap<String, List<ReferenceType>> classArgsMap = new HashMap<String, List<ReferenceType>>();
        token = value.charAt(++pos);
        block11: while (token != ';') {
            switch (token) {
                case '/': {
                    className = className + id;
                    className = className + ".";
                    id = "";
                    token = value.charAt(++pos);
                    continue block11;
                }
                case '.': {
                    className = className + id;
                    className = className + "$";
                    id = "";
                    token = value.charAt(++pos);
                    continue block11;
                }
                case '<': {
                    Result<List<ReferenceType>> tres = this.typeArgList(value, pos);
                    pos = tres.pos();
                    classArgsMap.put(id, tres.result());
                    token = value.charAt(pos);
                    continue block11;
                }
            }
            id = id + token;
            token = value.charAt(++pos);
        }
        className = className + id;
        ClassType ct = null;
        try {
            ct = (ClassType)this.ts.systemResolver().find(className);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("could not load " + className, e);
        }
        String lookupClassName = className.substring(className.lastIndexOf(46) + 1);
        if (classArgsMap.containsKey(lookupClassName)) {
            pct = JL5Signature.parsedClassTypeForClass(ct);
            if (!this.createTypeVars) {
                try {
                    ct = this.ts.instantiate(this.position, pct, (List<? extends ReferenceType>)((List)classArgsMap.get(lookupClassName)));
                }
                catch (SemanticException e) {
                    throw new InternalCompilerError(e);
                }
            }
        } else {
            pct = JL5Signature.parsedClassTypeForClass(ct);
            if (!pct.typeVariables().isEmpty()) {
                ct = this.ts.rawClass(pct, Position.compilerGenerated());
            }
        }
        ClassType current = ct;
        ClassType outer = current.outer();
        while (outer != null) {
            if (classArgsMap.containsKey(outer.name())) {
                JL5ParsedClassType pct2 = JL5Signature.parsedClassTypeForClass(outer);
                try {
                    ClassType pt = this.ts.instantiate(this.position, pct2.pclass(), (List)classArgsMap.get(outer.name()));
                    if (current instanceof JL5ParsedClassType) {
                        ((JL5ParsedClassType)current).outer(pt);
                    }
                }
                catch (SemanticException e) {
                    throw new InternalCompilerError(e);
                }
            }
            if (current == current.outer()) break;
            current = current.outer();
            outer = current.outer();
        }
        return new Result<ClassType>(ct, ++pos);
    }

    private static JL5ParsedClassType parsedClassTypeForClass(ClassType ct) {
        if (ct instanceof JL5ParsedClassType) {
            return (JL5ParsedClassType)ct;
        }
        if (ct instanceof RawClass) {
            return ((RawClass)ct).base();
        }
        if (ct instanceof JL5SubstClassType) {
            return ((JL5SubstClassType)ct).base();
        }
        throw new InternalCompilerError("Don't know how to deal with finding base of class " + ct);
    }

    public Result<TypeVariable> typeVarSig(String value, int pos) {
        char token = value.charAt(pos);
        switch (token) {
            case 'T': {
                String id = "";
                token = value.charAt(++pos);
                while (token != ';') {
                    id = id + token;
                    token = value.charAt(++pos);
                }
                return new Result<TypeVariable>(this.findTypeVar(id), ++pos);
            }
        }
        return null;
    }

    public Result<List<ReferenceType>> typeArgList(String value, int pos) {
        ArrayList<ReferenceType> typeArgs = new ArrayList<ReferenceType>();
        char token = value.charAt(pos++);
        while (token != '>') {
            Result<? extends ReferenceType> tres = this.typeArg(value, pos);
            pos = tres.pos();
            typeArgs.add(tres.result());
            token = value.charAt(pos);
        }
        return new Result<List<ReferenceType>>(typeArgs, ++pos);
    }

    public Result<? extends ReferenceType> typeArg(String value, int pos) {
        char token = value.charAt(pos);
        switch (token) {
            case '+': {
                Result<? extends ReferenceType> fres = this.fieldTypeSig(value, ++pos);
                return new Result<WildCardType>(this.ts.wildCardType(this.position, fres.result(), null), fres.pos());
            }
            case '-': {
                Result<? extends ReferenceType> fres = this.fieldTypeSig(value, ++pos);
                return new Result<WildCardType>(this.ts.wildCardType(this.position, null, fres.result()), fres.pos());
            }
            case '*': {
                return new Result<WildCardType>(this.ts.wildCardType(this.position), ++pos);
            }
            case 'L': 
            case 'T': 
            case '[': {
                return this.fieldTypeSig(value, pos);
            }
        }
        return null;
    }

    public Result<ArrayType> arrayTypeSig(String value, int pos) {
        char token = value.charAt(pos);
        switch (token) {
            case '[': {
                Result<? extends Type> tres = this.typeSig(value, ++pos);
                Type type = tres.result();
                return new Result<ArrayType>(this.ts.arrayOf(this.position, type, 1), tres.pos());
            }
        }
        return null;
    }

    public Result<List<Type>> typeSigList(String value, int pos) {
        ArrayList<Type> formals = new ArrayList<Type>();
        char token = value.charAt(pos);
        while (token != ')') {
            Result<? extends Type> ares = this.typeSig(value, pos);
            pos = ares.pos();
            formals.add(ares.result());
            token = value.charAt(pos);
        }
        return new Result<List<Type>>(formals, ++pos);
    }

    public Result<? extends Type> typeSig(String value, int pos) {
        char token = value.charAt(pos);
        switch (token) {
            case 'L': 
            case 'T': 
            case '[': {
                return this.fieldTypeSig(value, pos);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return this.baseType(value, pos);
            }
        }
        return null;
    }

    public Result<MethodSig> methodTypeSig(String value, int pos) {
        char token = value.charAt(pos);
        Result<List<TypeVariable>> fres = null;
        if (token == '<') {
            fres = this.formalTypeParamList(value, ++pos);
            pos = fres.pos();
            this.typeVars = fres.result();
        }
        Result<List<Type>> ares = null;
        token = value.charAt(pos);
        if (token == '(') {
            ares = this.typeSigList(value, ++pos);
            pos = ares.pos();
        }
        Result<? extends Type> rres = this.returnType(value, pos);
        pos = rres.pos();
        Result<List<ReferenceType>> tres = null;
        if (pos < value.length() && (token = value.charAt(pos)) == '^') {
            tres = this.throwsSigList(value, pos);
            pos = tres.pos();
        }
        return new Result<MethodSig>(new MethodSig(fres == null ? new ArrayList() : fres.result(), ares == null ? new ArrayList() : ares.result(), rres.result(), tres == null ? new ArrayList() : tres.result()), pos);
    }

    public Result<? extends Type> returnType(String value, int pos) {
        char token = value.charAt(pos);
        switch (token) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'L': 
            case 'S': 
            case 'T': 
            case 'Z': 
            case '[': {
                return this.typeSig(value, pos);
            }
            case 'V': {
                return new Result<PrimitiveType>(this.ts.Void(), ++pos);
            }
        }
        return null;
    }

    public Result<List<ReferenceType>> throwsSigList(String value, int pos) {
        ArrayList<ReferenceType> throwsList = new ArrayList<ReferenceType>();
        while (pos < value.length()) {
            Result<? extends ReferenceType> tres = this.throwsSig(value, pos);
            pos = tres.pos();
            throwsList.add(tres.result());
        }
        return new Result<List<ReferenceType>>(throwsList, pos);
    }

    public Result<? extends ReferenceType> throwsSig(String value, int pos) {
        char token = value.charAt(pos);
        switch (token) {
            case '^': {
                token = value.charAt(++pos);
                switch (token) {
                    case 'L': {
                        return this.classTypeSig(value, pos);
                    }
                    case 'T': {
                        return this.typeVarSig(value, pos);
                    }
                }
                return null;
            }
        }
        return null;
    }

    public Result<PrimitiveType> baseType(String value, int pos) {
        char token = value.charAt(pos);
        switch (token) {
            case 'B': {
                return new Result<PrimitiveType>(this.ts.Byte(), ++pos);
            }
            case 'C': {
                return new Result<PrimitiveType>(this.ts.Char(), ++pos);
            }
            case 'D': {
                return new Result<PrimitiveType>(this.ts.Double(), ++pos);
            }
            case 'F': {
                return new Result<PrimitiveType>(this.ts.Float(), ++pos);
            }
            case 'I': {
                return new Result<PrimitiveType>(this.ts.Int(), ++pos);
            }
            case 'J': {
                return new Result<PrimitiveType>(this.ts.Long(), ++pos);
            }
            case 'S': {
                return new Result<PrimitiveType>(this.ts.Short(), ++pos);
            }
            case 'Z': {
                return new Result<PrimitiveType>(this.ts.Boolean(), ++pos);
            }
        }
        return null;
    }

    public void parseClassSignature(TypeSystem ts, Position pos) {
        this.ts = (JL5TypeSystem)ts;
        this.position = pos;
        String sigValue = (String)this.cls.getConstants()[this.index].value();
        this.classSignature = this.classSig(sigValue, 0).result();
    }

    public List<TypeVariable> parseClassTypeVariables(TypeSystem ts, Position pos) {
        this.ts = (JL5TypeSystem)ts;
        this.position = pos;
        String sigValue = (String)this.cls.getConstants()[this.index].value();
        char token = sigValue.charAt(0);
        List<TypeVariable> results = null;
        if (token == '<') {
            results = this.createFormalTypeParamList(sigValue, 1).result();
        }
        this.typeVars = results;
        return results;
    }

    public void parseMethodSignature(TypeSystem ts, Position pos, ClassType ct) {
        this.ts = (JL5TypeSystem)ts;
        this.position = pos;
        this.curClass = ct;
        String sigValue = (String)this.cls.getConstants()[this.index].value();
        this.methodSignature = this.methodTypeSig(sigValue, 0).result();
    }

    public void parseFieldSignature(TypeSystem ts, Position pos, ClassType ct) {
        this.ts = (JL5TypeSystem)ts;
        this.position = pos;
        this.curClass = ct;
        String sigValue = (String)this.cls.getConstants()[this.index].value();
        this.fieldSignature = new FieldSig();
        this.fieldSignature.type = this.fieldTypeSig(sigValue, 0).result();
    }

    private TypeVariable findTypeVar(String next) {
        if (this.typeVars != null) {
            for (TypeVariable iType : this.typeVars) {
                if (!iType.name().equals(next)) continue;
                return iType;
            }
        }
        if (this.curClass != null) {
            for (ClassType ct = this.curClass; ct != null; ct = ct.outer()) {
                JL5ParsedClassType pct;
                if (ct instanceof JL5ParsedClassType && (pct = (JL5ParsedClassType)ct).typeVariables() != null) {
                    for (TypeVariable iType : pct.typeVariables()) {
                        if (!iType.name().equals(next)) continue;
                        return iType;
                    }
                }
                if (ct.isInnerClass()) continue;
                return null;
            }
        }
        return null;
    }

    public String toString() {
        return (String)this.cls.getConstants()[this.index].value();
    }

    class Result<T> {
        protected int pos;
        protected T result;

        public Result(T result, int pos) {
            this.result = result;
            this.pos = pos;
        }

        public int pos() {
            return this.pos;
        }

        public T result() {
            return this.result;
        }
    }

    class FieldSig {
        protected Type type;

        FieldSig() {
        }
    }

    class MethodSig {
        protected List<TypeVariable> typeVars;
        protected List<Type> formalTypes;
        protected Type returnType;
        protected List<ReferenceType> throwTypes;

        public MethodSig(List<TypeVariable> typeVars, List<Type> formalTypes, Type returnType, List<ReferenceType> throwTypes) {
            this.typeVars = typeVars;
            this.formalTypes = formalTypes;
            this.returnType = returnType;
            this.throwTypes = throwTypes;
        }

        public List<TypeVariable> typeVars() {
            return this.typeVars;
        }

        public List<Type> formalTypes() {
            return this.formalTypes;
        }

        public Type returnType() {
            return this.returnType;
        }

        public List<ReferenceType> throwTypes() {
            return this.throwTypes;
        }
    }

    class ClassSig {
        protected List<TypeVariable> typeVars;
        protected Type superType;
        protected List<ClassType> interfaces;

        public ClassSig(List<TypeVariable> typeVars, Type superType, List<ClassType> interfaces) {
            this.typeVars = typeVars;
            this.superType = superType;
            this.interfaces = interfaces;
        }

        public List<TypeVariable> typeVars() {
            return this.typeVars;
        }

        public Type superType() {
            return this.superType;
        }

        public List<ClassType> interfaces() {
            return this.interfaces;
        }
    }
}

