/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.reflect;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import polyglot.ext.jl5.types.reflect.Annotations;
import polyglot.ext.jl5.types.reflect.JL5Signature;
import polyglot.types.reflect.Attribute;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.Constant;
import polyglot.types.reflect.Exceptions;
import polyglot.types.reflect.Method;

public class JL5Method
extends Method {
    protected JL5Signature signature;
    protected Annotations runtimeVisibleAnnotations;
    protected Annotations runtimeInvisibleAnnotations;
    protected boolean defaultVal;

    public JL5Method(DataInputStream in, ClassFile clazz) {
        super(in, clazz);
    }

    @Override
    public void initialize() throws IOException {
        this.modifiers = this.in.readUnsignedShort();
        this.name = this.in.readUnsignedShort();
        this.type = this.in.readUnsignedShort();
        int numAttributes = this.in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            long n;
            int nameIndex = this.in.readUnsignedShort();
            int length = this.in.readInt();
            Constant name = this.clazz.getConstants()[nameIndex];
            if (name != null) {
                if ("Exceptions".equals(name.value())) {
                    this.exceptions = new Exceptions(this.clazz, this.in, nameIndex, length);
                    this.attrs[i] = this.exceptions;
                }
                if ("Synthetic".equals(name.value())) {
                    this.synthetic = true;
                }
                if ("AnnotationDefault".equals(name.value())) {
                    this.defaultVal = true;
                }
                if ("Signature".equals(name.value())) {
                    this.signature = new JL5Signature(this.clazz, this.in, nameIndex, length);
                    this.attrs[i] = this.signature;
                }
                if ("RuntimeVisibleAnnotations".equals(name.value())) {
                    this.runtimeVisibleAnnotations = new Annotations(this.clazz, this.in, nameIndex, length);
                    this.attrs[i] = this.runtimeVisibleAnnotations;
                }
                if ("RuntimeInvisibleAnnotations".equals(name.value())) {
                    this.runtimeVisibleAnnotations = new Annotations(this.clazz, this.in, nameIndex, length);
                    this.attrs[i] = this.runtimeVisibleAnnotations;
                }
            }
            if (this.attrs[i] != null || (n = this.in.skip(length)) == (long)length) continue;
            throw new EOFException();
        }
        this.in = null;
    }

    public JL5Signature getSignature() {
        return this.signature;
    }

    public boolean hasDefaultVal() {
        return this.defaultVal;
    }

    public Annotations getRuntimeVisibleAnnotations() {
        return this.runtimeVisibleAnnotations;
    }

    public Annotations getRuntimeInvisibleAnnotations() {
        return this.runtimeInvisibleAnnotations;
    }
}

