/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.reflect;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import polyglot.ext.jl5.types.AnnotationElementValue;
import polyglot.ext.jl5.types.AnnotationTypeElemInstance;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5ConstructorInstance;
import polyglot.ext.jl5.types.JL5FieldInstance;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.reflect.JL5ClassFile;
import polyglot.ext.jl5.types.reflect.JL5Field;
import polyglot.ext.jl5.types.reflect.JL5LazyClassInitializer;
import polyglot.ext.jl5.types.reflect.JL5Method;
import polyglot.ext.jl5.types.reflect.JL5Signature;
import polyglot.ext.param.types.MuPClass;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLazyClassInitializer;
import polyglot.types.reflect.Constant;
import polyglot.types.reflect.Exceptions;
import polyglot.types.reflect.Field;
import polyglot.types.reflect.Method;

public class JL5ClassFileLazyClassInitializer
extends ClassFileLazyClassInitializer
implements JL5LazyClassInitializer {
    protected boolean annotationElemsInitialized;
    protected boolean annotationsInitialized;
    protected boolean enumConstantsInitialized;

    public JL5ClassFileLazyClassInitializer(ClassFile file, TypeSystem ts) {
        super(file, ts);
    }

    @Override
    protected boolean initialized() {
        return super.initialized() && this.annotationElemsInitialized && this.annotationsInitialized && this.enumConstantsInitialized;
    }

    @Override
    protected ParsedClassType createType() throws SemanticException {
        JL5ParsedClassType ct = (JL5ParsedClassType)super.createType();
        JL5Signature signature = ((JL5ClassFile)this.clazz).getSignature();
        if (signature != null) {
            MuPClass<TypeVariable, ReferenceType> pc = ((JL5TypeSystem)this.ts).mutablePClass(ct.position());
            ct.setPClass(pc);
            pc.clazz(ct);
            List<TypeVariable> typeVars = signature.parseClassTypeVariables(this.ts, this.position());
            ct.setTypeVariables(typeVars);
            pc.formals(new ArrayList<TypeVariable>(ct.typeVariables()));
            signature.parseClassSignature(this.ts, this.position());
            ct.superType(signature.classSignature.superType());
            ct.setInterfaces(signature.classSignature.interfaces());
            ct.superType();
            ct.interfaces();
            ct.superType(signature.classSignature.superType());
            ct.setInterfaces(signature.classSignature.interfaces());
        }
        return ct;
    }

    @Override
    protected MethodInstance methodInstance(Method method_, ClassType ct) {
        JL5MethodInstance mi;
        JL5Method method = (JL5Method)method_;
        Constant[] constants = this.clazz.getConstants();
        String name = (String)constants[method.getName()].value();
        String type = (String)constants[method.getType()].value();
        JL5Signature signature = method.getSignature();
        List<ReferenceType> excTypes = new ArrayList<ClassType>();
        Exceptions exceptions = method.getExceptions();
        if (exceptions != null) {
            int[] throwTypes;
            for (int throwType : throwTypes = exceptions.getThrowTypes()) {
                String s = this.clazz.classNameCP(throwType);
                excTypes.add(this.quietTypeForName(s));
            }
        }
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        if (signature != null) {
            signature.parseMethodSignature(ts, this.position(), ct);
            List<ReferenceType> tt = signature.methodSignature.throwTypes();
            if (tt != null && !tt.isEmpty()) {
                excTypes = tt;
            }
            mi = ts.methodInstance(ct.position(), ct, ts.flagsForBits(method.getModifiers()).clearTransient(), signature.methodSignature.returnType(), name, signature.methodSignature.formalTypes(), excTypes, signature.methodSignature.typeVars());
        } else {
            if (type.charAt(0) != '(') {
                throw new ClassFormatError("Bad method type descriptor.");
            }
            int index = type.indexOf(41, 1);
            List<Type> argTypes = this.typeListForString(type.substring(1, index));
            Type returnType = this.typeForString(type.substring(index + 1));
            mi = (JL5MethodInstance)ts.methodInstance(ct.position(), ct, ts.flagsForBits(method.getModifiers()), returnType, name, argTypes, excTypes);
        }
        LinkedHashMap<Type, Map<String, AnnotationElementValue>> annotationElems = new LinkedHashMap<Type, Map<String, AnnotationElementValue>>();
        if (method.getRuntimeVisibleAnnotations() != null) {
            annotationElems.putAll(method.getRuntimeVisibleAnnotations().toAnnotationElems(this, ts));
        }
        if (method.getRuntimeInvisibleAnnotations() != null) {
            annotationElems.putAll(method.getRuntimeInvisibleAnnotations().toAnnotationElems(this, ts));
        }
        Annotations ann = ts.createAnnotations(annotationElems, ct.position());
        mi.setAnnotations(ann);
        return mi;
    }

    @Override
    protected ConstructorInstance constructorInstance(Method method_, ClassType ct, Field[] fields) {
        JL5Method method = (JL5Method)method_;
        JL5MethodInstance mi = (JL5MethodInstance)this.methodInstance(method, ct);
        List<? extends Type> formals = mi.formalTypes();
        if (ct.isInnerClass()) {
            int numSynthetic = 0;
            for (Field field : fields) {
                if (!field.isSynthetic()) continue;
                ++numSynthetic;
            }
            if (numSynthetic <= formals.size()) {
                formals = formals.subList(numSynthetic, formals.size());
            }
        }
        JL5ConstructorInstance ci = ((JL5TypeSystem)this.ts).constructorInstance(mi.position(), ct, mi.flags(), formals, mi.throwTypes(), mi.typeParams());
        ci.setAnnotations(mi.annotations());
        return ci;
    }

    @Override
    protected FieldInstance fieldInstance(Field field_, ClassType ct) {
        Type fieldType;
        JL5Field field = (JL5Field)field_;
        Constant[] constants = this.clazz.getConstants();
        String name = (String)constants[field.getName()].value();
        String type = (String)constants[field.getType()].value();
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        JL5FieldInstance fi = null;
        JL5Signature signature = field.getSignature();
        Flags flags = ts.flagsForBits(field.getModifiers());
        if (signature != null) {
            signature.parseFieldSignature(ts, this.position(), ct);
            fieldType = signature.fieldSignature.type;
        } else {
            fieldType = this.typeForString(type);
        }
        fi = JL5Flags.isEnum(flags) ? ts.enumInstance(ct.position(), ct, flags, name, 0L) : (JL5FieldInstance)ts.fieldInstance(ct.position(), ct, flags, fieldType, name);
        if (field.isConstant()) {
            Constant c = field.constantValue();
            Object o = null;
            try {
                switch (c.tag()) {
                    case 8: {
                        o = field.getString();
                        break;
                    }
                    case 3: {
                        o = new Integer(field.getInt());
                        break;
                    }
                    case 5: {
                        o = new Long(field.getLong());
                        break;
                    }
                    case 4: {
                        o = new Float(field.getFloat());
                        break;
                    }
                    case 6: {
                        o = new Double(field.getDouble());
                    }
                }
            }
            catch (SemanticException e) {
                throw new ClassFormatError("Unexpected constant pool entry.");
            }
            fi.setConstantValue(o);
            return fi;
        }
        fi.setNotConstant();
        LinkedHashMap<Type, Map<String, AnnotationElementValue>> annotationElems = new LinkedHashMap<Type, Map<String, AnnotationElementValue>>();
        if (field.getRuntimeVisibleAnnotations() != null) {
            annotationElems.putAll(field.getRuntimeVisibleAnnotations().toAnnotationElems(this, ts));
        }
        if (field.getRuntimeInvisibleAnnotations() != null) {
            annotationElems.putAll(field.getRuntimeInvisibleAnnotations().toAnnotationElems(this, ts));
        }
        Annotations ann = ts.createAnnotations(annotationElems, ct.position());
        fi.setAnnotations(ann);
        return fi;
    }

    @Override
    public void initEnumConstants() {
        if (this.enumConstantsInitialized) {
            return;
        }
        this.initFields();
        ArrayList<EnumInstance> enumInstances = new ArrayList<EnumInstance>();
        for (FieldInstance fieldInstance : this.ct.fields()) {
            if (!JL5Flags.isEnum(fieldInstance.flags())) continue;
            EnumInstance ei = (EnumInstance)fieldInstance;
            enumInstances.add(ei);
            ((JL5ParsedClassType)this.ct).addEnumConstant(ei);
        }
        long ordinal = 0L;
        for (EnumInstance ei : enumInstances) {
            ei.setOrdinal(ordinal);
            ++ordinal;
        }
        this.enumConstantsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    @Override
    public void initAnnotations() {
        if (this.annotationsInitialized) {
            return;
        }
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        LinkedHashMap<Type, Map<String, AnnotationElementValue>> annotationElems = new LinkedHashMap<Type, Map<String, AnnotationElementValue>>();
        JL5ClassFile cls = (JL5ClassFile)this.clazz;
        if (cls.getRuntimeVisibleAnnotations() != null) {
            annotationElems.putAll(cls.getRuntimeVisibleAnnotations().toAnnotationElems(this, ts));
        }
        if (cls.getRuntimeInvisibleAnnotations() != null) {
            annotationElems.putAll(cls.getRuntimeInvisibleAnnotations().toAnnotationElems(this, ts));
        }
        Annotations retAnn = ts.createAnnotations(annotationElems, this.ct.position());
        ((JL5ParsedClassType)this.ct).setAnnotations(retAnn);
        this.annotationsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    @Override
    public void initAnnotationElems() {
        if (this.annotationElemsInitialized) {
            return;
        }
        Method[] methods = this.clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].name().equals("<init>") || methods[i].name().equals("<clinit>") || methods[i].isSynthetic()) continue;
            AnnotationTypeElemInstance mi = this.annotationElemInstance((JL5Method)methods[i], this.ct, ((JL5Method)methods[i]).hasDefaultVal());
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + mi + " to " + this.ct);
            }
            ((JL5ParsedClassType)this.ct).addAnnotationElem(mi);
        }
        this.annotationElemsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    private AnnotationTypeElemInstance annotationElemInstance(JL5Method annot, ParsedClassType ct, boolean hasDefault) {
        Constant[] constants = this.clazz.getConstants();
        String name = (String)constants[annot.getName()].value();
        String type = (String)constants[annot.getType()].value();
        if (type.charAt(0) != '(') {
            throw new ClassFormatError("Bad annotation type descriptor.");
        }
        int index = type.indexOf(41, 1);
        Type returnType = this.typeForString(type.substring(index + 1));
        return ((JL5TypeSystem)this.ts).annotationElemInstance(ct.position(), ct, this.ts.flagsForBits(annot.getModifiers()), returnType, name, hasDefault);
    }
}

