/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.inference;

import java.util.ArrayList;
import java.util.List;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.WildCardType;
import polyglot.ext.jl5.types.inference.Constraint;
import polyglot.ext.jl5.types.inference.EqualConstraint;
import polyglot.ext.jl5.types.inference.InferenceSolver;
import polyglot.ext.jl5.types.inference.SubConversionConstraint;
import polyglot.ext.jl5.types.inference.SuperTypeConstraint;
import polyglot.types.NullType;
import polyglot.types.ReferenceType;
import polyglot.types.Type;

public class SuperConversionConstraint
extends Constraint {
    public SuperConversionConstraint(Type actual, Type formal, InferenceSolver solver) {
        super(actual, formal, solver);
    }

    @Override
    public List<Constraint> simplify() {
        ArrayList<Constraint> r;
        block10: {
            block12: {
                TypeVariable actual_tv;
                ReferenceType b;
                block13: {
                    block11: {
                        r = new ArrayList<Constraint>();
                        if (this.actual instanceof NullType) break block10;
                        if (!this.solver().isTargetTypeVariable(this.formal)) break block11;
                        r.add(new SuperTypeConstraint(this.actual, this.formal, this.solver));
                        break block10;
                    }
                    if (!this.formal.isArray()) break block12;
                    if (!this.formal.isArray()) break block10;
                    if (!this.actual.isArray() || !this.actual.toArray().base().isReference()) break block13;
                    r.add(new SuperConversionConstraint(this.actual.toArray().base(), this.formal.toArray().base(), this.solver));
                    break block10;
                }
                if (!(this.actual instanceof TypeVariable) || !(b = (actual_tv = (TypeVariable)this.actual).upperBound()).isArray() || !b.toArray().base().isReference()) break block10;
                r.add(new SuperConversionConstraint(b.toArray().base(), this.formal.toArray().base(), this.solver));
                break block10;
            }
            if (this.formal instanceof JL5SubstClassType && this.actual instanceof JL5SubstClassType) {
                JL5SubstClassType formal_pt = (JL5SubstClassType)this.formal;
                JL5SubstClassType actual_pt = (JL5SubstClassType)this.actual;
                if (!actual_pt.base().equals(formal_pt.base())) {
                    JL5SubstClassType f = this.solver.typeSystem().findGenericSupertype(actual_pt.base(), formal_pt);
                    if (f != null) {
                        r.add(new SuperConversionConstraint(this.actual, f, this.solver));
                    }
                } else {
                    JL5ParsedClassType g;
                    for (JL5ParsedClassType cur = g = formal_pt.base(); cur != null; cur = (JL5ParsedClassType)cur.outer()) {
                        for (TypeVariable tv : cur.typeVariables()) {
                            ReferenceType formal_targ = (ReferenceType)formal_pt.subst().substType(tv);
                            ReferenceType actual_targ = (ReferenceType)actual_pt.subst().substType(tv);
                            if (!(formal_targ instanceof WildCardType)) {
                                if (!(actual_targ instanceof WildCardType)) {
                                    r.add(new EqualConstraint(actual_targ, formal_targ, this.solver));
                                    continue;
                                }
                                WildCardType actual_targ_wc = (WildCardType)actual_targ;
                                if (actual_targ_wc.isExtendsConstraint()) {
                                    r.add(new SuperConversionConstraint(actual_targ_wc.upperBound(), formal_targ, this.solver));
                                    continue;
                                }
                                if (!actual_targ_wc.isSuperConstraint()) continue;
                                r.add(new SubConversionConstraint(actual_targ_wc.lowerBound(), formal_targ, this.solver));
                                continue;
                            }
                            if (!(actual_targ instanceof WildCardType)) continue;
                            WildCardType formal_targ_wc = (WildCardType)formal_targ;
                            WildCardType actual_targ_wc = (WildCardType)actual_targ;
                            if (formal_targ_wc.isExtendsConstraint() && actual_targ_wc.isExtendsConstraint()) {
                                r.add(new SuperConversionConstraint(actual_targ_wc.upperBound(), formal_targ_wc.upperBound(), this.solver));
                                continue;
                            }
                            if (!formal_targ_wc.isSuperConstraint() || !actual_targ_wc.isSuperConstraint()) continue;
                            r.add(new SubConversionConstraint(actual_targ_wc.lowerBound(), formal_targ_wc.lowerBound(), this.solver));
                        }
                    }
                }
            }
        }
        return r;
    }

    @Override
    public boolean canSimplify() {
        return true;
    }

    public String toString() {
        return this.actual + " >> " + this.formal;
    }
}

