/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.inference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import polyglot.ext.jl5.JL5Options;
import polyglot.ext.jl5.types.JL5ArrayType;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.inference.Constraint;
import polyglot.ext.jl5.types.inference.EqualConstraint;
import polyglot.ext.jl5.types.inference.InferenceSolver;
import polyglot.ext.jl5.types.inference.SubConversionConstraint;
import polyglot.ext.jl5.types.inference.SubTypeConstraint;
import polyglot.ext.jl5.types.inference.SuperConversionConstraint;
import polyglot.ext.jl5.types.inference.SuperTypeConstraint;
import polyglot.ext.param.types.Subst;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.util.Position;

public class InferenceSolver_c
implements InferenceSolver {
    private JL5TypeSystem ts;
    private JL5ProcedureInstance pi;
    private List<? extends Type> actualArgumentTypes;
    private List<? extends Type> formalTypes;
    private List<TypeVariable> typeVariablesToSolve;

    public InferenceSolver_c(JL5ProcedureInstance pi, List<? extends Type> actuals, JL5TypeSystem ts) {
        this.pi = pi;
        this.typeVariablesToSolve = this.typeVariablesToSolve(pi);
        this.actualArgumentTypes = actuals;
        this.formalTypes = pi.formalTypes();
        this.ts = ts;
    }

    protected List<TypeVariable> typeVariablesToSolve(JL5ProcedureInstance pi) {
        return pi.typeParams();
    }

    @Override
    public boolean isTargetTypeVariable(Type t) {
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            return this.typeVariablesToSolve().contains(tv);
        }
        return false;
    }

    @Override
    public List<TypeVariable> typeVariablesToSolve() {
        return this.typeVariablesToSolve;
    }

    private Type[] solve(List<Constraint> constraints, boolean useSubtypeConstraints, boolean useSupertypeConstraints) {
        ArrayList<EqualConstraint> equals = new ArrayList<EqualConstraint>();
        ArrayList<SubTypeConstraint> subs = new ArrayList<SubTypeConstraint>();
        ArrayList<SuperTypeConstraint> supers = new ArrayList<SuperTypeConstraint>();
        while (!constraints.isEmpty()) {
            Constraint head = constraints.remove(0);
            if (head.canSimplify()) {
                List<Constraint> simps = head.simplify();
                constraints.addAll(0, simps);
                continue;
            }
            if (head instanceof EqualConstraint) {
                EqualConstraint eq = (EqualConstraint)head;
                equals.add(eq);
                continue;
            }
            if (head instanceof SubTypeConstraint) {
                SubTypeConstraint sub = (SubTypeConstraint)head;
                subs.add(sub);
                continue;
            }
            if (!(head instanceof SuperTypeConstraint)) continue;
            SuperTypeConstraint sup = (SuperTypeConstraint)head;
            supers.add(sup);
        }
        Comparator<Constraint> comp = new Comparator<Constraint>(){

            @Override
            public int compare(Constraint o1, Constraint o2) {
                return InferenceSolver_c.this.typeVariablesToSolve().indexOf(o1.formal) - InferenceSolver_c.this.typeVariablesToSolve().indexOf(o2.formal);
            }
        };
        Collections.sort(equals, comp);
        Collections.sort(subs, comp);
        Collections.sort(supers, comp);
        Type[] solution = new Type[this.typeVariablesToSolve().size()];
        for (EqualConstraint eq : equals) {
            int i = this.typeVariablesToSolve().indexOf(eq.formal);
            if (solution[i] != null && !this.ts.equals(eq.actual, solution[i])) {
                return null;
            }
            solution[i] = eq.actual;
        }
        ArrayList<SubTypeConstraint> subSupConstraints = useSubtypeConstraints ? subs : supers;
        for (int i = 0; i < solution.length; ++i) {
            if (solution[i] != null) continue;
            TypeVariable toSolve = this.typeVariablesToSolve().get(i);
            LinkedHashSet<ReferenceType> bounds = new LinkedHashSet<ReferenceType>();
            for (Constraint constraint : subSupConstraints) {
                if (!constraint.formal.equals(toSolve) || !constraint.actual.isReference()) continue;
                bounds.add((ReferenceType)constraint.actual);
            }
            ArrayList<ReferenceType> u = new ArrayList<ReferenceType>(bounds);
            if (u.size() == 1) {
                solution[i] = (Type)u.get(0);
                continue;
            }
            if (u.size() <= 1) continue;
            if (useSubtypeConstraints) {
                solution[i] = this.ts.lub(Position.compilerGenerated(), u);
                if (solution[i].isSubtype(toSolve.upperBound())) continue;
                return null;
            }
            solution[i] = this.ts.glb(Position.compilerGenerated(), u);
        }
        return solution;
    }

    private List<Constraint> getInitialConstraints() {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        int numFormals = this.formalTypes.size();
        for (int i = 0; i < numFormals - 1; ++i) {
            constraints.add(new SubConversionConstraint(this.actualArgumentTypes.get(i), this.formalTypes.get(i), this));
        }
        if (numFormals > 0) {
            if (this.pi != null && JL5Flags.isVarArgs(this.pi.flags())) {
                JL5ArrayType lastFormal = (JL5ArrayType)this.pi.formalTypes().get(numFormals - 1);
                if (this.actualArgumentTypes.size() == numFormals && this.actualArgumentTypes.get(numFormals - 1).isArray()) {
                    constraints.add(new SubConversionConstraint(this.actualArgumentTypes.get(numFormals - 1), this.formalTypes.get(numFormals - 1), this));
                } else {
                    for (int i = numFormals - 1; i < this.actualArgumentTypes.size(); ++i) {
                        constraints.add(new SubConversionConstraint(this.actualArgumentTypes.get(i), lastFormal.base(), this));
                    }
                }
            } else if (numFormals == this.actualArgumentTypes.size()) {
                constraints.add(new SubConversionConstraint(this.actualArgumentTypes.get(numFormals - 1), this.formalTypes.get(numFormals - 1), this));
            }
        }
        return constraints;
    }

    @Override
    public Map<TypeVariable, ReferenceType> solve(Type expectedReturnType) {
        Type[] solution = this.solve(this.getInitialConstraints(), true, false);
        if (solution == null) {
            return null;
        }
        if (InferenceSolver_c.hasUnresolvedTypeArguments(solution)) {
            solution = this.handleUnresolvedTypeArgs(solution, expectedReturnType);
        } else {
            JL5Options opts = (JL5Options)this.ts.extensionInfo().getOptions();
            Type returnType = this.returnType(this.pi);
            if (opts.morePermissiveInference && returnType != null && returnType.isReference() && !returnType.isVoid() && expectedReturnType != null) {
                ArrayList<Constraint> cons = new ArrayList<Constraint>();
                cons.addAll(this.getInitialConstraints());
                cons.add(new SuperConversionConstraint(expectedReturnType, returnType, this));
                Type[] betterSolution = this.solve(cons, true, false);
                if (betterSolution != null) {
                    solution = betterSolution;
                }
            }
        }
        LinkedHashMap<TypeVariable, ReferenceType> m = new LinkedHashMap<TypeVariable, ReferenceType>();
        for (int i = 0; i < solution.length; ++i) {
            if (solution[i] == null) {
                solution[i] = this.ts.Object();
            }
            m.put(this.typeVariablesToSolve().get(i), (ReferenceType)solution[i]);
        }
        return m;
    }

    private Type[] handleUnresolvedTypeArgs(Type[] solution, Type expectedReturnType) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        constraints.addAll(this.getInitialConstraints());
        LinkedHashMap<TypeVariable, ReferenceType> m = new LinkedHashMap<TypeVariable, ReferenceType>();
        for (int i = 0; i < solution.length; ++i) {
            ReferenceType t = (ReferenceType)solution[i];
            if (t == null) {
                t = this.typeVariablesToSolve().get(i);
            }
            m.put(this.typeVariablesToSolve().get(i), t);
        }
        Subst subst = this.ts.subst(m);
        Type returnType = this.returnType(this.pi);
        if (returnType != null && returnType.isReference() && !returnType.isVoid()) {
            if (expectedReturnType == null) {
                expectedReturnType = this.ts.Object();
            }
            Type rt = subst.substType(returnType);
            constraints.add(new SuperConversionConstraint(expectedReturnType, rt, this));
        }
        for (int i = 0; i < solution.length; ++i) {
            TypeVariable ti = this.typeVariablesToSolve().get(i);
            Type bi = subst.substType(ti.upperBound());
            constraints.add(new SuperConversionConstraint(bi, ti, this));
        }
        Type[] remainingSolution = this.solve(constraints, false, true);
        for (int i = 0; i < solution.length; ++i) {
            if (solution[i] != null) continue;
            solution[i] = remainingSolution[i];
        }
        return solution;
    }

    protected Type returnType(JL5ProcedureInstance pi) {
        if (pi instanceof MethodInstance) {
            return ((MethodInstance)((Object)pi)).returnType();
        }
        return null;
    }

    private static boolean hasUnresolvedTypeArguments(Type[] solution) {
        for (Type element : solution) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public JL5TypeSystem typeSystem() {
        return this.ts;
    }

    public JL5ProcedureInstance procedureInstance() {
        return this.pi;
    }
}

