/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.List;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.ReferenceType_c;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class TypeVariable_c
extends ReferenceType_c
implements TypeVariable {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected String name;
    protected TypeVariable.TVarDecl declaredIn;
    protected ClassType declaringClass;
    protected JL5ProcedureInstance declaringProcedure;
    protected transient Long syntheticUniqueId;
    private static long idCount = 1L;
    protected ReferenceType upperBound;
    protected ReferenceType lowerBound = null;
    private static final long writeObjectVersionUID = 2L;

    public TypeVariable_c(TypeSystem ts, Position pos, String id, ReferenceType upperBound) {
        super(ts, pos);
        this.name = id;
        if (this.name == null) {
            throw new InternalCompilerError("TypeVariables must be given a name.");
        }
        if (upperBound == null) {
            upperBound = ts.Object();
        }
        this.upperBound = upperBound;
        this.syntheticUniqueId = idCount++;
    }

    @Override
    public void setDeclaringProcedure(JL5ProcedureInstance pi) {
        if (this.declaredIn == TypeVariable.TVarDecl.PROCEDURE_TYPE_VARIABLE && this.declaringProcedure == pi) {
            return;
        }
        if (this.declaredIn != null) {
            throw new InternalCompilerError("Can only set declaredIn once: was " + (Object)((Object)this.declaredIn) + "&" + this.declaringProcedure + " now wants to be Procedure&" + pi + this, this.position);
        }
        this.declaredIn = TypeVariable.TVarDecl.PROCEDURE_TYPE_VARIABLE;
        this.declaringProcedure = pi;
        this.declaringClass = null;
        this.syntheticUniqueId = null;
    }

    @Override
    public void setDeclaringClass(ClassType ct) {
        if (this.declaredIn == TypeVariable.TVarDecl.CLASS_TYPE_VARIABLE && this.declaringClass == ct) {
            return;
        }
        if (this.declaredIn != null) {
            throw new InternalCompilerError("Can only set declaredIn once", this.position);
        }
        this.declaredIn = TypeVariable.TVarDecl.CLASS_TYPE_VARIABLE;
        this.declaringProcedure = null;
        this.declaringClass = ct;
        this.syntheticUniqueId = null;
    }

    @Override
    public void setSyntheticOrigin() {
        if (this.declaredIn == TypeVariable.TVarDecl.SYNTHETIC_TYPE_VARIABLE) {
            return;
        }
        if (this.declaredIn != null) {
            throw new InternalCompilerError("Can only set declaredIn once", this.position);
        }
        this.declaredIn = TypeVariable.TVarDecl.SYNTHETIC_TYPE_VARIABLE;
        this.declaringProcedure = null;
        this.declaringClass = null;
    }

    @Override
    public TypeVariable.TVarDecl declaredIn() {
        return this.declaredIn;
    }

    @Override
    public ClassType declaringClass() {
        if (this.declaredIn == TypeVariable.TVarDecl.CLASS_TYPE_VARIABLE) {
            return this.declaringClass;
        }
        return null;
    }

    @Override
    public JL5ProcedureInstance declaringProcedure() {
        if (this.declaredIn == TypeVariable.TVarDecl.PROCEDURE_TYPE_VARIABLE) {
            return this.declaringProcedure;
        }
        return null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String fullName() {
        return this.name();
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public List<? extends MethodInstance> methods() {
        return Collections.emptyList();
    }

    @Override
    public List<? extends FieldInstance> fields() {
        return Collections.emptyList();
    }

    @Override
    public FieldInstance fieldNamed(String name) {
        for (FieldInstance fieldInstance : this.fields()) {
            if (!fieldInstance.name().equals(name)) continue;
            return fieldInstance;
        }
        return null;
    }

    @Override
    public List<? extends ReferenceType> interfaces() {
        return Collections.emptyList();
    }

    @Override
    public ReferenceType erasureType() {
        return (ReferenceType)((JL5TypeSystem)this.typeSystem()).erasureType(this);
    }

    @Override
    public Type superType() {
        return this.upperBound;
    }

    @Override
    public String translate(Resolver c) {
        return this.name();
    }

    @Override
    public String toString() {
        return this.name();
    }

    @Override
    public boolean isCastValidImpl(Type toType) {
        if (super.isCastValidImpl(toType)) {
            return true;
        }
        return this.ts.isCastValid(this.upperBound(), toType);
    }

    @Override
    public boolean descendsFromImpl(Type ancestor) {
        if (super.descendsFromImpl(ancestor)) {
            return true;
        }
        return this.ts.isSubtype(this.upperBound, ancestor);
    }

    @Override
    public boolean isImplicitCastValidImpl(Type toType) {
        if (super.isImplicitCastValidImpl(toType)) {
            return true;
        }
        return this.ts.isImplicitCastValid(this.upperBound, toType);
    }

    @Override
    public boolean hasLowerBound() {
        return this.lowerBound != null;
    }

    @Override
    public ReferenceType lowerBound() {
        return this.lowerBound;
    }

    @Override
    public void setLowerBound(ReferenceType lowerBound) {
        this.lowerBound = lowerBound;
    }

    @Override
    public ReferenceType upperBound() {
        return this.upperBound;
    }

    @Override
    public void setUpperBound(ReferenceType upperBound) {
        this.upperBound = upperBound;
    }

    @Override
    public TypeVariable upperBound(ReferenceType upperBound) {
        if (this.upperBound.equals(upperBound)) {
            return this;
        }
        TypeVariable tv = (TypeVariable)((Object)this.copy());
        tv.setUpperBound(upperBound);
        return tv;
    }

    @Override
    public boolean equalsImpl(TypeObject t) {
        if (this == t) {
            return true;
        }
        if (this.name == null) {
            return this == t;
        }
        if (t instanceof TypeVariable_c) {
            TypeVariable_c other = (TypeVariable_c)t;
            return (this.name == other.name || this.name != null && this.name().equals(other.name())) && this.declaredIn == other.declaredIn && (this.syntheticUniqueId == other.syntheticUniqueId || this.syntheticUniqueId != null && this.syntheticUniqueId.equals(other.syntheticUniqueId)) && this.declaringClass == other.declaringClass && this.declaringProcedure == other.declaringProcedure;
        }
        return false;
    }

    @Override
    public boolean typeEqualsImpl(Type t) {
        return this.equalsImpl(t);
    }

    @Override
    public int hashCode() {
        return (this.name == null ? 0 : this.name.hashCode()) ^ (this.syntheticUniqueId == null ? 0 : this.syntheticUniqueId.hashCode());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.declaredIn == null || this.declaredIn == TypeVariable.TVarDecl.SYNTHETIC_TYPE_VARIABLE) {
            throw new InternalCompilerError("Shouldn't serialize unknown or synthetic type variables", this.position());
        }
        out.defaultWriteObject();
    }
}

