/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import polyglot.ext.jl5.types.AnnotationTypeElemInstance;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5ClassType_c;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5Subst;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5SubstClassType_c;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.Package;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class RawClass_c
extends JL5ClassType_c
implements RawClass {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private JL5ParsedClassType base;
    private transient JL5SubstClassType erased;
    private transient List<? extends ConstructorInstance> constructors = null;
    private transient List<? extends ClassType> memberClasses = null;
    private transient List<? extends MethodInstance> methods = null;
    private transient List<? extends FieldInstance> fields = null;

    public RawClass_c(JL5ParsedClassType t, Position pos) {
        super((JL5TypeSystem)t.typeSystem(), pos);
        this.base = t;
        this.setDeclaration(this.base);
    }

    @Override
    public boolean isRawClass() {
        return true;
    }

    @Override
    public JL5ParsedClassType base() {
        return this.base;
    }

    @Override
    public JL5SubstClassType erased() {
        if (this.erased == null) {
            JL5TypeSystem ts = (JL5TypeSystem)this.ts;
            JL5Subst es = ts.erasureSubst(this.base);
            if (es == null) {
                throw new InternalCompilerError("Can't have a raw class for " + this.base + " unless it, or a container, has a type variable!", this.position());
            }
            this.erased = new JL5SubstClassType_c(ts, this.base.position(), this.base, es);
        }
        return this.erased;
    }

    @Override
    public List<EnumInstance> enumConstants() {
        return this.erased().enumConstants();
    }

    @Override
    public Job job() {
        return null;
    }

    @Override
    public ClassType.Kind kind() {
        return this.erased().kind();
    }

    @Override
    public ClassType outer() {
        ClassType t = this.erased().outer();
        if (t == null) {
            return t;
        }
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        return (ClassType)ts.erasureType(this.erased().outer());
    }

    @Override
    public String name() {
        return this.erased().name();
    }

    @Override
    public Package package_() {
        return this.erased().package_();
    }

    @Override
    public Flags flags() {
        return this.erased().flags();
    }

    @Override
    public List<? extends ConstructorInstance> constructors() {
        if (this.constructors == null) {
            this.constructors = this.erased().constructors();
        }
        return this.constructors;
    }

    @Override
    public List<? extends ClassType> memberClasses() {
        if (this.memberClasses == null) {
            this.memberClasses = this.erased().memberClasses();
        }
        return this.memberClasses;
    }

    @Override
    public List<? extends MethodInstance> methods() {
        if (this.methods == null) {
            this.methods = this.erased().methods();
        }
        return this.methods;
    }

    @Override
    public List<? extends FieldInstance> fields() {
        if (this.fields == null) {
            this.fields = this.erased().fields();
            for (FieldInstance fieldInstance : this.fields) {
                fieldInstance.setContainer(this);
            }
        }
        return this.fields;
    }

    @Override
    public List<? extends ReferenceType> interfaces() {
        List<? extends ReferenceType> origInts = this.erased().interfaces();
        if (origInts == null || origInts.isEmpty()) {
            return origInts;
        }
        ArrayList<ReferenceType> ints = new ArrayList<ReferenceType>();
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        for (ReferenceType referenceType : origInts) {
            ints.add((ReferenceType)ts.erasureType(referenceType));
        }
        return ints;
    }

    @Override
    public Type superType() {
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        if (this.erased().superType() == null) {
            return null;
        }
        return ts.erasureType(this.erased().superType());
    }

    @Override
    public Set<? extends Type> superclasses() {
        Set<? extends Type> origInts = this.erased().superclasses();
        if (origInts == null || origInts.isEmpty()) {
            return origInts;
        }
        LinkedHashSet<Type> ints = new LinkedHashSet<Type>();
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        for (Type type : origInts) {
            ints.add(ts.erasureType(type));
        }
        return ints;
    }

    @Override
    public boolean equalsImpl(TypeObject t) {
        if (super.equalsImpl(t)) {
            return true;
        }
        if (t instanceof RawClass) {
            RawClass rt = (RawClass)t;
            return this.typeSystem().equals(this.base(), rt.base());
        }
        return false;
    }

    @Override
    public boolean typeEqualsImpl(Type t) {
        if (super.typeEqualsImpl(t)) {
            return true;
        }
        if (t instanceof RawClass) {
            RawClass rt = (RawClass)t;
            return this.typeSystem().typeEquals(this.base(), rt.base());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.base.hashCode();
    }

    @Override
    public String translateAsReceiver(Resolver c) {
        return this.base.translate(c);
    }

    @Override
    public boolean descendsFromImpl(Type ancestor) {
        return super.descendsFromImpl(ancestor);
    }

    @Override
    public boolean inStaticContext() {
        return this.erased().inStaticContext();
    }

    @Override
    public void setFlags(Flags flags) {
        throw new InternalCompilerError("Should never be called");
    }

    @Override
    public void setContainer(ReferenceType container) {
        throw new InternalCompilerError("Should never be called");
    }

    @Override
    public AnnotationTypeElemInstance annotationElemNamed(String name) {
        return this.erased().annotationElemNamed(name);
    }

    @Override
    public List<AnnotationTypeElemInstance> annotationElems() {
        return this.erased().annotationElems();
    }

    @Override
    public Annotations annotations() {
        return ((JL5TypeSystem)this.typeSystem()).NoAnnotations();
    }
}

