/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.ClassLit;
import polyglot.ast.Expr;
import polyglot.ast.NullLit;
import polyglot.ast.Term;
import polyglot.ext.jl5.JL5Options;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.ElementValueArrayInit;
import polyglot.ext.jl5.ast.EnumConstant;
import polyglot.ext.jl5.ast.J5Lang_c;
import polyglot.ext.jl5.types.AnnotationElementValue;
import polyglot.ext.jl5.types.AnnotationElementValueAnnotation;
import polyglot.ext.jl5.types.AnnotationElementValueAnnotation_c;
import polyglot.ext.jl5.types.AnnotationElementValueArray;
import polyglot.ext.jl5.types.AnnotationElementValueArray_c;
import polyglot.ext.jl5.types.AnnotationElementValueConstant;
import polyglot.ext.jl5.types.AnnotationElementValueConstant_c;
import polyglot.ext.jl5.types.AnnotationTypeElemInstance;
import polyglot.ext.jl5.types.AnnotationTypeElemInstance_c;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.Annotations_c;
import polyglot.ext.jl5.types.CaptureConvertedWildCardType;
import polyglot.ext.jl5.types.CaptureConvertedWildCardType_c;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.EnumInstance_c;
import polyglot.ext.jl5.types.IntersectionType;
import polyglot.ext.jl5.types.IntersectionType_c;
import polyglot.ext.jl5.types.JL5ArrayType;
import polyglot.ext.jl5.types.JL5ArrayType_c;
import polyglot.ext.jl5.types.JL5ClassType;
import polyglot.ext.jl5.types.JL5ConstructorInstance;
import polyglot.ext.jl5.types.JL5ConstructorInstance_c;
import polyglot.ext.jl5.types.JL5Context_c;
import polyglot.ext.jl5.types.JL5FieldInstance;
import polyglot.ext.jl5.types.JL5FieldInstance_c;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5ImportTable;
import polyglot.ext.jl5.types.JL5LocalInstance_c;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5MethodInstance_c;
import polyglot.ext.jl5.types.JL5NullType_c;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5ParsedClassType_c;
import polyglot.ext.jl5.types.JL5PrimitiveType_c;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5RawSubst_c;
import polyglot.ext.jl5.types.JL5SchedulerClassInitializer;
import polyglot.ext.jl5.types.JL5Subst;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5SubstClassType_c;
import polyglot.ext.jl5.types.JL5SubstType;
import polyglot.ext.jl5.types.JL5Subst_c;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl5.types.RawClass_c;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.TypeVariable_c;
import polyglot.ext.jl5.types.UnknownReferenceType;
import polyglot.ext.jl5.types.UnknownReferenceType_c;
import polyglot.ext.jl5.types.UnknownTypeVariable;
import polyglot.ext.jl5.types.UnknownTypeVariable_c;
import polyglot.ext.jl5.types.WildCardType;
import polyglot.ext.jl5.types.WildCardType_c;
import polyglot.ext.jl5.types.inference.InferenceSolver;
import polyglot.ext.jl5.types.inference.InferenceSolver_c;
import polyglot.ext.jl5.types.inference.LubType;
import polyglot.ext.jl5.types.inference.LubType_c;
import polyglot.ext.jl5.types.reflect.JL5ClassFileLazyClassInitializer;
import polyglot.ext.param.types.PClass;
import polyglot.ext.param.types.ParamTypeSystem_c;
import polyglot.ext.param.types.Subst;
import polyglot.frontend.Source;
import polyglot.main.Report;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.ImportTable;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.NoMemberException;
import polyglot.types.NullType;
import polyglot.types.Package;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLazyClassInitializer;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class JL5TypeSystem_c
extends ParamTypeSystem_c<TypeVariable, ReferenceType>
implements JL5TypeSystem {
    protected ClassType ENUM_;
    protected ClassType ANNOTATION_;
    protected ClassType OVERRIDE_ANNOTATION_;
    protected ClassType TARGET_ANNOTATION_;
    protected ClassType RETENTION_ANNOTATION_;
    protected ClassType ELEMENT_TYPE_;
    protected ClassType ITERABLE_;
    protected ClassType ITERATOR_;
    Map<Type, ArrayType> varargsArrayTypeCache = new HashMap<Type, ArrayType>();
    protected UnknownReferenceType unknownReferenceType = new UnknownReferenceType_c(this);

    @Override
    public ClassType Enum() {
        if (this.ENUM_ != null) {
            return this.ENUM_;
        }
        this.ENUM_ = this.load("java.lang.Enum");
        return this.ENUM_;
    }

    @Override
    public ClassType Annotation() {
        if (this.ANNOTATION_ != null) {
            return this.ANNOTATION_;
        }
        this.ANNOTATION_ = this.load("java.lang.annotation.Annotation");
        return this.ANNOTATION_;
    }

    @Override
    public ClassType OverrideAnnotation() {
        if (this.OVERRIDE_ANNOTATION_ != null) {
            return this.OVERRIDE_ANNOTATION_;
        }
        this.OVERRIDE_ANNOTATION_ = this.load("java.lang.Override");
        return this.OVERRIDE_ANNOTATION_;
    }

    @Override
    public ClassType TargetAnnotation() {
        if (this.TARGET_ANNOTATION_ != null) {
            return this.TARGET_ANNOTATION_;
        }
        this.TARGET_ANNOTATION_ = this.load("java.lang.annotation.Target");
        return this.TARGET_ANNOTATION_;
    }

    @Override
    public ClassType RetentionAnnotation() {
        if (this.RETENTION_ANNOTATION_ != null) {
            return this.RETENTION_ANNOTATION_;
        }
        this.RETENTION_ANNOTATION_ = this.load("java.lang.annotation.Retention");
        return this.RETENTION_ANNOTATION_;
    }

    @Override
    public ClassType AnnotationElementType() {
        if (this.ELEMENT_TYPE_ != null) {
            return this.ELEMENT_TYPE_;
        }
        this.ELEMENT_TYPE_ = this.load("java.lang.annotation.ElementType");
        return this.ELEMENT_TYPE_;
    }

    @Override
    public ClassType Iterable() {
        if (this.ITERABLE_ != null) {
            return this.ITERABLE_;
        }
        this.ITERABLE_ = this.load("java.lang.Iterable");
        return this.ITERABLE_;
    }

    @Override
    public ClassType Iterator() {
        if (this.ITERATOR_ != null) {
            return this.ITERATOR_;
        }
        this.ITERATOR_ = this.load("java.util.Iterator");
        return this.ITERATOR_;
    }

    @Override
    public LazyClassInitializer defaultClassInitializer() {
        return new JL5SchedulerClassInitializer(this);
    }

    @Override
    public boolean accessibleFromPackage(Flags flags, Package pkg1, Package pkg2) {
        return super.accessibleFromPackage(flags, pkg1, pkg2);
    }

    @Override
    public ClassType wrapperClassOfPrimitive(PrimitiveType t) {
        try {
            return (ClassType)this.typeForName(t.wrapperTypeString(this));
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Couldn't find primitive wrapper " + t.wrapperTypeString(this), e);
        }
    }

    @Override
    public PrimitiveType primitiveTypeOfWrapper(Type l) {
        try {
            if (l.equals(this.typeForName("java.lang.Boolean"))) {
                return this.Boolean();
            }
            if (l.equals(this.typeForName("java.lang.Character"))) {
                return this.Char();
            }
            if (l.equals(this.typeForName("java.lang.Byte"))) {
                return this.Byte();
            }
            if (l.equals(this.typeForName("java.lang.Short"))) {
                return this.Short();
            }
            if (l.equals(this.typeForName("java.lang.Integer"))) {
                return this.Int();
            }
            if (l.equals(this.typeForName("java.lang.Long"))) {
                return this.Long();
            }
            if (l.equals(this.typeForName("java.lang.Float"))) {
                return this.Float();
            }
            if (l.equals(this.typeForName("java.lang.Double"))) {
                return this.Double();
            }
            if (l.equals(this.typeForName("java.lang.Void"))) {
                return this.Void();
            }
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Couldn't find wrapper class");
        }
        return null;
    }

    @Override
    public boolean isPrimitiveWrapper(Type l) {
        return this.primitiveTypeOfWrapper(l) != null;
    }

    @Override
    public Flags legalTopLevelClassFlags() {
        return JL5Flags.setAnnotation(JL5Flags.setEnum(super.legalTopLevelClassFlags()));
    }

    @Override
    public Flags legalMemberClassFlags() {
        return JL5Flags.setAnnotation(JL5Flags.setEnum(super.legalMemberClassFlags()));
    }

    @Override
    protected void checkCycles(ReferenceType curr, ReferenceType goal) throws SemanticException {
        super.checkCycles(curr, goal);
        if (curr instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)curr;
            this.checkCycles(tv.upperBound(), goal);
        }
    }

    @Override
    public ConstructorInstance defaultConstructor(Position pos, ClassType container) {
        this.assert_(container);
        Flags access = Flags.NONE;
        if (container.flags().isPrivate() || JL5Flags.isEnum(container.flags())) {
            access = access.Private();
        } else if (container.flags().isProtected()) {
            access = access.Protected();
        } else if (container.flags().isPublic()) {
            access = access.Public();
        }
        return this.constructorInstance(pos, container, access, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ParsedClassType createClassType(LazyClassInitializer init, Source fromSource) {
        return new JL5ParsedClassType_c(this, init, fromSource);
    }

    @Override
    protected PrimitiveType createPrimitive(PrimitiveType.Kind kind) {
        return new JL5PrimitiveType_c((TypeSystem)this, kind);
    }

    @Override
    protected NullType createNull() {
        return new JL5NullType_c(this);
    }

    @Override
    public EnumInstance findEnumConstant(ReferenceType container, String name, Context c) throws SemanticException {
        ClassType ct = null;
        if (c != null) {
            ct = c.currentClass();
        }
        return this.findEnumConstant(container, name, ct);
    }

    @Override
    public EnumInstance findEnumConstant(ReferenceType container, String name, ClassType currClass) throws SemanticException {
        Set<EnumInstance> enumConstants = this.findEnumConstants(container, name);
        if (enumConstants.size() == 0) {
            throw new NoMemberException(4, "Enum Constant: \"" + name + "\" not found in type \"" + container + "\".");
        }
        Iterator i = enumConstants.iterator();
        EnumInstance ei = (EnumInstance)i.next();
        if (i.hasNext()) {
            EnumInstance ei2 = (EnumInstance)i.next();
            throw new SemanticException("Enum Constant \"" + name + "\" is ambiguous; it is defined in both " + ei.container() + " and " + ei2.container() + ".");
        }
        if (currClass != null && !this.isAccessible((MemberInstance)ei, currClass) && !this.isInherited(ei, currClass)) {
            throw new SemanticException("Cannot access " + ei + ".");
        }
        return ei;
    }

    @Override
    public EnumInstance findEnumConstant(ReferenceType container, String name) throws SemanticException {
        return this.findEnumConstant(container, name, (ClassType)null);
    }

    @Override
    public EnumInstance findEnumConstant(ReferenceType container, long ordinal) throws SemanticException {
        this.assert_(container);
        if (container == null) {
            throw new InternalCompilerError("Cannot access enum constant within a null container type.");
        }
        if (!container.isClass()) {
            throw new InternalCompilerError("Cannot access enum constant within a non-class container type.");
        }
        JL5ClassType ct = (JL5ClassType)container;
        for (EnumInstance ec : ct.enumConstants()) {
            if (ec.ordinal() != ordinal) continue;
            return ec;
        }
        return null;
    }

    public Set<EnumInstance> findEnumConstants(ReferenceType container, String name) {
        this.assert_(container);
        if (container == null) {
            throw new InternalCompilerError("Cannot access enum constant \"" + name + "\" within a null container type.");
        }
        EnumInstance ei = null;
        if (container instanceof JL5ClassType) {
            ei = ((JL5ClassType)container).enumConstantNamed(name);
        }
        if (ei != null) {
            return Collections.singleton(ei);
        }
        return new HashSet<EnumInstance>();
    }

    @Override
    public EnumInstance enumInstance(Position pos, ClassType ct, Flags f, String name, long ordinal) {
        this.assert_(ct);
        return new EnumInstance_c((JL5TypeSystem)this, pos, (ReferenceType)ct, f, name, ordinal);
    }

    @Override
    public Context createContext() {
        return new JL5Context_c(J5Lang_c.instance, this);
    }

    @Override
    public FieldInstance findFieldOrEnum(ReferenceType container, String name, ClassType currClass) throws SemanticException {
        FieldInstance fi = null;
        try {
            fi = this.findField(container, name, currClass, true);
        }
        catch (NoMemberException e) {
            fi = this.findEnumConstant(container, name, currClass);
        }
        return fi;
    }

    @Override
    public MethodInstance methodInstance(Position pos, ReferenceType container, Flags flags, Type returnType, String name, List<? extends Type> argTypes, List<? extends Type> excTypes) {
        return this.methodInstance(pos, container, flags, returnType, name, argTypes, excTypes, Collections.emptyList());
    }

    @Override
    public JL5MethodInstance methodInstance(Position pos, ReferenceType container, Flags flags, Type returnType, String name, List<? extends Type> argTypes, List<? extends Type> excTypes, List<TypeVariable> typeParams) {
        this.assert_(container);
        this.assert_(returnType);
        this.assert_(argTypes);
        this.assert_(excTypes);
        this.assert_(typeParams);
        return new JL5MethodInstance_c(this, pos, container, flags, returnType, name, argTypes, excTypes, typeParams);
    }

    @Override
    public ConstructorInstance constructorInstance(Position pos, ClassType container, Flags flags, List<? extends Type> argTypes, List<? extends Type> excTypes) {
        return this.constructorInstance(pos, container, flags, argTypes, excTypes, Collections.emptyList());
    }

    @Override
    public JL5ConstructorInstance constructorInstance(Position pos, ClassType container, Flags flags, List<? extends Type> argTypes, List<? extends Type> excTypes, List<TypeVariable> typeParams) {
        this.assert_(container);
        this.assert_(argTypes);
        this.assert_(excTypes);
        this.assert_(typeParams);
        return new JL5ConstructorInstance_c(this, pos, container, flags, argTypes, excTypes, typeParams);
    }

    @Override
    public LocalInstance localInstance(Position pos, Flags flags, Type type, String name) {
        return new JL5LocalInstance_c(this, pos, flags, type, name);
    }

    @Override
    public JL5FieldInstance fieldInstance(Position pos, ReferenceType container, Flags flags, Type type, String name) {
        this.assert_(container);
        this.assert_(type);
        return new JL5FieldInstance_c(this, pos, container, flags, type, name);
    }

    @Override
    public TypeVariable typeVariable(Position pos, String name, ReferenceType upperBound) {
        return new TypeVariable_c(this, pos, name, upperBound);
    }

    @Override
    public UnknownTypeVariable unknownTypeVariable(Position position) {
        return new UnknownTypeVariable_c(this);
    }

    @Override
    public boolean isBaseCastValid(Type fromType, Type toType) {
        if (toType.isArray()) {
            Type base = ((ArrayType)toType).base();
            this.assert_(base);
            return this.isImplicitCastValid(fromType, base);
        }
        return false;
    }

    @Override
    public boolean numericConversionBaseValid(Type t, Object value) {
        if (t.isArray()) {
            return super.numericConversionValid(((ArrayType)t).base(), value);
        }
        return false;
    }

    @Override
    public Flags flagsForBits(int bits) {
        Flags f = super.flagsForBits(bits);
        if ((bits & 0x4000) != 0) {
            f = JL5Flags.setEnum(f);
        }
        if ((bits & 0x80) != 0) {
            f = JL5Flags.setVarArgs(f);
        }
        if ((bits & 0x2000) != 0) {
            f = JL5Flags.setAnnotation(f);
        }
        return f;
    }

    @Override
    public ClassFileLazyClassInitializer classFileLazyClassInitializer(ClassFile clazz) {
        return new JL5ClassFileLazyClassInitializer(clazz, this);
    }

    @Override
    public ImportTable importTable(String sourceName, Package pkg) {
        this.assert_(pkg);
        return new JL5ImportTable(this, pkg, sourceName);
    }

    @Override
    public ImportTable importTable(Package pkg) {
        this.assert_(pkg);
        return new JL5ImportTable(this, pkg);
    }

    protected ArrayType createArrayType(Position pos, Type type, boolean isVarargs) {
        JL5ArrayType_c at = new JL5ArrayType_c(this, pos, type, isVarargs);
        return at;
    }

    @Override
    public ArrayType arrayOf(Position position, Type type, boolean isVarargs) {
        return this.arrayType(position, type, isVarargs);
    }

    @Override
    protected ArrayType createArrayType(Position pos, Type type) {
        return new JL5ArrayType_c(this, pos, type, false);
    }

    protected ArrayType arrayType(Position pos, Type type, boolean isVarargs) {
        if (isVarargs) {
            ArrayType t = this.varargsArrayTypeCache.get(type);
            if (t == null) {
                t = this.createArrayType(pos, type, isVarargs);
                this.varargsArrayTypeCache.put(type, t);
            }
            return t;
        }
        return super.arrayType(pos, type);
    }

    @Override
    protected List<? extends MethodInstance> findAcceptableMethods(ReferenceType container, String name, List<? extends Type> argTypes, ClassType currClass, boolean fromClient) throws SemanticException {
        return this.findAcceptableMethods(container, name, argTypes, Collections.emptyList(), currClass, fromClient);
    }

    protected List<? extends MethodInstance> findAcceptableMethods(ReferenceType container, String name, List<? extends Type> argTypes, List<? extends ReferenceType> actualTypeArgs, ClassType currClass, boolean fromClient) throws SemanticException {
        return this.findAcceptableMethods(container, name, argTypes, actualTypeArgs, currClass, null, fromClient);
    }

    protected List<? extends MethodInstance> findAcceptableMethods(ReferenceType container, String name, List<? extends Type> argTypes, List<? extends ReferenceType> actualTypeArgs, ClassType currClass, Type expectedReturnType, boolean fromClient) throws SemanticException {
        this.assert_(container);
        this.assert_(argTypes);
        container = (ReferenceType)this.applyCaptureConversion(container, container.position());
        NoMemberException error = null;
        ArrayList<JL5MethodInstance> phase1methods = new ArrayList<JL5MethodInstance>();
        ArrayList<JL5MethodInstance> phase2methods = new ArrayList<JL5MethodInstance>();
        ArrayList<JL5MethodInstance> phase3methods = new ArrayList<JL5MethodInstance>();
        ArrayList<JL5MethodInstance> inaccessible = new ArrayList<JL5MethodInstance>();
        HashSet<MethodInstance> phase1overridden = new HashSet<MethodInstance>();
        HashSet<MethodInstance> phase2overridden = new HashSet<MethodInstance>();
        HashSet<MethodInstance> phase3overridden = new HashSet<MethodInstance>();
        HashSet<Type> visitedTypes = new HashSet<Type>();
        LinkedList<? extends ReferenceType> typeQueue = new LinkedList<ReferenceType>();
        typeQueue.addLast(container);
        while (!typeQueue.isEmpty()) {
            Type type = (Type)typeQueue.remove();
            if (visitedTypes.contains(type)) continue;
            visitedTypes.add(type);
            if (Report.should_report("types", 2)) {
                Report.report(2, "Searching type " + type + " for method " + name + "(" + JL5TypeSystem_c.listToString(argTypes) + ")");
            }
            if (!type.isReference()) {
                throw new SemanticException("Cannot call method in  non-reference type " + type + ".");
            }
            List<? extends MethodInstance> list = type.toReference().methods();
            for (JL5MethodInstance jL5MethodInstance : list) {
                if (Report.should_report("types", 3)) {
                    Report.report(3, "Trying " + jL5MethodInstance);
                }
                if (!jL5MethodInstance.name().equals(name)) continue;
                JL5MethodInstance substMi = this.methodCallValid(jL5MethodInstance, name, argTypes, actualTypeArgs, expectedReturnType);
                JL5MethodInstance origMi = jL5MethodInstance;
                if (substMi != null) {
                    JL5MethodInstance jL5MethodInstance2 = substMi;
                    if (this.isMember(jL5MethodInstance2, container.toReference()) && this.isAccessible(jL5MethodInstance2, container, currClass, fromClient)) {
                        if (Report.should_report("types", 3)) {
                            Report.report(3, "->acceptable: " + jL5MethodInstance2 + " in " + jL5MethodInstance2.container());
                        }
                        if (this.varArgsRequired(jL5MethodInstance2)) {
                            if (phase3overridden.contains(jL5MethodInstance2) || phase3overridden.contains(origMi)) continue;
                            phase3overridden.addAll(jL5MethodInstance2.implemented());
                            phase3overridden.addAll(origMi.implemented());
                            phase3methods.removeAll(jL5MethodInstance2.implemented());
                            phase3methods.removeAll(origMi.implemented());
                            phase3methods.add(jL5MethodInstance2);
                            continue;
                        }
                        if (this.boxingRequired(jL5MethodInstance2, argTypes)) {
                            if (phase2overridden.contains(jL5MethodInstance2) || phase2overridden.contains(origMi)) continue;
                            phase2overridden.addAll(jL5MethodInstance2.implemented());
                            phase2overridden.addAll(origMi.implemented());
                            phase2methods.removeAll(jL5MethodInstance2.implemented());
                            phase2methods.removeAll(origMi.implemented());
                            phase2methods.add(jL5MethodInstance2);
                            continue;
                        }
                        if (phase1overridden.contains(jL5MethodInstance2) || phase1overridden.contains(origMi)) continue;
                        phase1overridden.addAll(jL5MethodInstance2.implemented());
                        phase1overridden.addAll(origMi.implemented());
                        phase1methods.removeAll(jL5MethodInstance2.implemented());
                        phase1methods.removeAll(origMi.implemented());
                        phase1methods.add(jL5MethodInstance2);
                        continue;
                    }
                    inaccessible.add(jL5MethodInstance2);
                    if (error != null) continue;
                    error = new NoMemberException(1, "Method " + jL5MethodInstance2.signature() + " in " + container + " is inaccessible.");
                    continue;
                }
                if (error != null) continue;
                error = new NoMemberException(1, "Method " + jL5MethodInstance.signature() + " in " + container + " cannot be called with arguments " + "(" + JL5TypeSystem_c.listToString(argTypes) + ").");
            }
            if (type instanceof JL5ClassType) {
                for (Type type2 : ((JL5ClassType)type).superclasses()) {
                    if (type2 == null || !type2.isReference()) continue;
                    typeQueue.addLast(type2.toReference());
                }
            } else {
                Type superT = type.toReference().superType();
                if (superT != null && superT.isReference()) {
                    typeQueue.addLast(superT.toReference());
                }
            }
            typeQueue.addAll(type.toReference().interfaces());
        }
        if (error == null) {
            error = new NoMemberException(1, "No valid method call found for " + name + "(" + JL5TypeSystem_c.listToString(argTypes) + ")" + " in " + container + ".");
        }
        for (MethodInstance methodInstance : inaccessible) {
            phase1methods.removeAll(methodInstance.overrides());
            phase2methods.removeAll(methodInstance.overrides());
            phase3methods.removeAll(methodInstance.overrides());
        }
        if (!phase1methods.isEmpty()) {
            return phase1methods;
        }
        if (!phase2methods.isEmpty()) {
            return phase2methods;
        }
        if (!phase3methods.isEmpty()) {
            return phase3methods;
        }
        throw error;
    }

    @Override
    public boolean methodCallValid(MethodInstance mi, String name, List<? extends Type> argTypes) {
        return this.methodCallValid((JL5MethodInstance)mi, name, argTypes, null, null) != null;
    }

    @Override
    public JL5MethodInstance methodCallValid(JL5MethodInstance mi, String name, List<? extends Type> argTypes, List<? extends ReferenceType> actualTypeArgs, Type expectedReturnType) {
        if (actualTypeArgs == null) {
            actualTypeArgs = Collections.emptyList();
        }
        if (!(argTypes.size() == mi.formalTypes().size() || mi.isVariableArity() && argTypes.size() >= mi.formalTypes().size() - 1)) {
            return null;
        }
        JL5Subst subst = null;
        if (!mi.typeParams().isEmpty() && actualTypeArgs.isEmpty()) {
            subst = this.inferTypeArgs(mi, argTypes, expectedReturnType);
        } else if (!mi.typeParams().isEmpty() && !actualTypeArgs.isEmpty()) {
            HashMap<TypeVariable, ReferenceType> m = new HashMap<TypeVariable, ReferenceType>();
            Iterator<ReferenceType> iter = actualTypeArgs.iterator();
            for (TypeVariable tv : mi.typeParams()) {
                m.put(tv, iter.next());
            }
            subst = (JL5Subst)this.subst(m);
        }
        JL5MethodInstance mj = mi;
        if (!mi.typeParams().isEmpty() && subst != null) {
            for (TypeVariable tv : subst.substitutions().keySet()) {
                Type substUpperBound;
                Type a = (Type)subst.substitutions().get(tv);
                if (this.isSubtype(a, substUpperBound = subst.substType(tv.upperBound()))) continue;
                return null;
            }
            mj = subst.substMethod(mi);
        }
        if (super.methodCallValid(mj, name, argTypes)) {
            return mj;
        }
        return null;
    }

    @Override
    public boolean callValid(ProcedureInstance mi, List<? extends Type> argTypes) {
        return this.callValid((JL5ProcedureInstance)mi, argTypes, null) != null;
    }

    @Override
    public JL5ProcedureInstance callValid(JL5ProcedureInstance mi, List<? extends Type> argTypes, List<? extends ReferenceType> actualTypeArgs) {
        if (actualTypeArgs == null) {
            actualTypeArgs = Collections.emptyList();
        }
        JL5Subst subst = null;
        if (!mi.typeParams().isEmpty() && actualTypeArgs.isEmpty()) {
            subst = this.inferTypeArgs(mi, argTypes, null);
        } else if (!mi.typeParams().isEmpty() && !actualTypeArgs.isEmpty()) {
            if (mi.typeParams().size() != actualTypeArgs.size()) {
                return null;
            }
            HashMap<TypeVariable, ReferenceType> m = new HashMap<TypeVariable, ReferenceType>();
            Iterator<ReferenceType> iter = actualTypeArgs.iterator();
            for (TypeVariable tv : mi.typeParams()) {
                m.put(tv, iter.next());
            }
            subst = (JL5Subst)this.subst(m);
        }
        JL5ProcedureInstance mj = mi;
        if (!mi.typeParams().isEmpty() && subst != null) {
            for (TypeVariable tv : subst.substitutions().keySet()) {
                Type a = (Type)subst.substitutions().get(tv);
                if (this.isSubtype(a, tv.upperBound())) continue;
                return null;
            }
            mj = subst.substProcedure(mi);
        }
        if (super.callValid(mj, argTypes)) {
            return mj;
        }
        return null;
    }

    protected JL5Subst inferTypeArgs(JL5ProcedureInstance pi, List<? extends Type> argTypes, Type expectedReturnType) {
        InferenceSolver s = this.inferenceSolver(pi, argTypes);
        Map<TypeVariable, ReferenceType> m = s.solve(expectedReturnType);
        if (m == null) {
            return null;
        }
        JL5Subst subst = (JL5Subst)this.subst(m);
        return subst;
    }

    protected InferenceSolver inferenceSolver(JL5ProcedureInstance pi, List<? extends Type> argTypes) {
        return new InferenceSolver_c(pi, argTypes, this);
    }

    @Override
    public ClassType instantiate(Position pos, PClass<TypeVariable, ReferenceType> base, List<? extends ReferenceType> actuals) throws SemanticException {
        JL5ParsedClassType clazz = (JL5ParsedClassType)base.clazz();
        return this.instantiate(pos, clazz, actuals);
    }

    @Override
    public ClassType instantiate(Position pos, JL5ParsedClassType clazz, ReferenceType ... actuals) throws SemanticException {
        return this.instantiate(pos, clazz, Arrays.asList(actuals));
    }

    @Override
    public ClassType instantiate(Position pos, JL5ParsedClassType clazz, List<? extends ReferenceType> actuals) throws SemanticException {
        if (clazz.typeVariables().isEmpty() || actuals == null || actuals.isEmpty()) {
            return clazz;
        }
        boolean allNull = true;
        for (ReferenceType referenceType : actuals) {
            if (referenceType == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            return clazz;
        }
        return super.instantiate(pos, clazz.pclass(), actuals);
    }

    @Override
    public JL5ProcedureInstance instantiate(Position pos, JL5ProcedureInstance mi, List<? extends ReferenceType> actuals) {
        LinkedHashMap<TypeVariable, ReferenceType> m = new LinkedHashMap<TypeVariable, ReferenceType>();
        Iterator<? extends ReferenceType> iter = actuals.iterator();
        for (TypeVariable tv : mi.typeParams()) {
            m.put(tv, iter.next());
        }
        JL5Subst subst = (JL5Subst)this.subst(m);
        JL5ProcedureInstance ret = subst.substProcedure(mi);
        ret.setContainer(mi.container());
        return ret;
    }

    protected boolean boxingRequired(JL5ProcedureInstance pi, List<? extends Type> paramTypes) {
        int numFormals = pi.formalTypes().size();
        for (int i = 0; i < numFormals - 1; ++i) {
            Type formal = pi.formalTypes().get(i);
            Type actual = paramTypes.get(i);
            if (!(formal.isPrimitive() ^ actual.isPrimitive())) continue;
            return true;
        }
        if (pi.isVariableArity()) {
            Type lastParams = ((JL5ArrayType)pi.formalTypes().get(numFormals - 1)).base();
            for (int i = numFormals - 1; i < paramTypes.size() - 1; ++i) {
                if (!(lastParams.isPrimitive() ^ paramTypes.get(i).isPrimitive())) continue;
                return true;
            }
        } else if (numFormals > 0) {
            Type formal = pi.formalTypes().get(numFormals - 1);
            Type actual = paramTypes.get(numFormals - 1);
            if (formal.isPrimitive() ^ actual.isPrimitive()) {
                return true;
            }
        }
        return false;
    }

    protected boolean varArgsRequired(JL5ProcedureInstance pi) {
        return pi.isVariableArity();
    }

    @Override
    public List<ReferenceType> allAncestorsOf(ReferenceType rt) {
        LinkedHashSet<ReferenceType> ancestors = new LinkedHashSet<ReferenceType>();
        ancestors.add(rt);
        Set<? extends Type> superClasses = rt.isClass() ? ((JL5ClassType)rt).superclasses() : Collections.singleton(rt.superType());
        for (Type type : superClasses) {
            if (!type.isReference()) continue;
            ancestors.add((ReferenceType)type);
            ancestors.addAll(this.allAncestorsOf((ReferenceType)type));
        }
        for (ReferenceType referenceType : rt.interfaces()) {
            ancestors.add(referenceType);
            ancestors.addAll(this.allAncestorsOf(referenceType));
        }
        return new ArrayList<ReferenceType>(ancestors);
    }

    public static String listToString(List<?> l) {
        StringBuffer sb = new StringBuffer();
        Iterator<?> i = l.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            sb.append(o.toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    protected Subst<TypeVariable, ReferenceType> substImpl(Map<TypeVariable, ? extends ReferenceType> substMap) {
        return new JL5Subst_c(this, substMap);
    }

    @Override
    public boolean hasSameSignature(JL5ProcedureInstance mi, JL5ProcedureInstance mj) {
        return this.hasSameSignature(mi, mj, false);
    }

    protected boolean hasSameSignature(JL5ProcedureInstance mi, JL5ProcedureInstance mj, boolean eraseMj) {
        if (mi instanceof JL5MethodInstance && mj instanceof JL5MethodInstance && !((JL5MethodInstance)mi).name().equals(((JL5MethodInstance)mj).name())) {
            return false;
        }
        if (mi.formalTypes().size() != mj.formalTypes().size()) {
            return false;
        }
        if (eraseMj && !mi.typeParams().isEmpty()) {
            return false;
        }
        if (!eraseMj && mi.typeParams().size() != mj.typeParams().size()) {
            return false;
        }
        if (!eraseMj && !mi.typeParams().isEmpty()) {
            LinkedHashMap<TypeVariable, TypeVariable> substm = new LinkedHashMap<TypeVariable, TypeVariable>();
            for (int i = 0; i < mi.typeParams().size(); ++i) {
                substm.put(mj.typeParams().get(i), mi.typeParams().get(i));
            }
            Subst subst = this.subst(substm);
            Iterator<TypeVariable> typesi = mi.typeParams().iterator();
            Iterator<TypeVariable> typesj = mj.typeParams().iterator();
            while (typesi.hasNext()) {
                TypeVariable ti = typesi.next();
                TypeVariable tj = typesj.next();
                if (ti.upperBound().equals(subst.substType(tj.upperBound()))) continue;
                return false;
            }
            mj = mj instanceof JL5MethodInstance ? (JL5ProcedureInstance)subst.substMethod((JL5MethodInstance)mj) : (JL5ProcedureInstance)subst.substConstructor((JL5ConstructorInstance)mj);
        }
        Iterator<? extends Type> typesi = mi.formalTypes().iterator();
        Iterator<? extends Type> typesj = mj.formalTypes().iterator();
        while (typesi.hasNext()) {
            Type ti = typesi.next();
            Type tj = typesj.next();
            if (eraseMj) {
                tj = this.erasureType(tj);
            }
            if (ti.equals(tj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubSignature(JL5ProcedureInstance m1, JL5ProcedureInstance m2) {
        if (this.hasSameSignature(m1, m2)) {
            return true;
        }
        return this.hasSameSignature(m1, m2, true);
    }

    @Override
    public boolean areOverrideEquivalent(JL5ProcedureInstance mi, JL5ProcedureInstance mj) {
        return this.isSubSignature(mi, mj) || this.isSubSignature(mj, mi);
    }

    @Override
    public boolean isUncheckedConversion(Type fromType, Type toType) {
        if (fromType instanceof JL5ClassType && toType instanceof JL5ClassType) {
            JL5ClassType from = (JL5ClassType)fromType;
            JL5ClassType to = (JL5ClassType)toType;
            if (from.isRawClass() && !to.isRawClass() && to instanceof JL5SubstClassType) {
                JL5SubstClassType tosct = (JL5SubstClassType)to;
                return from.equals(tosct.base());
            }
        }
        return false;
    }

    @Override
    public boolean areReturnTypeSubstitutable(Type ri, Type rj) {
        if (ri.isPrimitive()) {
            return ri.equals(rj);
        }
        if (ri.isReference()) {
            return ri.isSubtype(rj) || this.isUncheckedConversion(ri, rj) || ri.isSubtype(this.erasureType(rj));
        }
        if (ri.isVoid()) {
            return rj.isVoid();
        }
        throw new InternalCompilerError("Unexpected return type: " + ri);
    }

    @Override
    public MethodInstance findImplementingMethod(ClassType ct, MethodInstance mi) {
        ClassType superClass;
        List<? extends MethodInstance> declared = ct.methodsNamed(mi.name());
        for (MethodInstance methodInstance : declared) {
            if (!this.areOverrideEquivalent((JL5MethodInstance)mi, (JL5MethodInstance)methodInstance)) continue;
            if (methodInstance.flags().isAbstract()) {
                return null;
            }
            if (!mi.flags().isPublic() && !mi.flags().isProtected() && !this.isAccessible((MemberInstance)mi, ct)) continue;
            return methodInstance;
        }
        ClassType classType = superClass = ct.superType() == null ? null : ct.superType().toClass();
        if (superClass == null) {
            return null;
        }
        MethodInstance methodInstance = this.findImplementingMethod(superClass, mi);
        return methodInstance;
    }

    @Override
    public Type erasureType(Type t) {
        return this.erasureType(t, new HashSet<TypeVariable>());
    }

    protected Type erasureType(Type t, Set<TypeVariable> visitedTypeVariables) {
        if (t.isArray()) {
            ArrayType at = t.toArray();
            return at.base(this.erasureType(at.base(), visitedTypeVariables));
        }
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            if (!visitedTypeVariables.add(tv)) {
                return this.Object();
            }
            ReferenceType upperBound = tv.upperBound();
            if (upperBound instanceof IntersectionType) {
                IntersectionType it = (IntersectionType)upperBound;
                return this.erasureType(it.bounds().get(0), visitedTypeVariables);
            }
            return this.erasureType(upperBound, visitedTypeVariables);
        }
        if (t instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)t;
            ClassType ct = null;
            ClassType iface = null;
            boolean subtypes = true;
            Iterator<ReferenceType> iterator = it.bounds().iterator();
            while (iterator.hasNext()) {
                ReferenceType rt;
                ReferenceType origRt = rt = iterator.next();
                if (rt instanceof TypeVariable) {
                    rt = (ReferenceType)this.erasureType(rt, visitedTypeVariables);
                }
                if (!rt.isClass()) {
                    throw new InternalCompilerError("Don't know how to deal with erasure of intersection type " + it + ", specifcally component " + origRt, t.position());
                }
                ClassType next = (ClassType)rt;
                if (this.equals(this.Object(), next)) continue;
                if (!next.toClass().flags().isInterface()) {
                    if (ct != null && !next.descendsFrom(ct)) continue;
                    ct = next;
                    continue;
                }
                if (!subtypes) continue;
                if (iface == null || next.descendsFrom(iface)) {
                    iface = next;
                    continue;
                }
                if (iface.descendsFrom(next)) continue;
                subtypes = false;
            }
            if (ct != null) {
                return this.erasureType(ct, visitedTypeVariables);
            }
            if (subtypes && iface != null) {
                return this.erasureType(iface, visitedTypeVariables);
            }
            return this.Object();
        }
        if (t instanceof WildCardType) {
            WildCardType tv = (WildCardType)t;
            if (tv.upperBound() == null) {
                return this.Object();
            }
            return this.erasureType(tv.upperBound(), visitedTypeVariables);
        }
        if (t instanceof JL5SubstType) {
            JL5SubstType jst = (JL5SubstType)t;
            return this.erasureType(jst.base(), visitedTypeVariables);
        }
        if (t instanceof JL5ParsedClassType) {
            return this.toRawType(t);
        }
        return t;
    }

    @Override
    public JL5Subst erasureSubst(JL5ProcedureInstance pi) {
        List<TypeVariable> typeParams = pi.typeParams();
        LinkedHashMap<TypeVariable, ReferenceType> m = new LinkedHashMap<TypeVariable, ReferenceType>();
        for (TypeVariable tv : typeParams) {
            m.put(tv, tv.erasureType());
        }
        if (m.isEmpty()) {
            return null;
        }
        return new JL5Subst_c(this, (Map<TypeVariable, ? extends ReferenceType>)m);
    }

    @Override
    public JL5Subst erasureSubst(JL5ParsedClassType base) {
        LinkedHashMap<TypeVariable, ReferenceType> m = new LinkedHashMap<TypeVariable, ReferenceType>();
        for (JL5ParsedClassType t = base; t != null; t = (JL5ParsedClassType)t.outer()) {
            for (TypeVariable tv : t.typeVariables()) {
                m.put(tv, tv.erasureType());
            }
            if (!(t.outer() instanceof JL5ParsedClassType)) break;
        }
        if (m.isEmpty()) {
            return null;
        }
        return new JL5RawSubst_c(this, m, base);
    }

    @Override
    public boolean isContained(Type fromType, Type toType) {
        if (toType instanceof WildCardType) {
            WildCardType wTo = (WildCardType)toType;
            if (fromType instanceof WildCardType) {
                WildCardType wFrom = (WildCardType)fromType;
                if (wFrom.isExtendsConstraint() && wTo.isExtendsConstraint() && this.isSubtype(wFrom.upperBound(), wTo.upperBound())) {
                    return true;
                }
                if (wFrom.isSuperConstraint() && wTo.isSuperConstraint() && this.isSubtype(wTo.lowerBound(), wFrom.lowerBound())) {
                    return true;
                }
            }
            return wTo.isSuperConstraint() ? this.isImplicitCastValid(wTo.lowerBound(), fromType) : wTo.isExtendsConstraint() && this.isImplicitCastValid(fromType, wTo.upperBound());
        }
        return this.typeEquals(fromType, toType);
    }

    @Override
    public boolean descendsFrom(Type child, Type ancestor) {
        WildCardType w;
        TypeVariable tv;
        boolean b = super.descendsFrom(child, ancestor);
        if (b) {
            return true;
        }
        if (ancestor instanceof TypeVariable && (tv = (TypeVariable)ancestor).hasLowerBound()) {
            return this.isSubtype(child, tv.lowerBound());
        }
        if (ancestor instanceof WildCardType && (w = (WildCardType)ancestor).hasLowerBound()) {
            return this.isSubtype(child, w.lowerBound());
        }
        if (ancestor instanceof LubType) {
            LubType lub = (LubType)ancestor;
            for (ReferenceType rt : lub.lubElements()) {
                if (!this.descendsFrom(child, rt)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSubtype(Type t1, Type t2) {
        TypeVariable tv;
        WildCardType wct;
        if (super.isSubtype(t1, t2)) {
            return true;
        }
        if (t2 instanceof WildCardType && (wct = (WildCardType)t2).hasLowerBound() && this.isSubtype(t1, wct.lowerBound())) {
            return true;
        }
        if (t2 instanceof TypeVariable && (tv = (TypeVariable)t2).hasLowerBound() && this.isSubtype(t1, tv.lowerBound())) {
            return true;
        }
        if (t2 instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)t2;
            for (Type type : it.bounds()) {
                if (!this.isSubtype(t1, type)) continue;
                return true;
            }
        }
        if (t2 instanceof LubType) {
            LubType lub = (LubType)t2;
            for (ReferenceType referenceType : lub.lubElements()) {
                if (!this.isSubtype(t1, referenceType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isImplicitCastValid(Type fromType, Type toType) {
        JL5SubstClassType toSubstCT;
        LinkedList<Type> chain = this.isImplicitCastValidChain(fromType, toType);
        if (chain == null && toType instanceof JL5SubstClassType && (chain = this.isImplicitCastValidChain(fromType, this.rawClass((toSubstCT = (JL5SubstClassType)toType).base(), toSubstCT.base().position()))) != null) {
            chain.addLast(toType);
        }
        if (chain == null) {
            return false;
        }
        for (int i = 0; i < chain.size(); ++i) {
            Type t = chain.get(i);
            if (!(t instanceof JL5SubstClassType)) continue;
            for (int j = i + 1; j < chain.size(); ++j) {
                Type u = chain.get(j);
                if (!(u instanceof JL5SubstClassType) || t.isSubtype(u)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public LinkedList<Type> isImplicitCastValidChain(Type fromType, Type toType) {
        this.assert_(fromType);
        this.assert_(toType);
        if (fromType == null || toType == null) {
            throw new IllegalArgumentException("isImplicitCastValidChain: " + fromType + " " + toType);
        }
        LinkedList<Type> chain = null;
        if (fromType instanceof JL5ClassType) {
            chain = ((JL5ClassType)fromType).isImplicitCastValidChainImpl(toType);
        } else if (fromType.isImplicitCastValidImpl(toType)) {
            chain = new LinkedList();
            chain.add(fromType);
            chain.add(toType);
        }
        return chain;
    }

    @Override
    public boolean numericConversionValid(Type type, Object value) {
        JL5Options opts = (JL5Options)this.extInfo.getOptions();
        if (opts.morePermissiveCasts && this.isPrimitiveWrapper(type)) {
            return super.numericConversionValid((Type)this.primitiveTypeOfWrapper(type), value);
        }
        return super.numericConversionValid(type, value);
    }

    @Override
    public boolean isCastValid(Type fromType, Type toType) {
        if (super.isCastValid(fromType, toType)) {
            return true;
        }
        JL5Options opts = (JL5Options)this.extensionInfo().getOptions();
        if (opts.morePermissiveCasts && this.isPrimitiveWrapper(fromType) && toType.isPrimitive() && this.isImplicitCastValid(this.unboxingConversion(fromType), toType)) {
            return true;
        }
        if (fromType.isClass()) {
            if (!fromType.toClass().flags().isInterface()) {
                return this.isCastValidFromClass(fromType.toClass(), toType);
            }
            return this.isCastValidFromInterface(fromType.toClass(), toType);
        }
        if (fromType instanceof TypeVariable) {
            return this.isCastValid(((TypeVariable)fromType).upperBound(), toType);
        }
        if (fromType.isArray()) {
            return this.isCastValidFromArray(fromType.toArray(), toType);
        }
        return false;
    }

    protected boolean isCastValidFromClass(ClassType fromType, Type toType) {
        if (toType instanceof TypeVariable) {
            return this.isCastValid(fromType, ((TypeVariable)toType).upperBound());
        }
        if (toType.isClass() && !toType.toClass().flags().isInterface()) {
            Type erasedFrom = this.erasureType(fromType);
            Type erasedTo = this.erasureType(toType);
            return !(erasedFrom == fromType && erasedTo == toType || !erasedFrom.isSubtype(erasedTo) && !erasedTo.isSubtype(erasedFrom));
        }
        return false;
    }

    protected boolean isCastValidFromInterface(ClassType fromType, Type toType) {
        if (toType.isClass() && toType.toClass().flags().isFinal()) {
            if (fromType instanceof RawClass || fromType instanceof JL5SubstClassType) {
                JL5ParsedClassType baseClass = fromType instanceof RawClass ? ((RawClass)fromType).base() : ((JL5SubstClassType)fromType).base();
                JL5SubstClassType x = this.findGenericSupertype(baseClass, toType.toReference());
                if (x == null) {
                    return false;
                }
                if (fromType instanceof JL5SubstClassType && JL5TypeSystem_c.areProvablyDistinct((JL5SubstClassType)fromType, x)) {
                    return false;
                }
            } else if (!this.isSubtype(toType, fromType)) {
                return false;
            }
            return true;
        }
        List<ReferenceType> allY = this.allAncestorsOf(fromType.toReference());
        List<ReferenceType> allX = this.allAncestorsOf(toType.toReference());
        for (ReferenceType y : allY) {
            for (ReferenceType x : allX) {
                if (!(x instanceof JL5SubstClassType) || !(y instanceof JL5SubstClassType) || !JL5TypeSystem_c.areProvablyDistinct((JL5SubstClassType)x, (JL5SubstClassType)y) || !this.erasureType(x).equals(this.erasureType(y))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isCastValidFromArray(ArrayType arrayType, Type toType) {
        if (toType.equals(this.Object()) || toType.equals(this.Serializable()) || toType.equals(this.Cloneable())) {
            return true;
        }
        if (toType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)toType;
            ReferenceType upperBound = tv.upperBound();
            if (upperBound.equals(this.Object()) || upperBound.equals(this.Serializable()) || upperBound.equals(this.Cloneable())) {
                return true;
            }
            if (upperBound.isArray()) {
                return this.isCastValidFromArray(arrayType, upperBound);
            }
            if (upperBound instanceof TypeVariable) {
                HashSet<TypeVariable> visited = new HashSet<TypeVariable>();
                visited.add(tv);
                while (upperBound instanceof TypeVariable && visited.add((TypeVariable)upperBound)) {
                    upperBound = ((TypeVariable)upperBound).upperBound();
                }
                if (!(upperBound instanceof TypeVariable)) {
                    return this.isCastValidFromArray(arrayType, upperBound);
                }
            }
            return false;
        }
        if (toType.isArray()) {
            ArrayType toArrayType = toType.toArray();
            if (arrayType.base().isPrimitive() && arrayType.base().equals(toArrayType.base())) {
                return true;
            }
            if (arrayType.base().isReference() && toArrayType.base().isReference()) {
                return this.isCastValid(arrayType.base(), toArrayType.base());
            }
        }
        return false;
    }

    private static boolean areProvablyDistinct(JL5SubstClassType s, JL5SubstClassType t) {
        JL5SubstClassType x = s;
        JL5SubstClassType y = t;
        if (!x.base().equals(y.base())) {
            return true;
        }
        List xActuals = x.actuals();
        List yActuals = y.actuals();
        if (xActuals.size() != yActuals.size()) {
            return true;
        }
        for (int i = 0; i < xActuals.size(); ++i) {
            if (!JL5TypeSystem_c.areTypArgsProvablyDistinct((ReferenceType)xActuals.get(i), (ReferenceType)xActuals.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean areTypArgsProvablyDistinct(ReferenceType s, ReferenceType t) {
        return !(s instanceof TypeVariable) && !(t instanceof TypeVariable) && !(s instanceof WildCardType) && !(t instanceof WildCardType) && !s.equals(t);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected List<ReferenceType> abstractSuperInterfaces(ReferenceType rt) {
        JL5ClassType c;
        LinkedList<ReferenceType> superInterfaces = new LinkedList<ReferenceType>();
        superInterfaces.add(rt);
        List<? extends ReferenceType> interfaces = rt.interfaces();
        for (JL5ClassType jL5ClassType : interfaces) {
            void var5_5;
            if (jL5ClassType.isRawClass()) {
                JL5ClassType jL5ClassType2 = (JL5ClassType)this.erasureType(jL5ClassType);
            }
            superInterfaces.addAll(this.abstractSuperInterfaces((ReferenceType)var5_5));
        }
        if (rt.superType() != null && (c = (JL5ClassType)rt.superType().toClass()).flags().isAbstract()) {
            superInterfaces.addAll(this.abstractSuperInterfaces(c));
        }
        return superInterfaces;
    }

    @Override
    public MethodInstance findMethod(ReferenceType container, String name, List<? extends Type> argTypes, ClassType currClass, boolean fromClient) throws SemanticException {
        return this.findMethod(container, name, argTypes, null, currClass, null, fromClient);
    }

    @Override
    public MethodInstance findMethod(ReferenceType container, String name, List<? extends Type> argTypes, List<? extends ReferenceType> typeArgs, ClassType currClass, Type expectedReturnType, boolean fromClient) throws SemanticException {
        this.assert_(container);
        this.assert_(argTypes);
        List<? extends MethodInstance> acceptable = this.findAcceptableMethods(container, name, argTypes, typeArgs, currClass, expectedReturnType, fromClient);
        if (acceptable.size() == 0) {
            throw new NoMemberException(1, "No valid method call found for " + name + "(" + JL5TypeSystem_c.listToString(argTypes) + ")" + " in " + container + ".");
        }
        Collection<? extends MethodInstance> maximal = this.findMostSpecificProcedures(acceptable);
        if (maximal.size() > 1) {
            StringBuffer sb = new StringBuffer();
            Iterator<? extends MethodInstance> i = maximal.iterator();
            while (i.hasNext()) {
                MethodInstance ma = i.next();
                sb.append(ma.returnType());
                sb.append(" ");
                sb.append(ma.container());
                sb.append(".");
                sb.append(ma.signature());
                if (!i.hasNext()) continue;
                if (maximal.size() == 2) {
                    sb.append(" and ");
                    continue;
                }
                sb.append(", ");
            }
            throw new SemanticException("Reference to " + name + " is ambiguous, multiple methods match: " + sb.toString());
        }
        MethodInstance mi = maximal.iterator().next();
        return mi;
    }

    @Override
    public ConstructorInstance findConstructor(ClassType container, List<? extends Type> argTypes, ClassType currClass, boolean fromClient) throws SemanticException {
        return this.findConstructor(container, argTypes, Collections.emptyList(), currClass, fromClient);
    }

    @Override
    public ConstructorInstance findConstructor(ClassType container, List<? extends Type> argTypes, List<? extends ReferenceType> typeArgs, ClassType currClass, boolean fromClient) throws SemanticException {
        this.assert_(container);
        this.assert_(argTypes);
        List<ConstructorInstance> acceptable = this.findAcceptableConstructors(container, argTypes, typeArgs, currClass, fromClient);
        if (acceptable.size() == 0) {
            throw new NoMemberException(2, "No valid constructor found for " + container + "(" + JL5TypeSystem_c.listToString(argTypes) + ").");
        }
        Collection<ConstructorInstance> maximal = this.findMostSpecificProcedures(acceptable);
        if (maximal.size() > 1) {
            throw new NoMemberException(2, "Reference to " + container + " is ambiguous, multiple " + "constructors match: " + maximal);
        }
        ConstructorInstance ci = maximal.iterator().next();
        return ci;
    }

    @Override
    protected List<? extends ConstructorInstance> findAcceptableConstructors(ClassType container, List<? extends Type> argTypes, ClassType currClass, boolean fromClient) throws SemanticException {
        return this.findAcceptableConstructors(container, argTypes, Collections.emptyList(), currClass, fromClient);
    }

    protected List<ConstructorInstance> findAcceptableConstructors(ClassType container, List<? extends Type> argTypes, List<? extends ReferenceType> actualTypeArgs, ClassType currClass, boolean fromClient) throws SemanticException {
        this.assert_(container);
        this.assert_(argTypes);
        NoMemberException error = null;
        ArrayList<ConstructorInstance> phase1methods = new ArrayList<ConstructorInstance>();
        ArrayList<ConstructorInstance> phase2methods = new ArrayList<ConstructorInstance>();
        ArrayList<ConstructorInstance> phase3methods = new ArrayList<ConstructorInstance>();
        if (Report.should_report("types", 2)) {
            Report.report(2, "Searching type " + container + " for constructor " + container + "(" + JL5TypeSystem_c.listToString(argTypes) + ")");
        }
        List<? extends ConstructorInstance> constructors = container.constructors();
        for (JL5ConstructorInstance jL5ConstructorInstance : constructors) {
            JL5ConstructorInstance substCi;
            if (Report.should_report("types", 3)) {
                Report.report(3, "Trying " + jL5ConstructorInstance);
            }
            if ((substCi = (JL5ConstructorInstance)this.callValid(jL5ConstructorInstance, argTypes, actualTypeArgs)) != null) {
                JL5ConstructorInstance jL5ConstructorInstance2 = substCi;
                if (this.isAccessible((MemberInstance)jL5ConstructorInstance2, currClass)) {
                    if (Report.should_report("types", 3)) {
                        Report.report(3, "->acceptable: " + jL5ConstructorInstance2);
                    }
                    if (this.varArgsRequired(jL5ConstructorInstance2)) {
                        phase3methods.add(jL5ConstructorInstance2);
                        continue;
                    }
                    if (this.boxingRequired(jL5ConstructorInstance2, argTypes)) {
                        phase2methods.add(jL5ConstructorInstance2);
                        continue;
                    }
                    phase1methods.add(jL5ConstructorInstance2);
                    continue;
                }
                if (error != null) continue;
                error = new NoMemberException(2, "Constructor " + jL5ConstructorInstance2.signature() + " is inaccessible.");
                continue;
            }
            if (error != null) continue;
            error = new NoMemberException(2, "Constructor " + jL5ConstructorInstance.signature() + " cannot be invoked with " + (!actualTypeArgs.isEmpty() ? "type arguments <" + JL5TypeSystem_c.listToString(actualTypeArgs) + "> and " : "") + "arguments " + "(" + JL5TypeSystem_c.listToString(argTypes) + ").");
        }
        if (!phase1methods.isEmpty()) {
            return phase1methods;
        }
        if (!phase2methods.isEmpty()) {
            return phase2methods;
        }
        if (!phase3methods.isEmpty()) {
            return phase3methods;
        }
        if (error == null) {
            error = new NoMemberException(2, "No valid constructor found for " + container + "(" + JL5TypeSystem_c.listToString(argTypes) + ").");
        }
        throw error;
    }

    @Override
    public boolean isMember(MemberInstance mi, ReferenceType type) {
        if (super.isMember(mi, type)) {
            return true;
        }
        if (mi.flags().isStatic()) {
            if (type instanceof JL5SubstClassType) {
                type = ((JL5SubstClassType)type).base();
            } else if (type instanceof RawClass) {
                type = ((RawClass)type).base();
            }
            return this.typeEquals(mi.container(), type);
        }
        return false;
    }

    @Override
    public boolean isAccessible(MemberInstance mi, ReferenceType container, ReferenceType contextType, boolean fromClient) {
        this.assert_(mi);
        Flags flags = mi.flags();
        if (container instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)container;
            return !flags.isPrivate() && this.isAccessible(mi, tv.upperBound(), contextType, fromClient);
        }
        if (super.isAccessible(mi, container, contextType, fromClient)) {
            return true;
        }
        if (flags.isProtected()) {
            Type targetClass = this.erasureType(mi.container().toClass());
            ReferenceType rt = contextType;
            if (contextType.isClass()) {
                ClassType ct = contextType.toClass();
                while (!this.isSubtype(ct, targetClass) && !ct.isTopLevel()) {
                    ct = ct.outer();
                }
                rt = ct;
            }
            if (this.isSubtype(rt, targetClass)) {
                if (mi instanceof ClassType || flags.isStatic()) {
                    return true;
                }
                return !fromClient || this.isSubtype(container, rt);
            }
        }
        return false;
    }

    @Override
    public boolean isEnclosed(ClassType inner, ClassType outer) {
        if (inner instanceof JL5ClassType) {
            inner = (ClassType)inner.declaration();
        }
        if (outer instanceof JL5ClassType) {
            outer = (ClassType)outer.declaration();
        }
        return inner.isEnclosedImpl(outer);
    }

    @Override
    public boolean hasEnclosingInstance(ClassType inner, ClassType encl) {
        if (inner instanceof JL5ClassType) {
            inner = (ClassType)inner.declaration();
        }
        if (encl instanceof JL5ClassType) {
            encl = (ClassType)encl.declaration();
        }
        return inner.hasEnclosingInstanceImpl(encl);
    }

    @Override
    public WildCardType wildCardType(Position position) {
        return this.wildCardType(position, null, null);
    }

    @Override
    public WildCardType wildCardType(Position position, ReferenceType upperBound, ReferenceType lowerBound) {
        if (upperBound == null) {
            upperBound = this.Object();
        }
        return new WildCardType_c(this, position, upperBound, lowerBound);
    }

    public CaptureConvertedWildCardType captureConvertedWildCardType(Position pos) {
        return new CaptureConvertedWildCardType_c(this, pos);
    }

    @Override
    public Type applyCaptureConversion(Type t, Position pos) throws SemanticException {
        if (!(t instanceof JL5SubstClassType_c)) {
            return t;
        }
        JL5SubstClassType_c ct = (JL5SubstClassType_c)t;
        JL5ParsedClassType g = ct.base();
        LinkedHashMap<TypeVariable, ReferenceType> substmap = new LinkedHashMap<TypeVariable, ReferenceType>();
        for (JL5ParsedClassType cur = g; cur != null; cur = (JL5ParsedClassType)cur.outer()) {
            for (TypeVariable a : cur.typeVariables()) {
                ReferenceType ti;
                ReferenceType si = ti = (ReferenceType)ct.subst().substType(a);
                if (ti instanceof WildCardType) {
                    CaptureConvertedWildCardType tv = this.captureConvertedWildCardType(ti.position());
                    tv.setSyntheticOrigin();
                    si = tv;
                }
                substmap.put(a, si);
            }
            if (!cur.isInnerClass()) break;
        }
        JL5Subst subst = (JL5Subst)this.subst(substmap);
        for (JL5ParsedClassType cur = g; cur != null; cur = (JL5ParsedClassType)cur.outer()) {
            for (TypeVariable a : cur.typeVariables()) {
                Type ti = ct.subst().substType(a);
                Type si = subst.substType(a);
                if (!(ti instanceof WildCardType)) continue;
                WildCardType wti = (WildCardType)ti;
                TypeVariable vsi = (TypeVariable)si;
                if (wti.isExtendsConstraint()) {
                    ReferenceType substUpperBoundOfA;
                    ReferenceType wub = wti.upperBound();
                    ReferenceType glb = this.typeEquals(wub, substUpperBoundOfA = (ReferenceType)subst.substType(a.upperBound())) ? wub : this.glb(wub, substUpperBoundOfA, false);
                    vsi.setUpperBound(glb);
                    if (!wub.isClass() || wub.toClass().flags().isInterface() || !substUpperBoundOfA.isClass() || substUpperBoundOfA.toClass().flags().isInterface() || this.isSubtype(wub, substUpperBoundOfA) || this.isSubtype(substUpperBoundOfA, wub)) continue;
                    throw new SemanticException("Cannot capture convert " + t, pos);
                }
                vsi.setUpperBound((ReferenceType)subst.substType(a.upperBound()));
                vsi.setLowerBound(wti.lowerBound());
            }
        }
        return subst.substType(g);
    }

    @Override
    public Flags legalLocalFlags() {
        return JL5Flags.setVarArgs(super.legalLocalFlags());
    }

    @Override
    public Flags legalConstructorFlags() {
        return JL5Flags.setVarArgs(super.legalConstructorFlags());
    }

    @Override
    public Flags legalMethodFlags() {
        return JL5Flags.setVarArgs(super.legalMethodFlags());
    }

    @Override
    public Flags legalAbstractMethodFlags() {
        return JL5Flags.setVarArgs(super.legalAbstractMethodFlags());
    }

    @Override
    public JL5SubstClassType findGenericSupertype(JL5ParsedClassType base, ReferenceType sub) {
        List<ReferenceType> ancestors = this.allAncestorsOf(sub);
        for (ReferenceType a : ancestors) {
            JL5SubstClassType instantiatedType;
            JL5ParsedClassType instBase;
            if (!(a instanceof JL5SubstClassType) || !this.typeEquals(base, instBase = (instantiatedType = (JL5SubstClassType)a).base())) continue;
            return instantiatedType;
        }
        return null;
    }

    @Override
    public ReferenceType intersectionType(Position pos, List<ReferenceType> types) {
        if (types.size() == 1) {
            return types.get(0);
        }
        if (types.isEmpty()) {
            return this.Object();
        }
        return new IntersectionType_c(this, pos, types);
    }

    @Override
    public boolean checkIntersectionBounds(List<? extends Type> bounds, boolean quiet) throws SemanticException {
        List<Type> concreteBounds = this.concreteBounds(bounds);
        if (concreteBounds.size() == 0) {
            if (!quiet) {
                throw new SemanticException("Invalid bounds in intersection type.");
            }
            return false;
        }
        for (int i = 0; i < concreteBounds.size(); ++i) {
            for (int j = i + 1; j < concreteBounds.size(); ++j) {
                Type t1 = concreteBounds.get(i);
                Type t2 = concreteBounds.get(j);
                if (!t1.isClass() || !t2.isClass()) {
                    return true;
                }
                if (!(t1.toClass().flags().isInterface() || t2.toClass().flags().isInterface() || this.isSubtype(t1, t2) || this.isSubtype(t2, t1))) {
                    if (!quiet) {
                        throw new SemanticException("Error in intersection type. Types " + t1 + " and " + t2 + " are not in subtype relation.");
                    }
                    return false;
                }
                if (!t1.toClass().flags().isInterface() || !t2.toClass().flags().isInterface() || !(t1 instanceof JL5SubstClassType) || !(t2 instanceof JL5SubstClassType)) continue;
                JL5SubstClassType j5t1 = (JL5SubstClassType)t1;
                JL5SubstClassType j5t2 = (JL5SubstClassType)t2;
                if (!j5t1.base().equals(j5t2.base()) || j5t1.equals(j5t2)) continue;
                if (!quiet) {
                    throw new SemanticException("Error in intersection type. Interfaces " + j5t1 + " and " + j5t2 + "are instantiations of the same generic interface but with different type arguments");
                }
                return false;
            }
        }
        return true;
    }

    public List<Type> concreteBounds(List<? extends Type> bounds) {
        LinkedHashSet<Type> included = new LinkedHashSet<Type>();
        LinkedHashSet<Type> visited = new LinkedHashSet<Type>();
        ArrayList<? extends Type> queue = new ArrayList<Type>(bounds);
        while (!queue.isEmpty()) {
            Type t = (Type)queue.remove(0);
            if (visited.contains(t)) continue;
            visited.add(t);
            if (t instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)t;
                queue.add(tv.upperBound());
                continue;
            }
            if (t instanceof IntersectionType) {
                IntersectionType it = (IntersectionType)t;
                queue.addAll(it.bounds());
                continue;
            }
            included.add(t);
        }
        return new ArrayList<Type>(included);
    }

    @Override
    public ReferenceType glb(ReferenceType t1, ReferenceType t2) {
        return this.glb(t1, t2, true);
    }

    protected ReferenceType glb(ReferenceType t1, ReferenceType t2, boolean performIntersectionCheck) {
        ArrayList<ReferenceType> l = new ArrayList<ReferenceType>();
        l.add(t1);
        l.add(t2);
        return this.glb(Position.compilerGenerated(), l, performIntersectionCheck);
    }

    @Override
    public ReferenceType glb(Position pos, List<ReferenceType> bounds) {
        return this.glb(pos, bounds, true);
    }

    protected ReferenceType glb(Position pos, List<ReferenceType> bounds, boolean performIntersectionCheck) {
        if (bounds == null || bounds.isEmpty()) {
            return this.Object();
        }
        try {
            if (performIntersectionCheck && !this.checkIntersectionBounds(bounds, true)) {
                return this.Object();
            }
            return this.intersectionType(pos, bounds);
        }
        catch (SemanticException e) {
            return this.Object();
        }
    }

    @Override
    public UnknownReferenceType unknownReferenceType(Position position) {
        return this.unknownReferenceType;
    }

    @Override
    public RawClass rawClass(JL5ParsedClassType base) {
        return this.rawClass(base, base.position());
    }

    @Override
    public RawClass rawClass(JL5ParsedClassType base, Position pos) {
        if (!this.canBeRaw(base)) {
            throw new InternalCompilerError("Can only create a raw class with a parameterized class");
        }
        return new RawClass_c(base, pos);
    }

    @Override
    public boolean canBeRaw(Type type) {
        if (type instanceof JL5ParsedClassType) {
            JL5ParsedClassType pct = (JL5ParsedClassType)type;
            if (!pct.typeVariables().isEmpty()) {
                return true;
            }
            ClassType outer = pct.outer();
            if (outer != null) {
                return this.canBeRaw(outer);
            }
        }
        return false;
    }

    @Override
    public Type toRawType(Type t) {
        if (!t.isReference()) {
            return t;
        }
        if (t instanceof RawClass) {
            return t;
        }
        if (t instanceof JL5ParsedClassType) {
            JL5ParsedClassType ct = (JL5ParsedClassType)t;
            if (!this.classAndEnclosingTypeVariables(ct).isEmpty()) {
                return this.rawClass(ct, ct.position());
            }
            return t;
        }
        if (t instanceof ArrayType) {
            ArrayType at = t.toArray();
            Type b = this.toRawType(at.base());
            return at.base(b);
        }
        return t;
    }

    @Override
    public List<TypeVariable> classAndEnclosingTypeVariables(JL5ParsedClassType ct) {
        ArrayList<TypeVariable> l = new ArrayList<TypeVariable>();
        this.classAndEnclosingTypeVariables(ct, l);
        return l;
    }

    protected void classAndEnclosingTypeVariables(JL5ParsedClassType ct, List<TypeVariable> l) {
        if (!ct.typeVariables().isEmpty()) {
            l.addAll(ct.typeVariables());
        }
        if (!ct.isTopLevel() && ct.isNested() && ct.isInnerClass() && ct.outer() instanceof JL5ParsedClassType) {
            this.classAndEnclosingTypeVariables((JL5ParsedClassType)ct.outer(), l);
        }
    }

    @Override
    public PrimitiveType promote(Type t1, Type t2) throws SemanticException {
        return super.promote(this.unboxingConversion(t1), this.unboxingConversion(t2));
    }

    @Override
    public Type boxingConversion(Type t) {
        if (t.isPrimitive()) {
            return this.wrapperClassOfPrimitive(t.toPrimitive());
        }
        return t;
    }

    @Override
    public Type unboxingConversion(Type t) {
        PrimitiveType s = this.primitiveTypeOfWrapper(t);
        if (s != null) {
            return s;
        }
        return t;
    }

    @Override
    public LubType lub(Position pos, List<ReferenceType> us) {
        return new LubType_c(this, pos, us);
    }

    @Override
    public boolean isValidAnnotationValueType(Type t) {
        if (t.isPrimitive()) {
            return true;
        }
        if (t.isClass() && (JL5Flags.isEnum(t.toClass().flags()) || JL5Flags.isAnnotation(t.toClass().flags()) || this.String().equals(t) || this.Class().equals(t))) {
            return true;
        }
        if (this.erasureType(this.Class()).equals(this.erasureType(t))) {
            return true;
        }
        if (t.isArray()) {
            return this.isValidAnnotationValueType(t.toArray().base());
        }
        return false;
    }

    @Override
    public void checkAnnotationValueConstant(Term value) throws SemanticException {
        if (value instanceof ElementValueArrayInit) {
            for (Term next : ((ElementValueArrayInit)value).elements()) {
                if (this.isAnnotationValueConstant(next)) continue;
                throw new SemanticException("Annotation attribute value must be constant", next.position());
            }
        } else {
            if (value instanceof AnnotationElem) {
                return;
            }
            if (!this.isAnnotationValueConstant(value)) {
                throw new SemanticException("Annotation attribute value must be constant: " + value, value.position());
            }
        }
    }

    protected boolean isAnnotationValueConstant(Term value) {
        if (value == null || value instanceof NullLit || value instanceof ClassLit) {
            return true;
        }
        if (value instanceof Expr) {
            J5Lang_c lang = J5Lang_c.instance;
            Expr ev = (Expr)value;
            if (lang.constantValueSet(ev, lang) && lang.isConstant(ev, lang)) {
                return true;
            }
            if (ev instanceof EnumConstant) {
                return true;
            }
            if (!lang.constantValueSet(ev, lang)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void checkDuplicateAnnotations(List<AnnotationElem> annotations) throws SemanticException {
        ArrayList<AnnotationElem> l = new ArrayList<AnnotationElem>(annotations);
        for (int i = 0; i < l.size(); ++i) {
            AnnotationElem ai = l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                AnnotationElem aj = l.get(j);
                if (ai.typeName().type() != aj.typeName().type()) continue;
                throw new SemanticException("Duplicate annotation use: " + aj.typeName(), aj.position());
            }
        }
    }

    @Override
    public AnnotationTypeElemInstance annotationElemInstance(Position pos, ClassType ct, Flags f, Type type, String name, boolean hasDefault) {
        this.assert_(ct);
        this.assert_(type);
        return new AnnotationTypeElemInstance_c(this, pos, ct, f, type, name, hasDefault);
    }

    @Override
    public AnnotationTypeElemInstance findAnnotation(ReferenceType container, String name, ClassType currClass) throws SemanticException {
        Set<AnnotationTypeElemInstance> annotations = this.findAnnotations(container, name);
        if (annotations.size() == 0) {
            throw new NoMemberException(5, "Annotation: \"" + name + "\" not found in type \"" + container + "\".");
        }
        Iterator<AnnotationTypeElemInstance> i = annotations.iterator();
        AnnotationTypeElemInstance ai = i.next();
        if (i.hasNext()) {
            AnnotationTypeElemInstance ai2 = i.next();
            throw new SemanticException("Annotation \"" + name + "\" is ambiguous; it is defined in both " + ai.container() + " and " + ai2.container() + ".");
        }
        if (currClass != null && !this.isAccessible((MemberInstance)ai, currClass) && !this.isInherited(ai, currClass)) {
            throw new SemanticException("Cannot access " + ai + ".");
        }
        return ai;
    }

    public Set<AnnotationTypeElemInstance> findAnnotations(ReferenceType container, String name) {
        this.assert_(container);
        if (container == null) {
            throw new InternalCompilerError("Cannot access annotation \"" + name + "\" within a null container type.");
        }
        AnnotationTypeElemInstance ai = ((JL5ParsedClassType)container).annotationElemNamed(name);
        if (ai != null) {
            return Collections.singleton(ai);
        }
        return new HashSet<AnnotationTypeElemInstance>();
    }

    @Override
    public void checkMethodNameClash(JL5MethodInstance mi, ClassType ct) throws SemanticException {
        this.checkMethodNameClash(mi, ct, ct);
    }

    public void checkMethodNameClash(JL5MethodInstance mi, ClassType type, ReferenceType declaringClass) throws SemanticException {
        for (MethodInstance methodInstance : declaringClass.methods()) {
            JL5MethodInstance jL5MethodInstance = (JL5MethodInstance)methodInstance;
            if (!mi.name().equals(jL5MethodInstance.name()) || !this.isAccessible((MemberInstance)jL5MethodInstance, type) || this.isSubSignature(mi, jL5MethodInstance)) continue;
            for (MethodInstance imi : this.implemented(mi)) {
                for (MethodInstance imj : this.implemented(jL5MethodInstance)) {
                    if (!this.hasSameErasure((JL5MethodInstance)imi, (JL5MethodInstance)imj)) continue;
                    throw new SemanticException("Name clash: The method " + imi.signature() + " of type " + imi.container() + " has the same erasure as " + imj.signature() + " of type " + imj.container() + " but does not override it");
                }
            }
        }
        Type superType = declaringClass.superType();
        if (superType != null) {
            this.checkMethodNameClash(mi, type, superType.toReference());
        }
        for (ReferenceType referenceType : declaringClass.interfaces()) {
            this.checkMethodNameClash(mi, type, referenceType);
        }
    }

    protected boolean hasSameErasure(JL5MethodInstance mi, JL5MethodInstance mj) {
        if (!mi.name().equals(mj.name())) {
            return false;
        }
        if (mi.formalTypes().size() != mj.formalTypes().size()) {
            return false;
        }
        mi = (JL5MethodInstance)mi.declaration();
        mj = (JL5MethodInstance)mj.declaration();
        Iterator<? extends Type> typesi = mi.formalTypes().iterator();
        Iterator<? extends Type> typesj = mj.formalTypes().iterator();
        while (typesi.hasNext()) {
            Type tj;
            Type ti = this.erasureType(typesi.next());
            if (ti.equals(tj = this.erasureType(typesj.next()))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean returnTypesConsistent(MethodInstance mi, MethodInstance mj) {
        Type mjRet;
        Type miRet = mi.returnType();
        return this.areReturnTypeSubstitutable(miRet, mjRet = mj.returnType()) || this.areReturnTypeSubstitutable(mjRet, miRet);
    }

    @Override
    public Type Class(Position pos, ReferenceType type) {
        try {
            return this.instantiate(pos, (JL5ParsedClassType)this.Class(), Collections.singletonList(type));
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Couldn't create class java.lang.Class<" + type + ">", e);
        }
    }

    @Override
    public boolean isReifiable(Type t) {
        if (t.isPrimitive() || t.isNull()) {
            return true;
        }
        if (t instanceof RawClass) {
            return this.isContainerReifiable(t.toClass());
        }
        if (t instanceof JL5ParsedClassType) {
            JL5ParsedClassType pct = (JL5ParsedClassType)t;
            return pct.typeVariables().isEmpty() && this.isContainerReifiable(t.toClass());
        }
        if (t instanceof ArrayType) {
            return this.isReifiable(((ArrayType)t).base());
        }
        if (t instanceof JL5SubstClassType) {
            JL5SubstClassType ct = (JL5SubstClassType)t;
            for (ReferenceType a : ct.actuals()) {
                WildCardType wc;
                if (a instanceof WildCardType && !(wc = (WildCardType)a).hasLowerBound() && wc.upperBound().equals(this.Object())) continue;
                return false;
            }
            return this.isContainerReifiable(t.toClass());
        }
        return false;
    }

    private boolean isContainerReifiable(ClassType ct) {
        if (!ct.isInnerClass()) {
            return true;
        }
        return this.isReifiable(ct.container());
    }

    @Override
    public ClassType instantiateInnerClassFromContext(Context c, ClassType ct) {
        ClassType outer = ct.outer();
        while (c != null) {
            for (ClassType fromCtx = c.currentClass(); fromCtx != null; fromCtx = (ClassType)fromCtx.superType()) {
                if (fromCtx instanceof JL5SubstClassType) {
                    JL5SubstClassType sct = (JL5SubstClassType)fromCtx;
                    JL5ParsedClassType rawCT = sct.base();
                    if (!outer.equals(rawCT)) continue;
                    return (ClassType)sct.subst().substType(ct);
                }
                if (!(fromCtx instanceof JL5ParsedClassType) || !outer.equals(fromCtx)) continue;
                return ct;
            }
            c = c.pop();
        }
        return ct;
    }

    @Override
    public Annotations createAnnotations(Map<Type, Map<String, AnnotationElementValue>> annotationElems, Position pos) {
        return new Annotations_c(annotationElems, this, pos);
    }

    @Override
    public boolean isRetainedAnnotation(Type annotationType) {
        if (annotationType.isClass() && annotationType.toClass().isSubtype(this.Annotation())) {
            JL5ClassType ct = (JL5ClassType)annotationType.toClass();
            Annotations ra = ct.annotations();
            if (ra == null) {
                return true;
            }
            AnnotationElementValue v = ra.singleElement(this.RetentionAnnotation());
            if (v == null) {
                return true;
            }
            if (v instanceof AnnotationElementValueConstant) {
                AnnotationElementValueConstant c = (AnnotationElementValueConstant)v;
                EnumInstance ei = (EnumInstance)c.constantValue();
                return ei.name().equalsIgnoreCase("CLASS") || ei.name().equalsIgnoreCase("RUNTIME");
            }
            return true;
        }
        return false;
    }

    @Override
    public Annotations NoAnnotations() {
        return new Annotations_c(this, Position.compilerGenerated(1));
    }

    @Override
    public AnnotationElementValueArray AnnotationElementValueArray(Position pos, List<AnnotationElementValue> vals) {
        return new AnnotationElementValueArray_c(this, pos, vals);
    }

    @Override
    public AnnotationElementValueAnnotation AnnotationElementValueAnnotation(Position pos, Type annotationType, Map<String, AnnotationElementValue> annotationElementValues) {
        return new AnnotationElementValueAnnotation_c(this, pos, annotationType, annotationElementValues);
    }

    @Override
    public AnnotationElementValueConstant AnnotationElementValueConstant(Position pos, Type type, Object constVal) {
        return new AnnotationElementValueConstant_c(this, pos, type, constVal);
    }

    @Override
    public Type leastCommonAncestor(Type type1, Type type2) throws SemanticException {
        if (type1.isPrimitive() && (type2.isReference() || type2.isNull())) {
            return this.leastCommonAncestor(this.boxingConversion(type1), type2);
        }
        if (type2.isPrimitive() && (type1.isReference() || type1.isNull())) {
            return this.leastCommonAncestor(type1, this.boxingConversion(type2));
        }
        return super.leastCommonAncestor(type1, type2);
    }
}

