/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import polyglot.ext.jl5.types.JL5ConstructorInstance;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5Subst;
import polyglot.ext.jl5.types.JL5Subst_c;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.util.CachingTransformingList;
import polyglot.util.SerialVersionUID;
import polyglot.util.Transformation;

public class JL5RawSubst_c
extends JL5Subst_c {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private final JL5ParsedClassType base;
    private final Transformation<Type, Type> TypeErase = new Transformation<Type, Type>(){

        @Override
        public Type transform(Type o) {
            return ((JL5TypeSystem)JL5RawSubst_c.this.typeSystem()).erasureType(o);
        }
    };

    public JL5RawSubst_c(JL5TypeSystem ts, Map<TypeVariable, ReferenceType> subst, JL5ParsedClassType base) {
        super(ts, (Map<TypeVariable, ? extends ReferenceType>)subst);
        this.base = base;
    }

    @Override
    protected ClassType substClassTypeImpl(ClassType t) {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        if (this.base.equals(t)) {
            return ts.rawClass(this.base);
        }
        return super.substClassTypeImpl(t);
    }

    @Override
    public <T extends MethodInstance> T substMethod(T mi) {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        if (!this.base.equals(mi.container())) {
            return super.substMethod(mi);
        }
        if (mi.flags().isStatic()) {
            MethodInstance result = (MethodInstance)mi.declaration();
            return (T)result;
        }
        JL5MethodInstance mj = (JL5MethodInstance)mi.declaration();
        Type rt = ts.erasureType(mj.returnType());
        List<? extends Type> formalTypes = mj.formalTypes();
        formalTypes = this.eraseTypeList(formalTypes);
        List<? extends Type> throwTypes = mj.throwTypes();
        throwTypes = this.eraseTypeList(throwTypes);
        JL5MethodInstance tmpMi = (JL5MethodInstance)mj.copy();
        tmpMi.setReturnType(rt);
        tmpMi.setFormalTypes(formalTypes);
        tmpMi.setThrowTypes(throwTypes);
        tmpMi.setContainer(ts.rawClass(this.base));
        tmpMi.setTypeParams(this.substTypeList(tmpMi.typeParams()));
        JL5Subst eraseMI = ts.erasureSubst(tmpMi);
        if (eraseMI != null) {
            tmpMi = eraseMI.substMethod(tmpMi);
        }
        JL5MethodInstance result = tmpMi;
        return (T)result;
    }

    @Override
    public <T extends ConstructorInstance> T substConstructor(T ci) {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        if (!this.base.equals(ci.container())) {
            return super.substConstructor(ci);
        }
        JL5ConstructorInstance cj = (JL5ConstructorInstance)ci.declaration();
        List<? extends Type> formalTypes = cj.formalTypes();
        formalTypes = this.eraseTypeList(formalTypes);
        List<? extends Type> throwTypes = cj.throwTypes();
        throwTypes = this.eraseTypeList(throwTypes);
        JL5ConstructorInstance tmpCi = (JL5ConstructorInstance)cj.copy();
        tmpCi.setFormalTypes(formalTypes);
        tmpCi.setThrowTypes(throwTypes);
        tmpCi.setContainer(ts.rawClass(this.base));
        for (TypeVariable o : tmpCi.typeParams()) {
            if (o instanceof TypeVariable) continue;
            System.err.println("Pi is " + tmpCi + " and type params is " + tmpCi.typeParams() + " " + o + " " + o.getClass());
            System.err.println("Subst is " + this);
            Thread.dumpStack();
        }
        tmpCi.setTypeParams(this.substTypeList(tmpCi.typeParams()));
        JL5Subst eraseCI = ts.erasureSubst(tmpCi);
        if (eraseCI != null) {
            tmpCi = eraseCI.substConstructor(tmpCi);
        }
        JL5ConstructorInstance result = tmpCi;
        return (T)result;
    }

    public List<Type> eraseTypeList(List<? extends Type> list) {
        return new CachingTransformingList<Type, Type>((Collection<Type>)list, this.TypeErase);
    }
}

