/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import polyglot.ext.jl5.types.AnnotationTypeElemInstance;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5ClassType;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5Subst;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.reflect.JL5LazyClassInitializer;
import polyglot.ext.param.types.PClass;
import polyglot.frontend.Source;
import polyglot.types.ClassType;
import polyglot.types.LazyClassInitializer;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType_c;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.SerialVersionUID;

public class JL5ParsedClassType_c
extends ParsedClassType_c
implements JL5ParsedClassType {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected PClass<TypeVariable, ReferenceType> pclass;
    protected List<TypeVariable> typeVars = Collections.emptyList();
    protected List<EnumInstance> enumConstants;
    protected List<AnnotationTypeElemInstance> annotationElems = new LinkedList<AnnotationTypeElemInstance>();
    protected boolean annotationsResolved = false;
    protected Annotations annotations;

    public JL5ParsedClassType_c(TypeSystem ts, LazyClassInitializer init, Source fromSource) {
        super(ts, init, fromSource);
        this.enumConstants = new LinkedList<EnumInstance>();
    }

    @Override
    public void addEnumConstant(EnumInstance ei) {
        if (!this.fields.contains(ei)) {
            this.addField(ei);
        }
        this.enumConstants.add(ei);
    }

    @Override
    public List<EnumInstance> enumConstants() {
        if (this.init instanceof JL5LazyClassInitializer) {
            ((JL5LazyClassInitializer)this.init).initEnumConstants();
        }
        return this.enumConstants;
    }

    @Override
    public EnumInstance enumConstantNamed(String name) {
        for (EnumInstance ei : this.enumConstants()) {
            if (!ei.name().equals(name)) continue;
            return ei;
        }
        return null;
    }

    @Override
    public AnnotationTypeElemInstance annotationElemNamed(String name) {
        for (AnnotationTypeElemInstance ai : this.annotationElems()) {
            if (!ai.name().equals(name)) continue;
            return ai;
        }
        return null;
    }

    @Override
    public void addAnnotationElem(AnnotationTypeElemInstance ai) {
        this.addMethod(ai);
        this.annotationElems.add(ai);
    }

    @Override
    public List<AnnotationTypeElemInstance> annotationElems() {
        if (this.init instanceof JL5LazyClassInitializer) {
            ((JL5LazyClassInitializer)this.init).initAnnotationElems();
        }
        return Collections.unmodifiableList(this.annotationElems);
    }

    @Override
    public List<? extends JL5MethodInstance> methods(JL5MethodInstance mi) {
        LinkedList<JL5MethodInstance> l = new LinkedList<JL5MethodInstance>();
        for (JL5MethodInstance pi : this.methodsNamed(mi.name())) {
            if (!pi.hasFormals(mi.formalTypes())) continue;
            l.add(pi);
        }
        return l;
    }

    public List<JL5MethodInstance> methodsNamed(String name) {
        List<? extends MethodInstance> result = super.methodsNamed(name);
        return result;
    }

    @Override
    public boolean isEnclosedImpl(ClassType maybe_outer) {
        if (super.isEnclosedImpl(maybe_outer)) {
            return true;
        }
        if (this.outer() != null && super.outer() != this.outer()) {
            return super.outer().equals(maybe_outer) || super.outer().isEnclosed(maybe_outer);
        }
        return false;
    }

    @Override
    public boolean isCastValidImpl(Type toType) {
        if (super.isCastValidImpl(toType)) {
            return true;
        }
        return this.isSubtype(toType) || toType.isSubtype(this);
    }

    @Override
    public boolean isImplicitCastValidImpl(Type toType) {
        throw new InternalCompilerError("Should not be called in JL5");
    }

    @Override
    public LinkedList<Type> isImplicitCastValidChainImpl(Type toType) {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        LinkedList<Type> chain = null;
        if (ts.isSubtype(this, toType)) {
            chain = new LinkedList<Type>();
            chain.add(this);
            chain.add(toType);
        } else if (toType.isPrimitive() && ts.primitiveTypeOfWrapper(this) != null && (chain = ts.isImplicitCastValidChain(ts.primitiveTypeOfWrapper(this), toType)) != null) {
            chain.addFirst(this);
        }
        return chain;
    }

    @Override
    public PClass<TypeVariable, ReferenceType> pclass() {
        return this.pclass;
    }

    @Override
    public void setPClass(PClass<TypeVariable, ReferenceType> pc) {
        this.pclass = pc;
    }

    @Override
    public void setTypeVariables(List<TypeVariable> typeVars) {
        if (typeVars == null) {
            this.typeVars = Collections.emptyList();
        } else {
            this.typeVars = ListUtil.copy(typeVars, true);
            for (TypeVariable tv : typeVars) {
                tv.setDeclaringClass(this);
            }
        }
    }

    @Override
    public List<TypeVariable> typeVariables() {
        if (this.typeVars == null) {
            return Collections.emptyList();
        }
        return this.typeVars;
    }

    @Override
    public JL5Subst erasureSubst() {
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        return ts.erasureSubst(this);
    }

    @Override
    public void print(CodeWriter w) {
        this.printNoParams(w);
        if (this.typeVars == null || this.typeVars.isEmpty()) {
            return;
        }
        w.write("<");
        Iterator<TypeVariable> it = this.typeVars.iterator();
        while (it.hasNext()) {
            TypeVariable act = it.next();
            w.write(act.name());
            if (!it.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.write(">");
    }

    @Override
    public void printNoParams(CodeWriter w) {
        super.print(w);
    }

    @Override
    public String toStringNoParams() {
        return super.toString();
    }

    @Override
    public String toString() {
        if (this.typeVars == null || this.typeVars.isEmpty()) {
            return super.toString();
        }
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append('<');
        Iterator<TypeVariable> it = this.typeVars.iterator();
        while (it.hasNext()) {
            TypeVariable act = it.next();
            sb.append(act);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public boolean isRawClass() {
        return false;
    }

    @Override
    public String translateAsReceiver(Resolver c) {
        JL5TypeSystem ts;
        JL5ClassType erased;
        if (this.isMember() && (erased = (JL5ClassType)(ts = (JL5TypeSystem)this.typeSystem()).erasureType(this)) != this) {
            return erased.translateAsReceiver(c);
        }
        return super.translate(c);
    }

    @Override
    public String translate(Resolver c) {
        JL5ParsedClassType pct;
        ReferenceType container;
        if (this.isMember() && this.flags.isStatic() && (container = this.container()) instanceof JL5ParsedClassType && !(pct = (JL5ParsedClassType)container).typeVariables().isEmpty()) {
            return container.translate(c) + "." + this.name();
        }
        return super.translate(c);
    }

    @Override
    public boolean descendsFromImpl(Type ancestor) {
        RawClass rawClass;
        JL5TypeSystem ts;
        if (super.descendsFromImpl(ancestor)) {
            return true;
        }
        return !this.typeVariables().isEmpty() && (ts = (JL5TypeSystem)this.ts).isSubtype(rawClass = ts.rawClass(this, this.position), ancestor);
    }

    @Override
    public Annotations annotations() {
        if (this.init instanceof JL5LazyClassInitializer) {
            ((JL5LazyClassInitializer)this.init).initAnnotations();
        }
        return this.annotations;
    }

    @Override
    public void setAnnotations(Annotations annotations) {
        this.annotations = annotations;
    }

    @Override
    public boolean enumValueOfMethodNeeded() {
        for (MethodInstance mi : this.methods) {
            if (!mi.name().equals("valueOf") || mi.formalTypes().size() != 1) continue;
            Type t = mi.formalTypes().get(0);
            if (!this.ts.String().equals(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean enumValuesMethodNeeded() {
        for (MethodInstance mi : this.methods) {
            if (!mi.name().equals("values") || !mi.formalTypes().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean annotationsResolved() {
        return this.annotationsResolved;
    }

    @Override
    public void setAnnotationsResolved(boolean annotationsResolved) {
        this.annotationsResolved = annotationsResolved;
    }

    public Set<Type> superclasses() {
        if (this.superType() == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.superType());
    }
}

