/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.JL5ConstructorInstance;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5Subst;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.JL5TypeSystem_c;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.ConstructorInstance_c;
import polyglot.types.Flags;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class JL5ConstructorInstance_c
extends ConstructorInstance_c
implements JL5ConstructorInstance {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<TypeVariable> typeParams;
    protected Annotations annotations;

    public JL5ConstructorInstance_c(JL5TypeSystem_c ts, Position pos, ClassType container, Flags flags, List<? extends Type> argTypes, List<? extends Type> excTypes, List<? extends TypeVariable> typeParams) {
        super((TypeSystem)ts, pos, container, flags, argTypes, excTypes);
        this.typeParams = ListUtil.copy(typeParams, true);
        for (TypeVariable typeVariable : typeParams) {
            typeVariable.setDeclaringProcedure((JL5ProcedureInstance)((Object)this.declaration()));
        }
    }

    @Override
    public boolean isVariableArity() {
        return JL5Flags.isVarArgs(this.flags());
    }

    @Override
    public boolean callValidImpl(List<? extends Type> argTypes) {
        List myFormalTypes = this.formalTypes;
        if (!this.isVariableArity() && argTypes.size() != myFormalTypes.size()) {
            return false;
        }
        if (this.isVariableArity() && argTypes.size() < myFormalTypes.size() - 1) {
            return false;
        }
        Iterator formalTypes = myFormalTypes.iterator();
        Iterator<? extends Type> actualTypes = argTypes.iterator();
        Type formal = null;
        while (actualTypes.hasNext()) {
            ArrayType arr;
            Type actual = actualTypes.next();
            if (formalTypes.hasNext()) {
                formal = (Type)formalTypes.next();
            }
            if (!formalTypes.hasNext() && this.isVariableArity()) {
                arr = (ArrayType)myFormalTypes.get(myFormalTypes.size() - 1);
                formal = arr.base();
            }
            if (this.ts.isImplicitCastValid(actual, formal)) continue;
            if (this.isVariableArity() && myFormalTypes.size() == argTypes.size() && !formalTypes.hasNext()) {
                arr = (ArrayType)myFormalTypes.get(myFormalTypes.size() - 1);
                if (this.ts.isImplicitCastValid(actual, arr)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isSameConstructorImpl(ConstructorInstance ci) {
        if (!(ci instanceof JL5ConstructorInstance)) {
            return false;
        }
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        return ts.areOverrideEquivalent(this, (JL5ConstructorInstance)ci);
    }

    @Override
    public boolean isCanonical() {
        return super.isCanonical() && this.listIsCanonical(this.typeParams);
    }

    @Override
    public void setTypeParams(List<TypeVariable> typeParams) {
        this.typeParams = typeParams;
        for (TypeVariable tv : typeParams) {
            tv.setDeclaringProcedure((JL5ProcedureInstance)((Object)this.declaration()));
        }
    }

    @Override
    public List<TypeVariable> typeParams() {
        return Collections.unmodifiableList(this.typeParams);
    }

    @Override
    public JL5Subst erasureSubst() {
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        return ts.erasureSubst(this);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.designator());
        sb.append(" ");
        sb.append(this.flags.translate());
        if (!this.typeParams.isEmpty()) {
            sb.append("<");
            Iterator<TypeVariable> iter = this.typeParams().iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("> ");
        }
        sb.append(this.signature());
        if (!this.throwTypes.isEmpty()) {
            sb.append(" throws ");
            Iterator i = this.throwTypes.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                sb.append(o.toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    @Override
    public Annotations annotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(Annotations annotations) {
        this.annotations = annotations;
    }
}

