/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import polyglot.ext.jl5.types.AnnotationTypeElemInstance;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.IntersectionType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ClassType_c;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.Package;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class IntersectionType_c
extends ClassType_c
implements IntersectionType {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<ReferenceType> bounds;
    protected TypeVariable boundOf_;

    public IntersectionType_c(TypeSystem ts, Position pos, List<ReferenceType> bounds) {
        super(ts, pos);
        this.bounds = bounds;
        this.checkBounds();
    }

    private void checkBounds() {
        if (this.bounds == null || this.bounds.size() < 2) {
            throw new InternalCompilerError("Intersection type needs at least two elements: " + this.bounds);
        }
    }

    @Override
    public List<ReferenceType> bounds() {
        if (this.bounds == null || this.bounds.size() == 0) {
            this.bounds = new ArrayList<ReferenceType>();
            this.bounds.add(this.ts.Object());
        }
        return this.bounds;
    }

    @Override
    public boolean isEnclosedImpl(ClassType maybe_outer) {
        for (ReferenceType bound : this.bounds) {
            if (bound.isClass() && bound.toClass().isEnclosed(maybe_outer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String translate(Resolver c) {
        StringBuffer sb = new StringBuffer();
        Iterator<ReferenceType> iter = this.bounds.iterator();
        while (iter.hasNext()) {
            Type b = iter.next();
            sb.append(b.translate(c));
            if (!iter.hasNext()) continue;
            sb.append(" & ");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" ( ");
        Iterator<ReferenceType> iter = this.bounds.iterator();
        while (iter.hasNext()) {
            Type b = iter.next();
            sb.append(b);
            if (!iter.hasNext()) continue;
            sb.append(" & ");
        }
        sb.append(" ) ");
        return sb.toString();
    }

    @Override
    public Type superType() {
        if (this.bounds.isEmpty()) {
            return this.ts.Object();
        }
        Type t = this.bounds.get(0);
        if (t.isClass() && !t.toClass().flags().isInterface()) {
            return t;
        }
        return this.ts.Object();
    }

    @Override
    public List<? extends ConstructorInstance> constructors() {
        return Collections.emptyList();
    }

    @Override
    public List<? extends FieldInstance> fields() {
        return Collections.emptyList();
    }

    @Override
    public Flags flags() {
        return Flags.PUBLIC.set(Flags.FINAL);
    }

    @Override
    public List<? extends ReferenceType> interfaces() {
        ArrayList<ClassType> interfaces = new ArrayList<ClassType>();
        for (Type type : this.bounds) {
            if (!type.isClass() || !type.toClass().flags().isInterface()) continue;
            interfaces.add((ClassType)type);
        }
        return interfaces;
    }

    @Override
    public ClassType.Kind kind() {
        return INTERSECTION;
    }

    @Override
    public List<? extends ClassType> memberClasses() {
        return Collections.emptyList();
    }

    @Override
    public List<? extends MethodInstance> methods() {
        return Collections.emptyList();
    }

    @Override
    public String name() {
        return this.toString();
    }

    @Override
    public ClassType outer() {
        return null;
    }

    @Override
    public Package package_() {
        return null;
    }

    @Override
    public boolean inStaticContext() {
        return false;
    }

    @Override
    public LinkedList<Type> isImplicitCastValidChainImpl(Type toType) {
        for (Type type : this.bounds()) {
            if (!this.typeSystem().isImplicitCastValid(type, toType)) continue;
            LinkedList<Type> chain = new LinkedList<Type>();
            chain.add(this);
            chain.add(toType);
            return chain;
        }
        return null;
    }

    @Override
    public boolean isSubtypeImpl(Type ancestor) {
        for (Type type : this.bounds()) {
            if (!this.typeSystem().isSubtype(type, ancestor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCastValidImpl(Type toType) {
        for (Type type : this.bounds()) {
            if (!this.typeSystem().isCastValid(type, toType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void boundOf(TypeVariable tv) {
        this.boundOf_ = tv;
    }

    @Override
    public TypeVariable boundOf() {
        return this.boundOf_;
    }

    @Override
    public boolean equalsImpl(TypeObject other) {
        if (!super.equalsImpl(other) && other instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)other;
            if (it.bounds().size() != this.bounds().size()) {
                return false;
            }
            for (int i = 0; i < this.bounds().size(); ++i) {
                Type ti = this.bounds().get(i);
                Type tj = it.bounds().get(i);
                if (this.typeSystem().equals(ti, tj)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean typeEqualsImpl(Type other) {
        if (!super.typeEqualsImpl(other) && other instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)other;
            if (it.bounds().size() != this.bounds().size()) {
                return false;
            }
            for (int i = 0; i < this.bounds().size(); ++i) {
                Type ti = this.bounds().get(i);
                Type tj = it.bounds().get(i);
                if (this.typeSystem().typeEquals(ti, tj)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.bounds().hashCode();
    }

    @Override
    public void setFlags(Flags flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContainer(ReferenceType container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Job job() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBounds(List<ReferenceType> newBounds) {
        this.bounds = newBounds;
        this.checkBounds();
    }

    @Override
    public boolean isRawClass() {
        return false;
    }

    @Override
    public EnumInstance enumConstantNamed(String name) {
        return null;
    }

    @Override
    public List<EnumInstance> enumConstants() {
        return Collections.emptyList();
    }

    @Override
    public String translateAsReceiver(Resolver resolver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AnnotationTypeElemInstance annotationElemNamed(String name) {
        return null;
    }

    @Override
    public List<AnnotationTypeElemInstance> annotationElems() {
        return Collections.emptyList();
    }

    @Override
    public Annotations annotations() {
        return ((JL5TypeSystem)this.typeSystem()).NoAnnotations();
    }

    public Set<Type> superclasses() {
        LinkedHashSet<Type> classes = new LinkedHashSet<Type>();
        for (Type type : this.bounds) {
            if (!type.isClass() || type.toClass().flags().isInterface()) continue;
            classes.add(type);
        }
        return classes;
    }
}

