/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import polyglot.ext.jl5.types.AnnotationElementValue;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.Type;
import polyglot.types.TypeObject_c;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class Annotations_c
extends TypeObject_c
implements Annotations {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private Map<Type, Map<String, AnnotationElementValue>> annotations;

    public Annotations_c(JL5TypeSystem ts, Position pos) {
        super(ts, pos);
        this.annotations = Collections.emptyMap();
    }

    public Annotations_c(Map<Type, Map<String, AnnotationElementValue>> annotations, JL5TypeSystem ts, Position pos) {
        super(ts, pos);
        this.annotations = annotations;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public Set<Type> annotationTypes() {
        return Collections.unmodifiableSet(this.annotations.keySet());
    }

    @Override
    public Set<Type> retainedAnnotationTypes() {
        LinkedHashSet<Type> retAnnType = new LinkedHashSet<Type>(this.annotations.keySet());
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        Iterator iter = retAnnType.iterator();
        while (iter.hasNext()) {
            Type t = (Type)iter.next();
            if (ts.isRetainedAnnotation(t)) continue;
            iter.remove();
        }
        return Collections.unmodifiableSet(retAnnType);
    }

    @Override
    public Map<String, AnnotationElementValue> elementValuePairs(Type annotationType) {
        if (this.annotations.containsKey(annotationType)) {
            return Collections.unmodifiableMap(this.annotations.get(annotationType));
        }
        return null;
    }

    @Override
    public boolean hasAnnotationType(Type annotationType) {
        return this.annotations.containsKey(annotationType);
    }

    @Override
    public AnnotationElementValue singleElement(Type annotationType) {
        if (this.annotations.containsKey(annotationType)) {
            return this.annotations.get(annotationType).get("value");
        }
        return null;
    }
}

