/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.translate;

import java.util.ArrayList;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.JL5NodeFactory;
import polyglot.ext.jl5.types.IntersectionType;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.WildCardType;
import polyglot.ext.jl5.types.inference.LubType;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Job;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class JL5ToJL5Rewriter
extends ExtensionRewriter {
    public JL5ToJL5Rewriter(Job job, ExtensionInfo from_ext, ExtensionInfo to_ext) {
        super(job, from_ext, to_ext);
    }

    @Override
    public TypeNode typeToJava(Type t, Position pos) {
        JL5NodeFactory to_nf = (JL5NodeFactory)this.to_nf();
        if (t instanceof IntersectionType) {
            IntersectionType ct = (IntersectionType)t.toClass();
            ArrayList<TypeNode> bounds = new ArrayList<TypeNode>(ct.bounds().size());
            for (ReferenceType referenceType : ct.bounds()) {
                bounds.add(this.typeToJava(referenceType, pos));
            }
            return to_nf.ParamTypeNode(pos, to_nf.Id(pos, ct.name()), bounds);
        }
        if (t instanceof LubType) {
            throw new InternalCompilerError("I don't understand what to do here");
        }
        if (t instanceof WildCardType) {
            WildCardType wc = (WildCardType)t;
            if (wc.isSuperConstraint()) {
                TypeNode superNode = this.typeToJava(wc.lowerBound(), pos);
                return to_nf.AmbWildCardSuper(pos, superNode);
            }
            if (wc.isExtendsConstraint()) {
                TypeNode extendsNode = this.typeToJava(wc.upperBound(), pos);
                return to_nf.AmbWildCardExtends(pos, extendsNode);
            }
            return to_nf.AmbWildCard(pos);
        }
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            return to_nf.AmbTypeNode(pos, to_nf.Id(pos, tv.name()));
        }
        if (t.isClass()) {
            if (t instanceof JL5ParsedClassType) {
                JL5ParsedClassType ct = (JL5ParsedClassType)t.toClass();
                ArrayList<TypeNode> tvs = new ArrayList<TypeNode>(ct.typeVariables().size());
                for (ReferenceType referenceType : ct.typeVariables()) {
                    tvs.add(this.typeToJava(referenceType, pos));
                }
                return to_nf.TypeNodeFromQualifiedName(pos, ct.fullName(), tvs);
            }
            if (t instanceof JL5SubstClassType) {
                JL5SubstClassType ct = (JL5SubstClassType)t.toClass();
                ArrayList<TypeNode> actuals = new ArrayList<TypeNode>(ct.actuals().size());
                for (ReferenceType referenceType : ct.actuals()) {
                    actuals.add(this.typeToJava(referenceType, pos));
                }
                return to_nf.TypeNodeFromQualifiedName(pos, ct.fullName(), actuals);
            }
            if (t instanceof RawClass) {
                return to_nf.TypeNodeFromQualifiedName(pos, t.toClass().fullName());
            }
            throw new InternalCompilerError("Unknown class type: " + t.getClass());
        }
        return super.typeToJava(t, pos);
    }
}

