/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.translate;

import java.util.Collections;
import java.util.List;
import polyglot.ext.jl5.JL5ExtensionInfo;
import polyglot.ext.jl5.JL5Options;
import polyglot.ext.jl5.JL5Scheduler;
import polyglot.frontend.EmptyPass;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Job;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.goals.SourceFileGoal;
import polyglot.main.OptFlag;
import polyglot.main.Options;
import polyglot.main.UsageError;
import polyglot.util.InternalCompilerError;

public class JL5OutputExtensionInfo
extends JL5ExtensionInfo {
    protected final ExtensionInfo parent;

    public JL5OutputExtensionInfo(ExtensionInfo parent) {
        this.parent = parent;
    }

    @Override
    public Scheduler createScheduler() {
        return new JL5OutputScheduler(this);
    }

    @Override
    protected Options createOptions() {
        Options parentOpts = this.parent.getOptions();
        JL5OutputOptions opt = new JL5OutputOptions(this);
        List<OptFlag.Arg<?>> arguments = parentOpts.filterArgs(opt.flags());
        try {
            opt.processArguments(arguments, Collections.emptySet());
        }
        catch (UsageError e) {
            throw new InternalCompilerError("Got usage error while configuring output extension", e);
        }
        return opt;
    }

    protected static class JL5OutputScheduler
    extends JL5Scheduler {
        public JL5OutputScheduler(JL5ExtensionInfo extInfo) {
            super(extInfo);
        }

        @Override
        public Goal Parsed(Job job) {
            return this.internGoal(new SourceFileGoal(job){

                @Override
                public Pass createPass(ExtensionInfo extInfo) {
                    return new EmptyPass(this);
                }
            });
        }
    }

    protected static class JL5OutputOptions
    extends JL5Options {
        public JL5OutputOptions(ExtensionInfo extension) {
            super(extension);
        }

        @Override
        protected void validateArgs() throws UsageError {
        }
    }
}

