/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.parse;

import java.util.LinkedList;
import java.util.List;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.types.Flags;
import polyglot.util.Position;

public class FlagAnnotations {
    protected Flags classicFlags = Flags.NONE;
    protected List<AnnotationElem> annotations = new LinkedList<AnnotationElem>();

    public FlagAnnotations() {
    }

    public FlagAnnotations(Position pos) {
        this();
        this.classicFlags = this.classicFlags.position(pos);
    }

    public Flags flags() {
        return this.classicFlags;
    }

    public FlagAnnotations flags(Flags flags) {
        this.classicFlags = flags;
        return this;
    }

    public FlagAnnotations setFlag(Flags flags) {
        Flags f = this.flags().set(flags);
        return this.flags(f);
    }

    public FlagAnnotations annotations(List<AnnotationElem> annotations) {
        this.annotations = annotations;
        return this;
    }

    public List<AnnotationElem> annotations() {
        return this.annotations;
    }

    public FlagAnnotations addAnnotation(AnnotationElem o) {
        this.annotations.add(o);
        return this;
    }

    public Position position() {
        Position flagsPos = null;
        if (this.classicFlags != null && !this.classicFlags.flags().isEmpty()) {
            flagsPos = this.classicFlags.position();
        }
        if (this.annotations == null || this.annotations.isEmpty()) {
            return flagsPos;
        }
        AnnotationElem firstAnnotation = this.annotations.get(0);
        AnnotationElem lastAnnotation = this.annotations.get(this.annotations.size() - 1);
        return new Position(firstAnnotation.position(), new Position(lastAnnotation.position(), flagsPos));
    }
}

