/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.ext.jl5.ast.ParamTypeNode;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.ArrayType;
import polyglot.types.Context;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class ParamTypeNode_c
extends TypeNode_c
implements ParamTypeNode {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Id id;
    protected List<TypeNode> bounds;

    public ParamTypeNode_c(Position pos, Id id, List<TypeNode> bounds) {
        super(pos);
        assert (bounds != null);
        this.id = id;
        this.bounds = ListUtil.copy(bounds, true);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public ParamTypeNode id(Id id) {
        return this.id(this, id);
    }

    protected <N extends ParamTypeNode_c> N id(N n, Id id) {
        N ext = n;
        if (ext.id == id) {
            return n;
        }
        if (n == this) {
            ext = n = Copy.Util.copy(n);
        }
        ext.id = id;
        return n;
    }

    @Override
    public List<TypeNode> bounds() {
        return this.bounds;
    }

    @Override
    public ParamTypeNode bounds(List<TypeNode> bounds) {
        return this.bounds(this, bounds);
    }

    protected <N extends ParamTypeNode_c> N bounds(N n, List<TypeNode> bounds) {
        N ext = n;
        if (CollectionUtil.equals(ext.bounds, bounds)) {
            return n;
        }
        if (n == this) {
            ext = n = Copy.Util.copy(n);
        }
        ext.bounds = ListUtil.copy(bounds, true);
        return n;
    }

    protected <N extends ParamTypeNode_c> N reconstruct(N n, List<TypeNode> bounds) {
        n = this.bounds(n, bounds);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<TypeNode> bounds = this.visitList(this.bounds, v);
        return this.reconstruct(this, bounds);
    }

    @Override
    public Context enterScope(Context c) {
        c = ((JL5Context)c).pushTypeVariable((TypeVariable)this.type());
        return super.enterScope(c);
    }

    @Override
    public void addDecls(Context c) {
        super.addDecls(c);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
        ParamTypeNode_c n = this;
        Position position = n.position();
        ArrayList<ReferenceType> typeList = new ArrayList<ReferenceType>(this.bounds.size());
        for (int i = 0; i < this.bounds.size(); ++i) {
            typeList.add(ts.unknownReferenceType(position));
        }
        ReferenceType intersection = ts.intersectionType(position, typeList);
        TypeVariable iType = ts.typeVariable(position, this.id.id(), intersection);
        return n.type(iType);
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)ar.typeSystem();
        ParamTypeNode_c n = this;
        boolean ambiguous = false;
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (TypeNode tn : this.bounds) {
            if (!tn.isDisambiguated()) {
                ambiguous = true;
            }
            typeList.add(tn.type());
        }
        if (!ambiguous) {
            TypeVariable tv = (TypeVariable)n.type();
            ArrayList<ReferenceType> refTypeList = new ArrayList<ReferenceType>();
            for (Type t : typeList) {
                refTypeList.add((ReferenceType)t);
            }
            tv.setUpperBound(ts.intersectionType(n.position(), refTypeList));
        }
        return n;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeNode ti;
        int i;
        for (i = 0; i < this.bounds.size(); ++i) {
            ti = this.bounds.get(i);
            for (int j = i + 1; j < this.bounds.size(); ++j) {
                TypeNode tj = this.bounds.get(j);
                if (!tc.typeSystem().equals(ti.type(), tj.type())) continue;
                throw new SemanticException("Duplicate bound in type variable declaration", tj.position());
            }
        }
        for (i = 0; i < this.bounds.size(); ++i) {
            ti = this.bounds.get(i);
            if (!(ti.type() instanceof ArrayType)) continue;
            throw new SemanticException("Unexpected type bound in type variable declaration", ti.position());
        }
        for (i = 0; i < this.bounds.size(); ++i) {
            TypeNode tn = this.bounds.get(i);
            if (i <= 0 || tn.type().toClass().flags().isInterface()) continue;
            throw new SemanticException("Interface expected here.", tn.position());
        }
        if (this.bounds.size() > 1 && this.bounds.get(0).type() instanceof TypeVariable) {
            throw new SemanticException("Cannot specify any additional bound when first bound is a type variable.", this.bounds.get(1).position());
        }
        return super.typeCheck(tc);
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        ParamTypeNode_c n = this;
        return rw.typeToJava(n.type(), n.position());
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.id.id());
        if (this.bounds() != null && !this.bounds().isEmpty()) {
            w.write(" extends ");
            Iterator<TypeNode> it = this.bounds.iterator();
            while (it.hasNext()) {
                TypeNode tn = it.next();
                this.print(tn, w, tr);
                if (!it.hasNext()) continue;
                w.write(" & ");
            }
        }
    }
}

