/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Unary;
import polyglot.ast.Variable;
import polyglot.ext.jl5.ast.JL5ExprExt;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.TypeChecker;

public class JL5UnaryExt
extends JL5ExprExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        Unary u = (Unary)this.node();
        Unary.Operator op = u.operator();
        Expr expr = u.expr();
        if (!ts.isPrimitiveWrapper(expr.type())) {
            return this.superLang().typeCheck(this.node(), tc);
        }
        if (op == Unary.POST_INC || op == Unary.POST_DEC || op == Unary.PRE_INC || op == Unary.PRE_DEC) {
            if (!(expr.type().isNumeric() || ts.isPrimitiveWrapper(expr.type()) && ts.primitiveTypeOfWrapper(expr.type()).isNumeric())) {
                throw new SemanticException("Operand of " + op + " operator must be numeric.", expr.position());
            }
            if (!(expr instanceof Variable)) {
                throw new SemanticException("Operand of " + op + " operator must be a variable.", expr.position());
            }
            if (((Variable)expr).flags().isFinal()) {
                throw new SemanticException("Operand of " + op + " operator must be a non-final variable.", expr.position());
            }
            return u.type(expr.type());
        }
        if (op == Unary.BIT_NOT) {
            if (!ts.isImplicitCastValid(expr.type(), ts.Long())) {
                throw new SemanticException("Operand of " + op + " operator must be numeric.", expr.position());
            }
            if (ts.isPrimitiveWrapper(expr.type())) {
                return u.type(ts.promote(ts.primitiveTypeOfWrapper(expr.type())));
            }
            return u.type(ts.promote(expr.type()));
        }
        if (op == Unary.NEG || op == Unary.POS) {
            if (!(expr.type().isNumeric() || ts.isPrimitiveWrapper(expr.type()) && ts.primitiveTypeOfWrapper(expr.type()).isNumeric())) {
                throw new SemanticException("Operand of " + op + " operator must be numeric.", expr.position());
            }
            if (ts.isPrimitiveWrapper(expr.type())) {
                return u.type(ts.promote(ts.primitiveTypeOfWrapper(expr.type())));
            }
            return u.type(ts.promote(expr.type()));
        }
        if (op == Unary.NOT) {
            if (!(expr.type().isBoolean() || ts.isPrimitiveWrapper(expr.type()) && ts.primitiveTypeOfWrapper(expr.type()).isBoolean())) {
                throw new SemanticException("Operand of " + op + " operator must be boolean.", expr.position());
            }
            return u.type(ts.Boolean());
        }
        return u;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        JL5TypeSystem ts = (JL5TypeSystem)av.typeSystem();
        Unary u = (Unary)this.node();
        Unary.Operator op = u.operator();
        Expr expr = u.expr();
        try {
            if (child == expr) {
                Type childType = child.type();
                if (ts.isPrimitiveWrapper(childType)) {
                    childType = ts.primitiveTypeOfWrapper(childType);
                }
                if (op == Unary.POST_INC || op == Unary.POST_DEC || op == Unary.PRE_INC || op == Unary.PRE_DEC) {
                    if (ts.isImplicitCastValid(childType, av.toType())) {
                        return ts.promote(childType);
                    }
                    return av.toType();
                }
                if (op == Unary.NEG || op == Unary.POS) {
                    if (ts.isImplicitCastValid(childType, av.toType())) {
                        return ts.promote(childType);
                    }
                    return av.toType();
                }
                if (op == Unary.BIT_NOT) {
                    if (ts.isImplicitCastValid(childType, av.toType())) {
                        return ts.promote(childType);
                    }
                    return av.toType();
                }
                if (op == Unary.NOT) {
                    return ts.Boolean();
                }
            }
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        return child.type();
    }
}

