/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Node;
import polyglot.ast.ProcedureCall;
import polyglot.ast.ProcedureCallOps;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.ast.JL5ProcedureCall;
import polyglot.ext.jl5.ast.JL5TermExt;
import polyglot.types.ReferenceType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.ListUtil;
import polyglot.util.SerialVersionUID;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public abstract class JL5ProcedureCallExt
extends JL5TermExt
implements JL5ProcedureCall,
ProcedureCallOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<TypeNode> typeArgs;

    public JL5ProcedureCallExt(List<TypeNode> typeArgs) {
        this.typeArgs = ListUtil.copy(typeArgs, true);
    }

    @Override
    public ProcedureCall node() {
        return (ProcedureCall)super.node();
    }

    @Override
    public List<TypeNode> typeArgs() {
        return this.typeArgs;
    }

    @Override
    public ProcedureCall typeArgs(List<TypeNode> typeArgs) {
        return this.typeArgs(this.node(), typeArgs);
    }

    protected <N extends Node> N typeArgs(N n, List<TypeNode> typeArgs) {
        JL5ProcedureCallExt ext = (JL5ProcedureCallExt)JL5Ext.ext(n);
        if (CollectionUtil.equals(ext.typeArgs, typeArgs)) {
            return n;
        }
        if (n == this.node) {
            n = Copy.Util.copy(n);
            ext = (JL5ProcedureCallExt)JL5Ext.ext(n);
        }
        ext.typeArgs = ListUtil.copy(typeArgs, true);
        return n;
    }

    private Node reconstruct(Node n, List<TypeNode> typeArgs) {
        n = this.typeArgs(n, typeArgs);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<TypeNode> typeArgs = this.visitList(this.typeArgs, v);
        Node n = this.superLang().visitChildren(this.node(), v);
        return this.reconstruct(n, typeArgs);
    }

    protected List<ReferenceType> actualTypeArgs() {
        ProcedureCall n = this.node();
        JL5ProcedureCallExt ext = (JL5ProcedureCallExt)JL5Ext.ext(n);
        ArrayList<ReferenceType> actualTypeArgs = new ArrayList<ReferenceType>(ext.typeArgs().size());
        for (TypeNode tn : ext.typeArgs()) {
            actualTypeArgs.add((ReferenceType)tn.type());
        }
        return actualTypeArgs;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        ProcedureCall n = this.node();
        JL5ProcedureCallExt ext = (JL5ProcedureCallExt)JL5Ext.ext(n);
        if (ext.typeArgs() != null && !ext.typeArgs().isEmpty()) {
            w.write("<");
            Iterator<TypeNode> it = ext.typeArgs().iterator();
            while (it.hasNext()) {
                TypeNode tn = it.next();
                this.print(tn, w, tr);
                if (!it.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.write(">");
            w.allowBreak(0, " ");
        }
    }

    @Override
    public void printArgs(CodeWriter w, PrettyPrinter tr) {
        this.superLang().printArgs(this.node(), w, tr);
    }
}

