/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.JLang;
import polyglot.ast.Lang;
import polyglot.ast.New;
import polyglot.ast.NewOps;
import polyglot.ast.Node;
import polyglot.ast.Special;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AmbTypeInstantiation;
import polyglot.ext.jl5.ast.JL5NodeFactory;
import polyglot.ext.jl5.ast.JL5ProcedureCallExt;
import polyglot.ext.jl5.types.JL5ClassType;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class JL5NewExt
extends JL5ProcedureCallExt
implements NewOps {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JL5NewExt() {
        this((List<TypeNode>)null);
    }

    public JL5NewExt(List<TypeNode> typeArgs) {
        super(typeArgs);
    }

    @Override
    public New node() {
        return (New)super.node();
    }

    @Override
    public Node disambiguateOverride(Node parent, AmbiguityRemover ar) throws SemanticException {
        New n = (New)this.superLang().disambiguateOverride(this.node(), parent, ar);
        n = this.typeArgs(n, this.visitList(this.typeArgs, ar));
        return n;
    }

    @Override
    public TypeNode findQualifiedTypeNode(AmbiguityRemover ar, ClassType outer, TypeNode objectType) throws SemanticException {
        if (objectType instanceof AmbTypeInstantiation) {
            JL5TypeSystem ts = (JL5TypeSystem)ar.typeSystem();
            JL5NodeFactory nf = (JL5NodeFactory)ar.nodeFactory();
            Context c = ar.context();
            ts.findMemberClass(outer, objectType.name(), c.currentClass());
            if (outer instanceof ParsedClassType) {
                ParsedClassType opct = (ParsedClassType)outer;
                c = c.pushClass(opct, opct);
                objectType = (TypeNode)objectType.visit(ar.context(c));
                return objectType;
            }
            if (outer instanceof JL5SubstClassType) {
                JL5SubstClassType osct = (JL5SubstClassType)outer;
                if (!(objectType = (TypeNode)objectType.visit(ar.context(c = c.pushClass(osct.base(), osct.base())))).isDisambiguated()) {
                    return objectType;
                }
                LinkedHashMap substMap = new LinkedHashMap(osct.subst().substitutions());
                Type type = objectType.type();
                if (type instanceof JL5SubstClassType) {
                    JL5SubstClassType tsct = (JL5SubstClassType)type;
                    substMap.putAll(tsct.subst().substitutions());
                    type = tsct.base();
                }
                return nf.CanonicalTypeNode(type.position(), ts.subst(type, substMap));
            }
            if (outer instanceof RawClass) {
                throw new SemanticException("The member type " + outer + "." + objectType + " must be qualified with a parameterized type," + " since it is not static");
            }
        }
        return this.superLang().findQualifiedTypeNode(this.node(), ar, outer, objectType);
    }

    @Override
    public Expr findQualifier(AmbiguityRemover ar, ClassType ct) throws SemanticException {
        this.superLang().findQualifier(this.node(), ar, ct);
        return this.node().qualifier();
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        ConstructorInstance ci;
        ClassType ct;
        New n = this.node();
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        if (!n.objectType().type().isClass()) {
            throw new SemanticException("Must have a class for a new expression.", n.position());
        }
        ArrayList<Type> argTypes = new ArrayList<Type>(n.arguments().size());
        for (Expr e : n.arguments()) {
            argTypes.add(e.type());
        }
        List<ReferenceType> actualTypeArgs = this.actualTypeArgs();
        this.superLang().typeCheckFlags(this.node(), tc);
        this.superLang().typeCheckNested(this.node(), tc);
        if (n.body() != null) {
            ts.checkClassConformance(n.anonType());
        }
        if ((ct = n.objectType().type().toClass()).isInnerClass()) {
            ClassType outer = ct.outer();
            JL5TypeSystem ts5 = (JL5TypeSystem)tc.typeSystem();
            if (outer instanceof JL5SubstClassType) {
                JL5SubstClassType sct = (JL5SubstClassType)outer;
                ct = (ClassType)sct.subst().substType(ct);
            } else if (n.qualifier() == null || n.qualifier() instanceof Special && ((Special)n.qualifier()).kind() == Special.THIS) {
                ct = ts5.instantiateInnerClassFromContext(tc.context(), ct);
            } else if (n.qualifier().type() instanceof JL5SubstClassType) {
                JL5SubstClassType sct = (JL5SubstClassType)n.qualifier().type();
                ct = (ClassType)sct.subst().substType(ct);
            }
        }
        if (!ct.flags().isInterface()) {
            Context c = tc.context();
            if (n.anonType() != null) {
                c = c.pushClass(n.anonType(), n.anonType());
            }
            ci = ts.findConstructor(ct, argTypes, actualTypeArgs, c.currentClass(), n.body() == null);
        } else {
            ci = ts.defaultConstructor(n.position(), ct);
        }
        n = n.constructorInstance(ci);
        if (n.anonType() != null) {
            ct = n.anonType();
        }
        return n.type(ct);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printQualifier(w, tr);
        w.write("new ");
        super.prettyPrint(w, tr);
        New n = this.node();
        if (n.qualifier() != null && n.objectType().type() != null) {
            ((JLang)tr.lang()).printShortObjectType(this.node(), w, tr);
        } else {
            this.print(n.objectType(), w, tr);
        }
        this.printArgs(w, tr);
        this.printBody(w, tr);
    }

    @Override
    public ClassType findEnclosingClass(Context c, ClassType ct) {
        JL5ParsedClassType curClass;
        New n = this.node();
        if (n.anonType() != null) {
            return c.currentClass();
        }
        JL5TypeSystem ts = (JL5TypeSystem)ct.typeSystem();
        ClassType t = this.findEnclosingClassFrom(c.currentClass(), c, ct);
        if (t == null && ts.canBeRaw(curClass = (JL5ParsedClassType)c.currentClass())) {
            t = this.findEnclosingClassFrom(ts.rawClass(curClass), c, ct);
        }
        return t;
    }

    private ClassType findEnclosingClassFrom(ClassType t, Context c, ClassType ct) {
        JL5TypeSystem ts = (JL5TypeSystem)ct.typeSystem();
        String name = ct.name();
        while (t != null) {
            try {
                ClassType mt = ts.findMemberClass(t, name, c.currentClass());
                if (mt != null) {
                    mt = this.findMemberClass(name, t);
                    if (mt == null) {
                        throw new InternalCompilerError("Couldn't find member class " + name + " in " + t);
                    }
                    if (ts.isImplicitCastValid(mt, ct)) {
                        return t;
                    }
                    if (ts.isImplicitCastValid(ts.erasureType(mt), ts.erasureType(ct))) {
                        return (ClassType)ts.erasureType(t);
                    }
                }
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
            t = t.outer();
        }
        return null;
    }

    private ClassType findMemberClass(String name, ClassType t) {
        ClassType mt = t.memberClassNamed(name);
        if (mt != null) {
            return mt;
        }
        for (Type type : ((JL5ClassType)t).superclasses()) {
            if (!(type instanceof ClassType) || (mt = this.findMemberClass(name, type.toClass())) == null) continue;
            return mt;
        }
        for (Type type : t.interfaces()) {
            if (!(type instanceof ClassType) || (mt = this.findMemberClass(name, type.toClass())) == null) continue;
            return mt;
        }
        return null;
    }

    @Override
    public void typeCheckFlags(TypeChecker tc) throws SemanticException {
        this.superLang().typeCheckFlags(this.node(), tc);
    }

    @Override
    public void typeCheckNested(TypeChecker tc) throws SemanticException {
        this.superLang().typeCheckNested(this.node(), tc);
    }

    @Override
    public void printQualifier(CodeWriter w, PrettyPrinter tr) {
        this.superLang().printQualifier(this.node(), w, tr);
    }

    @Override
    public void printShortObjectType(CodeWriter w, PrettyPrinter tr) {
        New n = this.node();
        this.superLang().printShortObjectType(n, w, tr);
        ClassType ct = n.objectType().type().toClass();
        if (ct instanceof JL5SubstClassType) {
            JL5SubstClassType jsct = (JL5SubstClassType)ct;
            jsct.printParams(w);
        }
    }

    @Override
    public void printBody(CodeWriter w, PrettyPrinter tr) {
        this.superLang().printBody(this.node(), w, tr);
    }

    @Override
    public boolean constantValueSet(Lang lang) {
        return this.superLang().constantValueSet(this.node(), lang);
    }

    @Override
    public boolean isConstant(Lang lang) {
        return this.superLang().isConstant(this.node(), lang);
    }

    @Override
    public Object constantValue(Lang lang) {
        return this.superLang().constantValue(this.node(), lang);
    }
}

