/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.List;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.ast.JL5ProcedureDeclExt;
import polyglot.ext.jl5.ast.ParamTypeNode;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.Declaration;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.SerialVersionUID;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeChecker;

public class JL5MethodDeclExt
extends JL5ProcedureDeclExt {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected boolean compilerGenerated;

    public JL5MethodDeclExt() {
        this(null, null);
    }

    public JL5MethodDeclExt(List<ParamTypeNode> typeParams, List<AnnotationElem> annotations) {
        super(typeParams, annotations);
    }

    public boolean isGeneric() {
        return !this.typeParams.isEmpty();
    }

    public boolean isCompilerGenerated() {
        return this.compilerGenerated;
    }

    public MethodDecl setCompilerGenerated(boolean val) {
        MethodDecl n = (MethodDecl)this.node().copy();
        JL5MethodDeclExt ext = (JL5MethodDeclExt)JL5Ext.ext(n);
        ext.compilerGenerated = val;
        return n;
    }

    @Override
    protected Declaration declaration() {
        MethodDecl n = (MethodDecl)this.node();
        return n.methodInstance();
    }

    @Override
    protected Node buildTypesFinish(JL5TypeSystem ts, ParsedClassType ct, Flags flags, List<? extends Type> formalTypes, List<? extends Type> throwTypes, List<TypeVariable> typeParams) {
        MethodDecl md = (MethodDecl)this.node();
        if (ct.flags().isInterface()) {
            flags = flags.Public().Abstract();
        }
        JL5MethodInstance mi = ts.methodInstance(md.position(), ct, flags, ts.unknownType(md.position()), md.name(), formalTypes, throwTypes, typeParams);
        ct.addMethod(mi);
        return md.methodInstance(mi);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        MethodDecl md = (MethodDecl)super.typeCheck(tc);
        JL5MethodInstance mi = (JL5MethodInstance)md.methodInstance();
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        ts.checkMethodNameClash(mi, mi.container().toClass());
        return this.superLang().typeCheck(md, tc);
    }

    @Override
    public void translate(CodeWriter w, Translator tr) {
        MethodDecl md = (MethodDecl)this.node();
        JL5MethodDeclExt ext = (JL5MethodDeclExt)JL5Ext.ext(md);
        if (ext.isCompilerGenerated()) {
            return;
        }
        this.superLang().translate(this.node(), w, tr);
    }

    @Override
    protected void prettyPrintName(CodeWriter w, PrettyPrinter pp) {
        MethodDecl n = (MethodDecl)this.node();
        pp.print(n, n.returnType(), w);
        w.write(" " + n.name());
    }
}

