/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.List;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5AnnotatedElementExt;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.JL5LocalInstance;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.Declaration;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.SerialVersionUID;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class JL5LocalDeclExt
extends JL5AnnotatedElementExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JL5LocalDeclExt() {
        this((List<AnnotationElem>)null);
    }

    public JL5LocalDeclExt(List<AnnotationElem> annotations) {
        super(annotations);
    }

    @Override
    public void setAnnotations(Annotations annotations) {
        LocalDecl n = (LocalDecl)this.node();
        JL5LocalInstance li = (JL5LocalInstance)n.localInstance();
        li.setAnnotations(annotations);
    }

    @Override
    protected Declaration declaration() {
        LocalDecl n = (LocalDecl)this.node();
        return n.localInstance();
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        LocalDecl n = (LocalDecl)this.node();
        if (!n.flags().clear(Flags.FINAL).equals(Flags.NONE)) {
            throw new SemanticException("Modifier: " + n.flags().clearFinal() + " not allowed here.", n.position());
        }
        if (n.type().type() instanceof TypeVariable && tc.context().inStaticContext() && ((TypeVariable)n.type().type()).declaredIn().equals((Object)TypeVariable.TVarDecl.CLASS_TYPE_VARIABLE)) {
            throw new SemanticException("Cannot access non-static type: " + ((TypeVariable)n.type().type()).name() + " in a static context.", n.position());
        }
        return super.typeCheck(tc);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        super.prettyPrint(w, tr);
        this.superLang().prettyPrint((Node)this.node(), w, tr);
    }
}

