/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.LinkedList;
import polyglot.ast.Disamb_c;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.PackageNode;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.NoMemberException;
import polyglot.types.Qualifier;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.VarInstance;
import polyglot.util.InternalCompilerError;

public class JL5Disamb_c
extends Disamb_c {
    @Override
    protected Node disambiguatePackagePrefix(PackageNode pn) throws SemanticException {
        Named n;
        Resolver pc = this.ts.packageContextResolver(pn.package_());
        try {
            n = pc.find(this.name.id());
        }
        catch (SemanticException e) {
            return null;
        }
        Qualifier q = null;
        if (!(n instanceof Qualifier)) {
            return null;
        }
        q = (Qualifier)((Object)n);
        if (q.isPackage() && this.packageOK()) {
            return this.nf.PackageNode(this.pos, q.toPackage());
        }
        if (q.isType() && this.typeOK()) {
            return this.nf.CanonicalTypeNode(this.pos, this.makeRawIfNeeded(q.toType()));
        }
        return null;
    }

    @Override
    protected Node disambiguateTypeNodePrefix(TypeNode tn) throws SemanticException {
        Resolver tc;
        Named n;
        Type t;
        block9: {
            t = tn.type();
            if (t.isReference() && this.exprOK()) {
                try {
                    FieldInstance fi = ((JL5TypeSystem)this.ts).findFieldOrEnum(t.toReference(), this.name.id(), this.c.currentClass());
                    return this.nf.Field(this.pos, (Receiver)tn, this.name).fieldInstance(fi);
                }
                catch (NoMemberException e) {
                    if (e.getKind() == 3 || e.getKind() == 4) break block9;
                    throw e;
                }
            }
        }
        if (t.isClass() && this.typeOK() && (n = (tc = this.ts.classContextResolver(t.toClass())).find(this.name.id())) instanceof Type) {
            ClassType container;
            LinkedList<ClassType> typeQueue = new LinkedList<ClassType>();
            typeQueue.addLast(t.toClass());
            ClassType type = null;
            while (!typeQueue.isEmpty() && (type = (container = (ClassType)typeQueue.removeFirst()).toClass().memberClassNamed(this.name.id())) == null) {
                if (container.superType() != null && container.superType().isClass()) {
                    typeQueue.addLast(container.superType().toClass());
                }
                for (ReferenceType referenceType : container.interfaces()) {
                    if (!referenceType.isClass()) continue;
                    typeQueue.addLast(referenceType.toClass());
                }
            }
            if (type == null) {
                throw new InternalCompilerError("Expected to find member class " + this.name);
            }
            if (type.isInnerClass() && type.outer() instanceof JL5SubstClassType) {
                JL5SubstClassType sct = (JL5SubstClassType)type.outer();
                type = (ClassType)sct.subst().substType(type);
            }
            return this.nf.CanonicalTypeNode(this.pos, this.makeRawIfNeeded(type));
        }
        return null;
    }

    @Override
    protected Node disambiguateExprPrefix(Expr e) throws SemanticException {
        if (this.exprOK()) {
            return this.nf.Field(this.pos, (Receiver)e, this.name);
        }
        return null;
    }

    @Override
    protected Node disambiguateVarInstance(VarInstance vi) throws SemanticException {
        if (vi instanceof FieldInstance) {
            FieldInstance fi = (FieldInstance)vi;
            Receiver r = this.makeMissingFieldTarget(fi);
            return this.nf.Field(this.pos, r, this.name).fieldInstance(fi).targetImplicit(true);
        }
        if (vi instanceof LocalInstance) {
            LocalInstance li = (LocalInstance)vi;
            return this.nf.Local(this.pos, this.name).localInstance(li);
        }
        return null;
    }

    @Override
    protected Node disambiguateNoPrefix() throws SemanticException {
        TypeVariable res;
        block9: {
            VarInstance vi;
            Node n;
            if (this.exprOK() && (n = this.disambiguateVarInstance(vi = this.c.findVariableSilent(this.name.id()))) != null) {
                return n;
            }
            if (this.typeOK()) {
                try {
                    Named n2 = this.c.find(this.name.id());
                    if (n2 instanceof Type) {
                        Type type = (Type)((Object)n2);
                        if (!type.isCanonical()) {
                            throw new InternalCompilerError("Found an ambiguous type in the context: " + type, this.pos);
                        }
                        if (type.isClass() && type.toClass().isInnerClass()) {
                            type = ((JL5TypeSystem)this.ts).instantiateInnerClassFromContext(this.c, type.toClass());
                        }
                        return this.nf.CanonicalTypeNode(this.pos, this.makeRawIfNeeded(type));
                    }
                }
                catch (NoClassException e) {
                    if (this.name.id().equals(e.getClassName())) break block9;
                    throw e;
                }
            }
        }
        if ((res = ((JL5Context)this.c).findTypeVariableInThisScope(this.name.id())) != null) {
            return this.nf.CanonicalTypeNode(this.pos, res);
        }
        if (this.packageOK()) {
            return this.nf.PackageNode(this.pos, this.ts.packageForName(this.name.id()));
        }
        return null;
    }

    protected Type makeRawIfNeeded(Type type) {
        if (type.isClass()) {
            JL5TypeSystem ts = (JL5TypeSystem)type.typeSystem();
            if (type instanceof JL5ParsedClassType && !((JL5ParsedClassType)type).typeVariables().isEmpty()) {
                return ts.rawClass((JL5ParsedClassType)type, this.pos);
            }
            ClassType ct = type.toClass();
            if (ct.isInnerClass()) {
                ClassType t = ct;
                for (ClassType outer = ct.outer(); t.isInnerClass() && outer != null; outer = outer.outer()) {
                    if (outer instanceof RawClass) {
                        return ts.erasureType(ct);
                    }
                    t = outer;
                }
            }
        }
        return type;
    }
}

