/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorCall_c;
import polyglot.ast.Expr;
import polyglot.ast.IntLit;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.JL5Options;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.ast.JL5ProcedureCallExt;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class JL5ConstructorCallExt
extends JL5ProcedureCallExt {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected boolean isEnumConstructorCall;

    public JL5ConstructorCallExt() {
        this(null, false);
    }

    public JL5ConstructorCallExt(List<TypeNode> typeArgs, boolean isEnumConstructorCall) {
        super(typeArgs);
        this.isEnumConstructorCall = isEnumConstructorCall;
    }

    @Override
    public ConstructorCall node() {
        return (ConstructorCall)super.node();
    }

    public boolean isEnumConstructorCall() {
        return this.isEnumConstructorCall;
    }

    @Override
    public Context enterScope(Context c) {
        return ((JL5Context)c).pushCTORCall();
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        ConstructorCall cc = this.node();
        JL5ConstructorCallExt ext = (JL5ConstructorCallExt)JL5Ext.ext(cc);
        ClassType ct = ar.context().currentClass();
        if (ct != null && JL5Flags.isEnum(ct.flags()) && cc.arguments().isEmpty()) {
            ArrayList<Expr> args = new ArrayList<Expr>(2);
            args.add(ar.nodeFactory().NullLit(Position.compilerGenerated()));
            args.add(ar.nodeFactory().IntLit(Position.compilerGenerated(), IntLit.INT, 0L));
            cc = (ConstructorCall)cc.arguments(args);
            ext = (JL5ConstructorCallExt)JL5Ext.ext(cc);
            ext.isEnumConstructorCall = true;
            return this.superLang().disambiguate(cc, ar);
        }
        return this.superLang().disambiguate(this.node(), ar);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        ConstructorCall_c n = (ConstructorCall_c)this.node();
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        Context c = tc.context();
        ClassType ct = c.currentClass();
        Type superType = ct.superType();
        Expr qualifier = n.qualifier();
        ConstructorCall.Kind kind = n.kind();
        List<ReferenceType> actualTypeArgs = this.actualTypeArgs();
        if (qualifier != null) {
            if (!qualifier.isDisambiguated()) {
                return n;
            }
            if (kind != ConstructorCall.SUPER) {
                throw new SemanticException("Can only qualify a \"super\"constructor invocation.", n.position());
            }
            if (!superType.isClass() || !superType.toClass().isInnerClass() || superType.toClass().inStaticContext()) {
                throw new SemanticException("The class \"" + superType + "\"" + " is not an inner class, or was declared in a static " + "context; a qualified constructor invocation cannot " + "be used.", n.position());
            }
            Type qt = qualifier.type();
            if (!qt.isClass() || !qt.isSubtype(superType.toClass().outer())) {
                throw new SemanticException("The type of the qualifier \"" + qt + "\" does not match the immediately enclosing " + "class  of the super class \"" + superType.toClass().outer() + "\".", qualifier.position());
            }
        }
        if (kind == ConstructorCall.SUPER) {
            if (!superType.isClass()) {
                throw new SemanticException("Super type of " + ct + " is not a class.", n.position());
            }
            Expr q = qualifier;
            if (q == null && superType.isClass() && superType.toClass().isInnerClass()) {
                void var12_13;
                ClassType superContainer = superType.toClass().outer();
                ClassType classType = ct;
                while (!(var12_13 == null || var12_13.isImplicitCastValid(superContainer) && ct.hasEnclosingInstance((ClassType)var12_13))) {
                    ClassType classType2 = var12_13.outer();
                }
                if (var12_13 == null) {
                    throw new SemanticException(ct + " must have an enclosing instance" + " that is a subtype of " + superContainer, n.position());
                }
                if (var12_13 == ct) {
                    throw new SemanticException(ct + " is a subtype of " + superContainer + "; an enclosing instance that is a subtype of " + superContainer + " must be specified in the super constructor call.", n.position());
                }
            }
        }
        LinkedList<Type> argTypes = new LinkedList<Type>();
        for (Expr expr : n.arguments()) {
            if (!expr.isDisambiguated()) {
                return n;
            }
            argTypes.add(expr.type());
        }
        if (kind == ConstructorCall.SUPER) {
            ct = ct.superType().toClass();
        }
        ConstructorInstance ci = ts.findConstructor(ct, argTypes, actualTypeArgs, c.currentClass(), false);
        return n.constructorInstance(ci);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        ConstructorCall cc = this.node();
        JL5ConstructorCallExt ext = (JL5ConstructorCallExt)JL5Ext.ext(cc);
        if (ext.isEnumConstructorCall() && cc.constructorInstance() != null) {
            boolean translateEnums = ((JL5Options)cc.constructorInstance().typeSystem().extensionInfo().getOptions()).translateEnums;
            boolean removeJava5isms = ((JL5Options)cc.constructorInstance().typeSystem().extensionInfo().getOptions()).removeJava5isms;
            if (!removeJava5isms && translateEnums) {
                return;
            }
        }
        if (cc.qualifier() != null) {
            this.printSubExpr(cc.qualifier(), w, tr);
            w.write(".");
        }
        super.prettyPrint(w, tr);
        w.write(cc.kind().toString());
        this.printArgs(w, tr);
        w.write(";");
    }

    protected void printSubExpr(Expr expr, CodeWriter w, PrettyPrinter pp) {
        if (Precedence.LITERAL.isTighter(expr.precedence())) {
            w.write("(");
            this.printBlock(expr, w, pp);
            w.write(")");
        } else {
            this.print(expr, w, pp);
        }
    }
}

