/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeDecl;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.EnumConstantDecl;
import polyglot.ext.jl5.ast.JL5TermExt;
import polyglot.util.CodeWriter;
import polyglot.util.SerialVersionUID;
import polyglot.visit.PrettyPrinter;

public class JL5ClassBodyExt
extends JL5TermExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        ClassBody cb = (ClassBody)this.node();
        List<EnumConstantDecl> ecds = this.enumConstantDecls();
        if (ecds.isEmpty()) {
            this.superLang().prettyPrint((Node)this.node(), w, tr);
            return;
        }
        if (!cb.members().isEmpty()) {
            w.newline(4);
            w.begin(0);
            ClassMember prev = null;
            Iterator<ClassMember> i = ecds.iterator();
            while (i.hasNext()) {
                EnumConstantDecl ecd;
                prev = ecd = i.next();
                this.print(ecd, w, tr);
                w.write(i.hasNext() ? "," : ";");
                w.allowBreak(1);
            }
            if (!ecds.isEmpty()) {
                w.newline(0);
            }
            i = cb.members().iterator();
            while (i.hasNext()) {
                ClassMember member = i.next();
                if (member instanceof EnumConstantDecl) continue;
                if (member instanceof CodeDecl || prev instanceof CodeDecl) {
                    w.newline(0);
                }
                prev = member;
                this.printBlock(member, w, tr);
                if (!i.hasNext()) continue;
                w.newline(0);
            }
            w.end();
            w.newline(0);
        }
    }

    public List<EnumConstantDecl> enumConstantDecls() {
        ClassBody cb = (ClassBody)this.node();
        ArrayList<EnumConstantDecl> ecds = new ArrayList<EnumConstantDecl>();
        for (ClassMember m : cb.members()) {
            if (!(m instanceof EnumConstantDecl)) continue;
            ecds.add((EnumConstantDecl)m);
        }
        return ecds;
    }
}

