/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Call;
import polyglot.ast.CallOps;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.Lang;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.Return;
import polyglot.ast.Special;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.ast.JL5ProcedureCallExt;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl5.types.WildCardType;
import polyglot.ext.jl5.visit.JL5Translator;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.FunctionInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.SerialVersionUID;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class JL5CallExt
extends JL5ProcedureCallExt
implements CallOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private transient Type expectedReturnType = null;

    public JL5CallExt() {
        this((List<TypeNode>)null);
    }

    public JL5CallExt(List<TypeNode> typeArgs) {
        super(typeArgs);
    }

    @Override
    public Call node() {
        return (Call)super.node();
    }

    protected Type expectedReturnType() {
        return this.expectedReturnType;
    }

    protected void setExpectedReturnType(Type type) {
        if (type == null || !type.isCanonical()) {
            this.expectedReturnType = null;
            return;
        }
        this.expectedReturnType = type;
    }

    @Override
    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        Type type;
        CodeInstance ci;
        JL5CallExt ext = (JL5CallExt)JL5Ext.ext(this.node());
        if (parent instanceof Return && (ci = tc.context().currentCode()) instanceof FunctionInstance) {
            ext.setExpectedReturnType(((FunctionInstance)ci).returnType());
        }
        if (parent instanceof Assign) {
            Assign a = (Assign)parent;
            if (this.node() == a.right()) {
                type = a.left().type();
                if (type == null || !type.isCanonical()) {
                    return this.node();
                }
                ext.setExpectedReturnType(type);
            }
        }
        if (parent instanceof LocalDecl) {
            LocalDecl ld = (LocalDecl)parent;
            type = ld.type().type();
            if (type == null || !type.isCanonical()) {
                return this.node();
            }
            ext.setExpectedReturnType(type);
        }
        if (parent instanceof FieldDecl) {
            FieldDecl fd = (FieldDecl)parent;
            type = fd.type().type();
            if (type == null || !type.isCanonical()) {
                return this.node();
            }
            ext.setExpectedReturnType(type);
        }
        return null;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        Context c = tc.context();
        Call n = this.node();
        JL5CallExt ext = (JL5CallExt)JL5Ext.ext(n);
        ArrayList<Type> argTypes = new ArrayList<Type>(n.arguments().size());
        for (Expr e : n.arguments()) {
            if (!e.type().isCanonical()) {
                return n;
            }
            argTypes.add(e.type());
        }
        if (n.target() == null) {
            return tc.lang().typeCheckNullTarget(n, tc, argTypes);
        }
        if (!n.target().type().isCanonical()) {
            return n;
        }
        List<ReferenceType> actualTypeArgs = this.actualTypeArgs();
        ReferenceType targetType = tc.lang().findTargetType(n);
        boolean staticContext = n.target() instanceof TypeNode;
        if (staticContext && targetType instanceof RawClass) {
            targetType = ((RawClass)targetType).base();
        }
        JL5MethodInstance mi = (JL5MethodInstance)ts.findMethod(targetType, n.name(), argTypes, actualTypeArgs, c.currentClass(), ext.expectedReturnType(), !(n.target() instanceof Special));
        if (staticContext && !mi.flags().isStatic()) {
            throw new SemanticException("Cannot call non-static method " + n.name() + " of " + n.target().type() + " in static " + "context.", n.position());
        }
        if (n.target() instanceof Special && ((Special)n.target()).kind() == Special.SUPER && mi.flags().isAbstract()) {
            throw new SemanticException("Cannot call an abstract method of the super class", n.position());
        }
        Type returnType = this.computeReturnType(mi);
        n = (Call)n.methodInstance(mi).type(returnType);
        ext = (JL5CallExt)JL5Ext.ext(n);
        if (mi.name().equals("getClass") && mi.formalTypes().isEmpty()) {
            Type t = n.target().type();
            ReferenceType et = (ReferenceType)ts.erasureType(t);
            WildCardType wt = ts.wildCardType(n.position(), et, null);
            ClassType instClass = ts.instantiate(n.position(), (JL5ParsedClassType)ts.Class(), Collections.singletonList(wt));
            n = (Call)n.type(instClass);
        }
        return n;
    }

    protected Type computeReturnType(JL5MethodInstance mi) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)mi.typeSystem();
        if (mi.returnType().isVoid()) {
            return ts.Void();
        }
        return ts.applyCaptureConversion(mi.returnType(), this.node().position());
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        Call n = this.node();
        if (!n.isTargetImplicit()) {
            if (n.target() instanceof Expr) {
                n.printSubExpr((Expr)n.target(), w, tr);
            } else if (n.target() != null) {
                if (tr instanceof JL5Translator) {
                    JL5Translator jltr = (JL5Translator)tr;
                    jltr.printReceiver(n.target(), w);
                } else {
                    this.print(n.target(), w, tr);
                }
            }
            w.write(".");
            w.allowBreak(2, 3, "", 0);
            super.prettyPrint(w, tr);
        }
        w.begin(0);
        w.write(n.name());
        this.printArgs(w, tr);
        w.end();
    }

    @Override
    public Type findContainer(TypeSystem ts, MethodInstance mi) {
        JL5TypeSystem jts = (JL5TypeSystem)ts;
        return jts.erasureType(mi.container());
    }

    @Override
    public ReferenceType findTargetType() throws SemanticException {
        return this.superLang().findTargetType(this.node());
    }

    @Override
    public Node typeCheckNullTarget(TypeChecker tc, List<Type> argTypes) throws SemanticException {
        return this.superLang().typeCheckNullTarget(this.node(), tc, argTypes);
    }

    @Override
    public boolean constantValueSet(Lang lang) {
        return this.superLang().constantValueSet(this.node(), lang);
    }

    @Override
    public boolean isConstant(Lang lang) {
        return this.superLang().isConstant(this.node(), lang);
    }

    @Override
    public Object constantValue(Lang lang) {
        return this.superLang().constantValue(this.node(), lang);
    }
}

