/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Variable;
import polyglot.ext.jl5.ast.JL5ExprExt;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.TypeChecker;

public class JL5AssignExt
extends JL5ExprExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        Assign a = (Assign)this.node();
        Expr left = a.left();
        Expr right = a.right();
        Assign.Operator op = a.operator();
        if (child == left) {
            return child.type();
        }
        TypeSystem ts = av.typeSystem();
        if (op == Assign.ASSIGN) {
            return left.type();
        }
        if (op == Assign.ADD_ASSIGN && ts.typeEquals(ts.String(), left.type())) {
            return child.type();
        }
        if (op == Assign.ADD_ASSIGN || op == Assign.SUB_ASSIGN || op == Assign.MUL_ASSIGN || op == Assign.DIV_ASSIGN || op == Assign.MOD_ASSIGN || op == Assign.SHL_ASSIGN || op == Assign.SHR_ASSIGN || op == Assign.USHR_ASSIGN) {
            if (this.isNumeric(left.type()) && this.isNumeric(right.type())) {
                try {
                    return ts.promote(this.numericType(left.type()), this.numericType(child.type()));
                }
                catch (SemanticException e) {
                    throw new InternalCompilerError(e);
                }
            }
            return child.type();
        }
        if (op == Assign.BIT_AND_ASSIGN || op == Assign.BIT_OR_ASSIGN || op == Assign.BIT_XOR_ASSIGN) {
            if (left.type().isBoolean()) {
                return ts.Boolean();
            }
            if (this.isNumeric(left.type()) && this.isNumeric(right.type())) {
                try {
                    return ts.promote(this.numericType(left.type()), this.numericType(child.type()));
                }
                catch (SemanticException e) {
                    throw new InternalCompilerError(e);
                }
            }
            return child.type();
        }
        throw new InternalCompilerError("Unrecognized assignment operator " + op + ".");
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Assign a = (Assign)this.node();
        Type t = a.left().type();
        Type s = a.right().type();
        TypeSystem ts = tc.typeSystem();
        if (!(a.left() instanceof Variable)) {
            throw new SemanticException("Target of assignment must be a variable.", a.position());
        }
        if (a.operator() == Assign.ASSIGN) {
            if (!(ts.isImplicitCastValid(s, t) || ts.typeEquals(s, t) || ts.numericConversionValid(t, tc.lang().constantValue(a.right(), tc.lang())))) {
                throw new SemanticException("Cannot assign " + s + " to " + t + ".", a.position());
            }
            return a.type(t);
        }
        if (a.operator() == Assign.ADD_ASSIGN) {
            if (ts.typeEquals(t, ts.String()) && ts.canCoerceToString(s, tc.context())) {
                return a.type(ts.String());
            }
            if (this.isNumeric(t) && this.isNumeric(s)) {
                return a.type(ts.promote(this.numericType(t), this.numericType(s)));
            }
            throw new SemanticException("The " + a.operator() + " operator must have " + "numeric or String operands.", a.position());
        }
        if (a.operator() == Assign.SUB_ASSIGN || a.operator() == Assign.MUL_ASSIGN || a.operator() == Assign.DIV_ASSIGN || a.operator() == Assign.MOD_ASSIGN) {
            if (this.isNumeric(t) && this.isNumeric(s)) {
                return a.type(ts.promote(this.numericType(t), this.numericType(s)));
            }
            throw new SemanticException("The " + a.operator() + " operator must have " + "numeric operands.", a.position());
        }
        if (a.operator() == Assign.BIT_AND_ASSIGN || a.operator() == Assign.BIT_OR_ASSIGN || a.operator() == Assign.BIT_XOR_ASSIGN) {
            if (this.isBoolean(t) && this.isBoolean(s)) {
                return a.type(ts.Boolean());
            }
            if (ts.isImplicitCastValid(t, ts.Long()) && ts.isImplicitCastValid(s, ts.Long())) {
                return a.type(ts.promote(this.numericType(t), this.numericType(s)));
            }
            throw new SemanticException("The " + a.operator() + " operator must have " + "integral or boolean operands.", a.position());
        }
        if (a.operator() == Assign.SHL_ASSIGN || a.operator() == Assign.SHR_ASSIGN || a.operator() == Assign.USHR_ASSIGN) {
            if (ts.isImplicitCastValid(t, ts.Long()) && ts.isImplicitCastValid(s, ts.Long())) {
                return a.type(ts.promote(this.numericType(t)));
            }
            throw new SemanticException("The " + a.operator() + " operator must have " + "integral operands.", a.position());
        }
        throw new InternalCompilerError("Unrecognized assignment operator " + a.operator() + ".");
    }

    public boolean isNumeric(Type t) {
        if (t.isNumeric()) {
            return true;
        }
        JL5TypeSystem ts = (JL5TypeSystem)t.typeSystem();
        if (ts.isPrimitiveWrapper(t)) {
            return ts.primitiveTypeOfWrapper(t).isNumeric();
        }
        return false;
    }

    public boolean isBoolean(Type t) {
        if (t.isBoolean()) {
            return true;
        }
        JL5TypeSystem ts = (JL5TypeSystem)t.typeSystem();
        if (ts.isPrimitiveWrapper(t)) {
            return ts.primitiveTypeOfWrapper(t).isBoolean();
        }
        return false;
    }

    public Type numericType(Type t) {
        if (t.isNumeric()) {
            return t;
        }
        JL5TypeSystem ts = (JL5TypeSystem)t.typeSystem();
        if (ts.isPrimitiveWrapper(t)) {
            return ts.primitiveTypeOfWrapper(t);
        }
        return t;
    }
}

