/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.List;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ext.jl5.ast.AnnotatedElement;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.ast.JL5TermExt;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.visit.AnnotationChecker;
import polyglot.types.Declaration;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.ListUtil;
import polyglot.util.SerialVersionUID;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public abstract class JL5AnnotatedElementExt
extends JL5TermExt
implements AnnotatedElement {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<AnnotationElem> annotations;

    public JL5AnnotatedElementExt(List<AnnotationElem> annotations) {
        this.annotations = ListUtil.copy(annotations, true);
    }

    @Override
    public List<AnnotationElem> annotationElems() {
        return this.annotations;
    }

    @Override
    public Node annotationElems(List<AnnotationElem> annotations) {
        return this.annotationElems(this.node(), annotations);
    }

    protected <N extends Node> N annotationElems(N n, List<AnnotationElem> annotations) {
        JL5AnnotatedElementExt ext = (JL5AnnotatedElementExt)JL5Ext.ext(n);
        if (CollectionUtil.equals(ext.annotations, annotations)) {
            return n;
        }
        if (n == this.node) {
            n = Copy.Util.copy(n);
            ext = (JL5AnnotatedElementExt)JL5Ext.ext(n);
        }
        ext.annotations = ListUtil.copy(annotations, true);
        return n;
    }

    private Node reconstruct(Node n, List<AnnotationElem> annotations) {
        n = this.annotationElems(n, annotations);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Node n = this.superLang().visitChildren(this.node(), v);
        List<AnnotationElem> annots = this.visitList(this.annotations, v);
        return this.reconstruct(n, annots);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        ts.checkDuplicateAnnotations(this.annotations);
        return this.superLang().typeCheck(this.node(), tc);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        for (Term term : this.annotations) {
            tr.lang().prettyPrint((Node)term, w, tr);
            w.newline();
        }
    }

    @Override
    public Node annotationCheck(AnnotationChecker annoCheck) throws SemanticException {
        Term n = this.node();
        for (AnnotationElem elem : this.annotations) {
            annoCheck.checkAnnotationApplicability(elem, this.declaration());
        }
        return n;
    }

    protected abstract Declaration declaration();

    @Override
    public abstract void setAnnotations(Annotations var1);
}

