/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.List;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ext.jl5.ast.ElementValuePair;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.Copy;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeChecker;

public class ElementValuePair_c
extends Term_c
implements ElementValuePair {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Id name;
    protected Term value;

    public ElementValuePair_c(Position pos, Id name, Term value) {
        super(pos);
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public Id id() {
        return this.name;
    }

    public ElementValuePair id(Id name) {
        return this.id(this, name);
    }

    protected <N extends ElementValuePair_c> N id(N n, Id name) {
        N ext = n;
        if (ext.name == name) {
            return n;
        }
        if (n == this) {
            ext = n = Copy.Util.copy(n);
        }
        ext.name = name;
        return n;
    }

    @Override
    public Term value() {
        return this.value;
    }

    public ElementValuePair value(Term value) {
        return this.value(this, value);
    }

    protected <N extends ElementValuePair_c> N value(N n, Term value) {
        N ext = n;
        if (ext.value == value) {
            return n;
        }
        if (n == this) {
            ext = n = Copy.Util.copy(n);
        }
        ext.value = value;
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Term value = this.visitChild(this.value, v);
        return this.value(value);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        ts.checkAnnotationValueConstant(this.value);
        return this;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter pp) {
        w.write(this.name + "=");
        this.print(this.value, w, pp);
    }

    @Override
    public void translate(CodeWriter w, Translator tr) {
        w.write(this.name + "=");
        this.print(this.value, w, tr);
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.value, this, 0);
        return succs;
    }

    @Override
    public Term firstChild() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.name + "=" + this.value;
    }
}

