/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.ClassLit;
import polyglot.ast.Expr;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.ElementValueArrayInit;
import polyglot.ext.jl5.ast.ElementValuePair;
import polyglot.ext.jl5.types.AnnotationElementValue;
import polyglot.ext.jl5.types.AnnotationElementValueArray;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class AnnotationElem_c
extends Term_c
implements AnnotationElem {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected TypeNode typeName;
    protected List<ElementValuePair> elements;

    public AnnotationElem_c(Position pos, TypeNode typeName, List<ElementValuePair> elements) {
        super(pos);
        this.typeName = typeName;
        this.elements = ListUtil.copy(elements, true);
    }

    @Override
    public TypeNode typeName() {
        return this.typeName;
    }

    @Override
    public AnnotationElem typeName(TypeNode typeName) {
        return this.typeName(this, typeName);
    }

    protected <N extends AnnotationElem_c> N typeName(N n, TypeNode typeName) {
        N ext = n;
        if (ext.typeName == typeName) {
            return n;
        }
        if (n == this) {
            ext = n = Copy.Util.copy(n);
        }
        ext.typeName = typeName;
        return n;
    }

    @Override
    public List<ElementValuePair> elements() {
        return this.elements;
    }

    protected <N extends AnnotationElem_c> N elements(N n, List<ElementValuePair> elements) {
        N ext = n;
        if (CollectionUtil.equals(ext.elements, elements)) {
            return n;
        }
        if (n == this) {
            ext = n = Copy.Util.copy(n);
        }
        ext.elements = ListUtil.copy(elements, true);
        return n;
    }

    protected <N extends AnnotationElem_c> N reconstruct(N n, TypeNode typeName, List<ElementValuePair> elements) {
        n = this.typeName(n, typeName);
        n = this.elements(n, elements);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode tn = this.visitChild(this.typeName, v);
        List<ElementValuePair> elements = this.visitList(this.elements, v);
        return this.reconstruct(this, tn, elements);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        AnnotationElem_c n = this;
        if (!this.typeName.type().isClass() || !JL5Flags.isAnnotation(this.typeName.type().toClass().flags())) {
            throw new SemanticException("Annotation: " + this.typeName + " must be an annotation type, ", n.position());
        }
        return n;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter pp) {
        w.write("@");
        this.print(this.typeName, w, pp);
        if (this.isMarkerAnnotation()) {
            return;
        }
        w.write("(");
        if (this.isSingleElementAnnotation()) {
            ElementValuePair p = this.elements().get(0);
            this.print(p.value(), w, pp);
        } else {
            Iterator<ElementValuePair> it = this.elements().iterator();
            while (it.hasNext()) {
                this.print(it.next(), w, pp);
                if (!it.hasNext()) continue;
                w.write(", ");
            }
        }
        w.write(") ");
    }

    public Term entry() {
        return this;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        return succs;
    }

    @Override
    public String toString() {
        return "Annotation Type: " + this.typeName();
    }

    @Override
    public Term firstChild() {
        return this.typeName;
    }

    @Override
    public boolean isMarkerAnnotation() {
        return this.elements().isEmpty();
    }

    @Override
    public boolean isSingleElementAnnotation() {
        return this.elements().size() == 1 && this.elements().get(0).name().equals("value");
    }

    @Override
    public Map<String, AnnotationElementValue> toAnnotationElementValues(Lang lang, JL5TypeSystem ts) throws SemanticException {
        LinkedHashMap<String, AnnotationElementValue> m = new LinkedHashMap<String, AnnotationElementValue>();
        for (ElementValuePair p : this.elements()) {
            List<? extends MethodInstance> methods = this.typeName().type().toClass().methodsNamed(p.name());
            if (methods.size() != 1) {
                throw new InternalCompilerError("Annotation has more than one method named \"" + p.name() + "\": " + methods);
            }
            MethodInstance mi = methods.get(0);
            Type intendedType = mi.returnType();
            AnnotationElementValue v = this.toAnnotationElementValue(lang, p.value(), intendedType, ts);
            if (intendedType.isArray() && !(v instanceof AnnotationElementValueArray)) {
                v = ts.AnnotationElementValueArray(p.value().position(), Collections.singletonList(v));
            }
            m.put(p.name(), v);
        }
        return m;
    }

    private AnnotationElementValue toAnnotationElementValue(Lang lang, Term value, Type intendedType, JL5TypeSystem ts) throws SemanticException {
        Type intendedBaseType = intendedType.isArray() ? intendedType.toArray().base() : intendedType;
        if (value instanceof ElementValueArrayInit) {
            if (!intendedType.isArray()) {
                throw new SemanticException("Array given when expected type is " + intendedType.toString(), value.position());
            }
            ElementValueArrayInit init = (ElementValueArrayInit)value;
            ArrayList<AnnotationElementValue> vals = new ArrayList<AnnotationElementValue>();
            for (Term v : init.elements()) {
                vals.add(this.toAnnotationElementValue(lang, v, intendedBaseType, ts));
            }
            return ts.AnnotationElementValueArray(value.position(), vals);
        }
        if (value instanceof AnnotationElem) {
            AnnotationElem ae = (AnnotationElem)value;
            Type aeType = ae.typeName().type();
            if (aeType.isCanonical() && !ts.isImplicitCastValid(aeType, intendedBaseType)) {
                throw new SemanticException("Expected a value of type " + intendedBaseType, value.position());
            }
            return ts.AnnotationElementValueAnnotation(value.position(), aeType, ae.toAnnotationElementValues(lang, ts));
        }
        if (!(value instanceof Expr)) {
            throw new InternalCompilerError("Unexpected node: " + value + " : " + value.getClass(), value.position());
        }
        Expr ev = (Expr)value;
        ts.checkAnnotationValueConstant(ev);
        Object constVal = lang.constantValue(ev, lang);
        if (value instanceof ClassLit) {
            constVal = ((ClassLit)value).typeNode().type();
        }
        if (ev.type().isCanonical() && !ts.isImplicitCastValid(ev.type(), intendedBaseType)) {
            throw new SemanticException("Expected a value of type " + intendedBaseType, value.position());
        }
        AnnotationElementValue c = ts.AnnotationElementValueConstant(value.position(), intendedBaseType, constVal);
        return c;
    }
}

