/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import polyglot.ast.Ambiguous;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.WildCardType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.Copy;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class AmbWildCard
extends TypeNode_c
implements Ambiguous {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected TypeNode constraint;
    private boolean isExtendsConstraint;

    public AmbWildCard(Position pos) {
        this(pos, null, true);
    }

    public AmbWildCard(Position pos, TypeNode constraint, boolean isExtendsConstraint) {
        super(pos);
        this.constraint = constraint;
        this.isExtendsConstraint = isExtendsConstraint;
    }

    protected <N extends AmbWildCard> N constraint(N n, TypeNode constraint) {
        if (n.constraint == constraint) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.constraint = constraint;
        return n;
    }

    protected AmbWildCard reconstruct(TypeNode constraint) {
        AmbWildCard n = this;
        n = this.constraint(n, constraint);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode c = this.visitChild(this.constraint, v);
        return this.reconstruct(c);
    }

    @Override
    public Node disambiguate(AmbiguityRemover sc) throws SemanticException {
        WildCardType t;
        if (this.constraint != null && !this.constraint.isDisambiguated()) {
            return this;
        }
        JL5TypeSystem ts = (JL5TypeSystem)sc.typeSystem();
        if (this.constraint == null) {
            t = ts.wildCardType(this.position());
        } else {
            ReferenceType upperBound = null;
            ReferenceType lowerBound = null;
            if (this.isExtendsConstraint) {
                upperBound = (ReferenceType)this.constraint.type();
            } else {
                lowerBound = (ReferenceType)this.constraint.type();
            }
            t = ts.wildCardType(this.position(), upperBound, lowerBound);
        }
        return sc.nodeFactory().CanonicalTypeNode(this.position, t);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("?");
        if (this.constraint != null) {
            sb.append(" ");
            sb.append(this.isExtendsConstraint ? "extends" : "super");
            sb.append(" ");
            sb.append(this.constraint);
        }
        return sb.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("?");
        if (this.constraint != null) {
            w.write(" ");
            w.write(this.isExtendsConstraint ? "extends" : "super");
            w.write(" ");
            tr.lang().prettyPrint((Node)this.constraint, w, tr);
        }
    }
}

