/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.Ambiguous;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.ClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class AmbTypeInstantiation
extends TypeNode_c
implements Ambiguous {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected TypeNode base;
    protected List<TypeNode> typeArguments;

    public AmbTypeInstantiation(Position pos, TypeNode base, List<TypeNode> typeArguments) {
        super(pos);
        assert (typeArguments != null);
        this.base = base;
        this.typeArguments = typeArguments;
    }

    @Override
    public String name() {
        return this.base.name();
    }

    public TypeNode base() {
        return this.base;
    }

    protected <N extends AmbTypeInstantiation> N base(N n, TypeNode base) {
        if (n.base == base) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.base = base;
        return n;
    }

    public List<TypeNode> typeArguments() {
        return this.typeArguments;
    }

    protected <N extends AmbTypeInstantiation> N typeArguments(N n, List<TypeNode> typeArguments) {
        if (CollectionUtil.equals(n.typeArguments, typeArguments)) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.typeArguments = typeArguments;
        return n;
    }

    protected AmbTypeInstantiation reconstruct(TypeNode base, List<TypeNode> typeArguments) {
        AmbTypeInstantiation n = this;
        n = this.base(n, base);
        n = this.typeArguments(n, typeArguments);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode base = this.visitChild(this.base, v);
        List<TypeNode> arguments = this.visitList(this.typeArguments, v);
        return this.reconstruct(base, arguments);
    }

    @Override
    public Node disambiguate(AmbiguityRemover sc) throws SemanticException {
        if (!this.shouldDisambiguate()) {
            return this;
        }
        this.checkRareType(sc);
        LinkedHashMap<TypeVariable, ReferenceType> typeMap = new LinkedHashMap<TypeVariable, ReferenceType>();
        JL5ParsedClassType pct = this.handleBase(typeMap);
        Type baseType = this.base.type();
        if (pct.pclass() == null || pct.pclass().formals().isEmpty()) {
            throw new SemanticException("Cannot instantiate " + baseType + " because it has no formals", this.position);
        }
        this.checkParamSize(pct);
        if (!typeMap.isEmpty() && typeMap.keySet().containsAll(pct.typeVariables())) {
            throw new SemanticException("Cannot instantiate " + baseType + " with arguments " + this.typeArguments, this.position());
        }
        List<TypeVariable> formals = pct.typeVariables();
        for (int i = 0; i < this.typeArguments.size(); ++i) {
            ReferenceType t = (ReferenceType)this.typeArguments.get(i).type();
            typeMap.put(formals.get(i), t);
        }
        JL5TypeSystem ts = (JL5TypeSystem)sc.typeSystem();
        Type instantiated = ts.subst(pct, typeMap);
        return sc.nodeFactory().CanonicalTypeNode(this.position, instantiated);
    }

    protected boolean shouldDisambiguate() {
        if (!this.base.isDisambiguated()) {
            return false;
        }
        for (TypeNode tn : this.typeArguments) {
            if (tn.isDisambiguated()) continue;
            return false;
        }
        return true;
    }

    protected void checkRareType(AmbiguityRemover ar) throws SemanticException {
        JL5ParsedClassType outerBase;
        ClassType currentClass;
        ClassType outer;
        ClassType ct;
        JL5TypeSystem ts = (JL5TypeSystem)ar.typeSystem();
        Type baseType = this.base.type();
        if (baseType instanceof ClassType && (ct = (ClassType)baseType).isInnerClass() && (outer = ct.outer()) instanceof RawClass && !ts.typeEquals(currentClass = ar.context().currentClass(), outerBase = ((RawClass)outer).base()) && !ts.isEnclosed(currentClass, outerBase)) {
            throw new SemanticException("\"Rare\" types are not allowed: cannot provide type arguments to member class " + ct.name() + " of raw class " + ct.outer() + ".", this.position);
        }
    }

    protected JL5ParsedClassType handleBase(Map<TypeVariable, ReferenceType> typeMap) {
        Type baseType = this.base.type();
        if (baseType instanceof JL5ParsedClassType) {
            return (JL5ParsedClassType)baseType;
        }
        if (baseType instanceof RawClass) {
            return ((RawClass)baseType).base();
        }
        if (baseType instanceof JL5SubstClassType) {
            JL5SubstClassType sct = (JL5SubstClassType)baseType;
            typeMap.putAll(sct.subst().substitutions());
            return sct.base();
        }
        throw new InternalCompilerError("Don't know how to handle " + baseType, this.position);
    }

    protected void checkParamSize(JL5ParsedClassType pct) throws SemanticException {
        int pctFormalSize = pct.pclass().formals().size();
        if (pctFormalSize != this.typeArguments.size()) {
            throw new SemanticException("Wrong number of type parameters for class " + pct, this.position);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.base);
        sb.append("<");
        Iterator<TypeNode> iter = this.typeArguments.iterator();
        while (iter.hasNext()) {
            TypeNode tn = iter.next();
            sb.append(tn);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        tr.lang().prettyPrint((Node)this.base, w, tr);
        w.write("<");
        Iterator<TypeNode> iter = this.typeArguments.iterator();
        while (iter.hasNext()) {
            TypeNode tn = iter.next();
            tr.lang().prettyPrint((Node)tn, w, tr);
            if (!iter.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.write(">");
    }
}

